/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HdfsLocatedFileStatus
extends HdfsFileStatus {
    private LocatedBlocks locations;

    public HdfsLocatedFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, byte[] symlink, byte[] path, long fileId, LocatedBlocks locations, int childrenNum, boolean isStoredInDB, byte storagePolicy) {
        super(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, symlink, path, fileId, childrenNum, isStoredInDB, storagePolicy);
        this.locations = locations;
    }

    public LocatedBlocks getBlockLocations() {
        return this.locations;
    }

    public final LocatedFileStatus makeQualifiedLocated(URI defaultUri, Path path) throws IOException {
        return new LocatedFileStatus(this.getLen(), this.isDir(), (int)this.getReplication(), this.getBlockSize(), this.getModificationTime(), this.getAccessTime(), this.getPermission(), this.getOwner(), this.getGroup(), this.isSymlink() ? new Path(this.getSymlink()) : null, this.getFullPath(path).makeQualified(defaultUri, null), DFSUtil.locatedBlocks2Locations(this.getBlockLocations()));
    }
}

