/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.hdfs.dal.ActiveBlockReportsDataAccess;
import io.hops.metadata.hdfs.entity.ActiveBlockReport;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.blockmanagement.BRLoadBalancingOverloadException;

public class BRTrackingService {
    public static final Log LOG = LogFactory.getLog(BRTrackingService.class);
    private final long DB_VAR_UPDATE_THRESHOLD;
    private final long BR_MAX_PROCESSING_TIME;
    private int rrIndex = 0;
    private long lastChecked = 0L;
    private long cachedMaxConcurrentBRs = 0L;

    public BRTrackingService(long DB_VAR_UPDATE_THRESHOLD, long MAX_CONCURRENT_BRS, long BR_MAX_PROCESSING_TIME) {
        this.DB_VAR_UPDATE_THRESHOLD = DB_VAR_UPDATE_THRESHOLD;
        this.BR_MAX_PROCESSING_TIME = BR_MAX_PROCESSING_TIME;
        this.cachedMaxConcurrentBRs = MAX_CONCURRENT_BRS;
    }

    private int getRRIndex(SortedActiveNodeList nnList) {
        if (this.rrIndex < 0 || this.rrIndex >= nnList.size()) {
            this.rrIndex = 0;
        }
        return this.rrIndex++ % nnList.size();
    }

    private boolean canProcessMoreBR() throws IOException {
        List<ActiveBlockReport> allActiveBRs = this.getAllActiveBlockReports();
        if ((long)allActiveBRs.size() < this.getBrLbMaxConcurrentBRs()) {
            return true;
        }
        Iterator<ActiveBlockReport> itr = allActiveBRs.iterator();
        while (itr.hasNext()) {
            ActiveBlockReport abr = itr.next();
            if (System.currentTimeMillis() - abr.getStartTime() <= this.BR_MAX_PROCESSING_TIME) continue;
            this.removeActiveBlockReport(abr);
            itr.remove();
        }
        return (long)allActiveBRs.size() < this.getBrLbMaxConcurrentBRs();
    }

    private long getBrLbMaxConcurrentBRs() throws IOException {
        if (System.currentTimeMillis() - this.lastChecked > this.DB_VAR_UPDATE_THRESHOLD) {
            long value = HdfsVariables.getMaxConcurrentBrs();
            if (value != this.cachedMaxConcurrentBRs) {
                this.cachedMaxConcurrentBRs = value;
                LOG.info((Object)("BRTrackingService param update. Processing " + this.cachedMaxConcurrentBRs + " concurrent block reports"));
            }
            this.lastChecked = System.currentTimeMillis();
        }
        return this.cachedMaxConcurrentBRs;
    }

    public synchronized ActiveNode assignWork(SortedActiveNodeList nnList, String dnAddress, long noOfBlks) throws IOException {
        int index;
        if (this.canProcessMoreBR() && (index = this.getRRIndex(nnList)) >= 0 && index < nnList.size()) {
            ActiveNode an = (ActiveNode)nnList.getSortedActiveNodes().get(index);
            ActiveBlockReport abr = new ActiveBlockReport(dnAddress, an.getId(), System.currentTimeMillis(), noOfBlks);
            this.addActiveBlockReport(abr);
            LOG.info((Object)("Block report from " + dnAddress + " comtaining " + noOfBlks + " blocks is assigned to NN: " + an.getId()));
            return an;
        }
        String msg = "Work (" + noOfBlks + " blks) could not be assigned. System is fully loaded now. At most " + this.getBrLbMaxConcurrentBRs() + " concurrent block reports can be processed.";
        LOG.debug((Object)msg);
        throw new BRLoadBalancingOverloadException(msg);
    }

    public synchronized void blockReportCompleted(String dnAddress) throws IOException {
        ActiveBlockReport abr = new ActiveBlockReport(dnAddress, 0L, 0L, 0L);
        LOG.debug((Object)("Block report from " + dnAddress + " has completed"));
        this.removeActiveBlockReport(abr);
    }

    private int getActiveBlockReportsCount() throws IOException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.BR_LB_GET_COUNT){

            public Object performTask() throws IOException {
                ActiveBlockReportsDataAccess da = (ActiveBlockReportsDataAccess)HdfsStorageFactory.getDataAccess(ActiveBlockReportsDataAccess.class);
                return da.countActiveRports();
            }
        };
        return (Integer)handler.handle();
    }

    private List<ActiveBlockReport> getAllActiveBlockReports() throws IOException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.BR_LB_GET_ALL){

            public Object performTask() throws IOException {
                ActiveBlockReportsDataAccess da = (ActiveBlockReportsDataAccess)HdfsStorageFactory.getDataAccess(ActiveBlockReportsDataAccess.class);
                return da.getAll();
            }
        };
        return (List)handler.handle();
    }

    private void addActiveBlockReport(final ActiveBlockReport abr) throws IOException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.BR_LB_ADD){

            public Object performTask() throws IOException {
                ActiveBlockReportsDataAccess da = (ActiveBlockReportsDataAccess)HdfsStorageFactory.getDataAccess(ActiveBlockReportsDataAccess.class);
                da.addActiveReport(abr);
                return null;
            }
        };
        handler.handle();
    }

    private void removeActiveBlockReport(final ActiveBlockReport abr) throws IOException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.BR_LB_REMOVE){

            public Object performTask() throws IOException {
                ActiveBlockReportsDataAccess da = (ActiveBlockReportsDataAccess)HdfsStorageFactory.getDataAccess(ActiveBlockReportsDataAccess.class);
                da.removeActiveReport(abr);
                return null;
            }
        };
        handler.handle();
    }
}

