/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.common.FinderType;
import io.hops.transaction.EntityManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HashBuckets;
import org.apache.hadoop.hdfs.server.blockmanagement.ReplicaUnderConstruction;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class BlockInfoUnderConstruction
extends BlockInfo {
    private static final List<ReplicaUnderConstruction> EMPTY_REPLICAS_ARRAY = Collections.unmodifiableList(new ArrayList());
    private HdfsServerConstants.BlockUCState blockUCState;
    private int primaryNodeIndex = -1;
    private long blockRecoveryId = 0L;

    public BlockInfoUnderConstruction(Block blk, long inodeId) {
        this(blk, inodeId, HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION);
    }

    private BlockInfoUnderConstruction(Block blk, long inodeId, HdfsServerConstants.BlockUCState state) {
        super(blk, inodeId);
        assert (this.getBlockUCState() != HdfsServerConstants.BlockUCState.COMPLETE) : "BlockInfoUnderConstruction cannot be in COMPLETE state";
        this.blockUCState = state;
    }

    public BlockInfoUnderConstruction(Block blk, long inodeId, HdfsServerConstants.BlockUCState state, DatanodeStorageInfo[] targets) throws StorageException, TransactionContextException {
        this(blk, inodeId, state);
        this.setExpectedLocations(targets);
    }

    BlockInfo convertToCompleteBlock() throws StorageException, TransactionContextException {
        assert (this.getBlockUCState() != HdfsServerConstants.BlockUCState.COMPLETE) : "Trying to convert a COMPLETE block";
        this.complete();
        return new BlockInfo(this);
    }

    public void setExpectedLocations(DatanodeStorageInfo[] targets) throws StorageException, TransactionContextException {
        for (ReplicaUnderConstruction replicaUnderConstruction : this.getExpectedReplicas()) {
            EntityManager.remove((Object)((Object)replicaUnderConstruction));
        }
        for (DatanodeStorageInfo storage : targets) {
            this.addExpectedReplica(storage, HdfsServerConstants.ReplicaState.RBW, this.getGenerationStamp());
        }
    }

    public DatanodeStorageInfo[] getExpectedStorageLocations(DatanodeManager m) throws StorageException, TransactionContextException {
        List<ReplicaUnderConstruction> replicas = this.getExpectedReplicas();
        return super.getStorages(m, replicas);
    }

    public int getNumExpectedLocations() throws StorageException, TransactionContextException {
        return this.getExpectedReplicas().size();
    }

    @Override
    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return this.blockUCState;
    }

    public void setBlockUCStateNoPersistance(HdfsServerConstants.BlockUCState s) {
        this.blockUCState = s;
    }

    public long getBlockRecoveryId() {
        return this.blockRecoveryId;
    }

    public void setGenerationStampAndVerifyReplicas(long genStamp, DatanodeManager datanodeMgr) throws StorageException, TransactionContextException {
        this.setGenerationStamp(genStamp);
        List<ReplicaUnderConstruction> replicas = this.getExpectedReplicas();
        if (replicas == null) {
            return;
        }
        for (ReplicaUnderConstruction r : replicas) {
            if (genStamp == r.getGenerationStamp()) continue;
            r.getExpectedStorageLocation(datanodeMgr).removeBlock(this);
            NameNode.blockStateChangeLog.info((Object)("BLOCK* Removing stale replica from location: " + r.getStorageId() + " for block " + r.getBlockId()));
        }
    }

    void commitBlock(Block block, DatanodeManager datanodeMgr) throws IOException {
        if (this.getBlockId() != block.getBlockId()) {
            throw new IOException("Trying to commit inconsistent block: id = " + block.getBlockId() + ", expected id = " + this.getBlockId());
        }
        this.blockUCState = HdfsServerConstants.BlockUCState.COMMITTED;
        this.set(this.getBlockId(), block.getNumBytes(), block.getGenerationStamp());
        this.setGenerationStampAndVerifyReplicas(block.getGenerationStamp(), datanodeMgr);
    }

    public void initializeBlockRecovery(long recoveryId, DatanodeManager datanodeMgr) throws StorageException, TransactionContextException {
        int i;
        this.setBlockUCState(HdfsServerConstants.BlockUCState.UNDER_RECOVERY);
        List<ReplicaUnderConstruction> replicas = this.getExpectedReplicas();
        this.setBlockRecoveryId(recoveryId);
        if (replicas.isEmpty()) {
            NameNode.blockStateChangeLog.warn((Object)"BLOCK* BlockInfoUnderConstruction.initLeaseRecovery: No blocks found, lease removed.");
        }
        boolean allLiveReplicasTriedAsPrimary = true;
        for (i = 0; i < replicas.size(); ++i) {
            ReplicaUnderConstruction replica = replicas.get(i);
            DatanodeDescriptor dn = datanodeMgr.getDatanodeBySid(replica.getStorageId());
            if (dn == null || !dn.isAlive) continue;
            allLiveReplicasTriedAsPrimary = allLiveReplicasTriedAsPrimary && replicas.get(i).getChosenAsPrimary();
        }
        if (allLiveReplicasTriedAsPrimary) {
            for (i = 0; i < replicas.size(); ++i) {
                replicas.get(i).setChosenAsPrimary(false);
                this.update(replicas.get(i));
            }
        }
        long mostRecentLastUpdate = 0L;
        ReplicaUnderConstruction primary = null;
        DatanodeDescriptor primaryDn = null;
        this.primaryNodeIndex = -1;
        for (int i2 = 0; i2 < replicas.size(); ++i2) {
            ReplicaUnderConstruction replica = replicas.get(i2);
            DatanodeDescriptor dn = datanodeMgr.getDatanodeBySid(replica.getStorageId());
            if (dn == null || !dn.isAlive || replicas.get(i2).getChosenAsPrimary() || dn.getLastUpdate() <= mostRecentLastUpdate) continue;
            primary = replicas.get(i2);
            this.primaryNodeIndex = i2;
            primaryDn = dn;
            mostRecentLastUpdate = primaryDn.getLastUpdate();
        }
        if (primary != null) {
            primaryDn.addBlockToBeRecovered(this);
            primary.setChosenAsPrimary(true);
            this.update(primary);
            NameNode.blockStateChangeLog.info((Object)("BLOCK* " + this + " recovery started, primary=" + (Object)((Object)primary)));
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    @Override
    public String toString() {
        return "BlkInfoUnderConstruction " + super.toString();
    }

    private List<ReplicaUnderConstruction> getExpectedReplicas() throws StorageException, TransactionContextException {
        List<ReplicaUnderConstruction> replicas = (List<ReplicaUnderConstruction>)EntityManager.findList((FinderType)ReplicaUnderConstruction.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{this.getBlockId(), this.getInodeId()});
        if (replicas != null) {
            Collections.sort(replicas, ReplicaUnderConstruction.Order.ByStorageId);
        } else {
            replicas = EMPTY_REPLICAS_ARRAY;
        }
        return replicas;
    }

    protected void addExpectedReplica(DatanodeStorageInfo storage, HdfsServerConstants.ReplicaState rState, long genStamp) throws StorageException, TransactionContextException {
        this.addReplicaIfNotPresent(storage, rState, genStamp);
    }

    protected void addReplicaIfNotPresent(DatanodeStorageInfo storage, HdfsServerConstants.ReplicaState rState, long genStamp) throws StorageException, TransactionContextException {
        int sid = storage.getSid();
        HashSet<Integer> sidsOnDn = storage.getDatanodeDescriptor().getSidsOnNode();
        for (ReplicaUnderConstruction r : this.getExpectedReplicas()) {
            if (!sidsOnDn.contains(r.getStorageId())) continue;
            if (r.getStorageId() != sid || !r.getState().equals((Object)rState)) {
                r.setStorageId(sid);
                r.setState(rState);
            }
            r.setGenerationStamp(genStamp);
            this.update(r);
            return;
        }
        ReplicaUnderConstruction replica = new ReplicaUnderConstruction(rState, sid, this.getBlockId(), this.getInodeId(), HashBuckets.getInstance().getBucketForBlock(this), genStamp);
        this.update(replica);
    }

    public void setBlockRecoveryIdNoPersistance(long recoveryId) {
        this.blockRecoveryId = recoveryId;
    }

    public void setPrimaryNodeIndexNoPersistance(int nodeIndex) {
        this.primaryNodeIndex = nodeIndex;
    }

    public int getPrimaryNodeIndex() {
        return this.primaryNodeIndex;
    }

    private void complete() throws StorageException, TransactionContextException {
        for (ReplicaUnderConstruction rep : this.getExpectedReplicas()) {
            EntityManager.remove((Object)((Object)rep));
        }
    }

    void setBlockUCState(HdfsServerConstants.BlockUCState s) throws StorageException, TransactionContextException {
        this.setBlockUCStateNoPersistance(s);
        this.save();
    }

    private void setBlockRecoveryId(long recoveryId) throws StorageException, TransactionContextException {
        this.setBlockRecoveryIdNoPersistance(recoveryId);
        this.save();
    }
}

