/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.ProjectedINode;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.CachePool;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

class FSPermissionChecker {
    static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    private final UserGroupInformation ugi;
    private final String user;
    private final Set<String> groups;
    private final boolean isSuper;

    private static String toAccessControlString(INode inode) throws StorageException, TransactionContextException, IOException {
        return "\"" + inode.getLocalName() + "\":" + inode.getUserName() + ":" + inode.getGroupName() + ":" + (inode.isDirectory() ? "d" : "-") + inode.getFsPermission();
    }

    private static String toAccessControlString(ProjectedINode inode) throws StorageException, TransactionContextException, IOException {
        return "\"" + inode.getName() + "\":" + inode.getUserName() + ":" + inode.getGroupName() + ":" + (inode.isDirectory() ? "d" : "-") + new FsPermission(inode.getPermission());
    }

    private String toAccessControlString(INode inode, FsAction access, FsPermission mode) throws IOException {
        return this.toAccessControlString(inode, access, mode, null);
    }

    private String toAccessControlString(INode inode, FsAction access, FsPermission mode, List<AclEntry> featureEntries) throws IOException {
        StringBuilder sb = new StringBuilder("Permission denied: ").append("user=").append(this.user).append(", ").append("access=").append(access).append(", ").append("inode=\"").append(inode.getFullPathName()).append("\":").append(inode.getUserName()).append(':').append(inode.getGroupName()).append(':').append(inode.isDirectory() ? (char)'d' : '-').append(mode);
        if (featureEntries != null) {
            sb.append(':').append(StringUtils.join((CharSequence)",", featureEntries));
        }
        return sb.toString();
    }

    private String toAccessControlString(ProjectedINode inode, FsAction access, FsPermission mode, List<AclEntry> featureEntries) throws IOException {
        StringBuilder sb = new StringBuilder("Permission denied: ").append("user=").append(this.user).append(", ").append("access=").append(access).append(", ").append("projectedInode=\"").append(inode.getName()).append("\":").append(inode.getUserName()).append(':').append(inode.getGroupName()).append(':').append(inode.isDirectory() ? (char)'d' : '-').append(mode);
        if (featureEntries != null) {
            sb.append(':').append(StringUtils.join((CharSequence)",", featureEntries));
        }
        return sb.toString();
    }

    FSPermissionChecker(String fsOwner, String supergroup, UserGroupInformation callerUgi) {
        this.ugi = callerUgi;
        HashSet<String> s = new HashSet<String>(Arrays.asList(this.ugi.getGroupNames()));
        this.groups = Collections.unmodifiableSet(s);
        this.user = this.ugi.getShortUserName();
        this.isSuper = this.user.equals(fsOwner) || this.groups.contains(supergroup);
    }

    public boolean containsGroup(String group) {
        return this.groups.contains(group);
    }

    public String getUser() {
        return this.user;
    }

    public boolean isSuperUser() {
        return this.isSuper;
    }

    public void checkSuperuserPrivilege() throws AccessControlException {
        if (!this.isSuper) {
            throw new AccessControlException("Access denied for user " + this.user + ". Superuser privilege is required");
        }
    }

    void checkPermission(String path, FSDirectory dir, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir, boolean resolveLink) throws AccessControlException, UnresolvedLinkException, StorageException, TransactionContextException, IOException {
        int ancestorIndex;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ACCESS CHECK: " + this + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + ancestorAccess + ", parentAccess=" + parentAccess + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir + ", resolveLink=" + resolveLink));
        }
        INode[] inodes = dir.getINodesInPath(path, resolveLink).getINodes();
        for (ancestorIndex = inodes.length - 2; ancestorIndex >= 0 && inodes[ancestorIndex] == null; --ancestorIndex) {
        }
        this.checkTraverse(inodes, ancestorIndex);
        INode last = inodes[inodes.length - 1];
        if (parentAccess != null && parentAccess.implies(FsAction.WRITE) && inodes.length > 1 && last != null) {
            this.checkStickyBit(inodes[inodes.length - 2], last);
        }
        if (ancestorAccess != null && inodes.length > 1) {
            this.check(inodes, ancestorIndex, ancestorAccess);
        }
        if (parentAccess != null && inodes.length > 1) {
            this.check(inodes, inodes.length - 2, parentAccess);
        }
        if (access != null) {
            this.check(last, access);
        }
        if (subAccess != null) {
            this.checkSubAccess(last, subAccess, ignoreEmptyDir);
        }
        if (doCheckOwner) {
            this.checkOwner(last);
        }
    }

    void checkPermission(INode subtreeRoot, boolean doCheckOwner, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException, UnresolvedLinkException, StorageException, TransactionContextException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ACCESS CHECK: " + this + ", doCheckOwner=" + doCheckOwner + ", access=" + access + ", subAccess=" + subAccess + ", ignoreEmptyDir=" + ignoreEmptyDir));
        }
        if (access != null) {
            this.check(subtreeRoot, access);
        }
        if (subAccess != null) {
            this.checkSubAccess(subtreeRoot, subAccess, ignoreEmptyDir);
        }
        if (doCheckOwner) {
            this.checkOwner(subtreeRoot);
        }
    }

    private void checkOwner(INode inode) throws IOException {
        if (inode != null && this.user.equals(inode.getUserName())) {
            return;
        }
        throw new AccessControlException("Permission denied. user=" + this.user + " is not the owner of inode=" + inode);
    }

    private void checkTraverse(INode[] inodes, int last) throws IOException {
        for (int j = 0; j <= last; ++j) {
            this.check(inodes[j], FsAction.EXECUTE);
        }
    }

    private void checkSubAccess(INode inode, FsAction access, boolean ignoreEmptyDir) throws IOException {
        if (inode == null || !inode.isDirectory()) {
            return;
        }
        Stack<INodeDirectory> directories = new Stack<INodeDirectory>();
        directories.push(inode.asDirectory());
        while (!directories.isEmpty()) {
            INodeDirectory d = (INodeDirectory)directories.pop();
            List<INode> cList = d.getChildrenList();
            if (!cList.isEmpty() || !ignoreEmptyDir) {
                this.check(d, access);
            }
            for (INode child : cList) {
                if (!child.isDirectory()) continue;
                directories.push(child.asDirectory());
            }
        }
    }

    private void check(INode[] inodes, int i, FsAction access) throws IOException {
        this.check(i >= 0 ? inodes[i] : null, access);
    }

    void check(INode inode, FsAction access) throws IOException {
        List<AclEntry> featureEntries;
        if (inode == null) {
            return;
        }
        FsPermission mode = inode.getFsPermission();
        AclFeature aclFeature = inode.getAclFeature();
        if (aclFeature != null && (featureEntries = aclFeature.getEntries()).get(0).getScope() == AclEntryScope.ACCESS) {
            this.checkAccessAcl(inode, access, mode, featureEntries);
            return;
        }
        this.check(inode, access, mode, inode.getUserName(), inode.getGroupName());
    }

    void check(INode inode, FsAction access, List<AclEntry> aclEntries) throws IOException {
        if (inode == null) {
            return;
        }
        FsPermission mode = inode.getFsPermission();
        if (aclEntries != null && !aclEntries.isEmpty() && aclEntries.get(0).getScope() == AclEntryScope.ACCESS) {
            this.checkAccessAcl(inode, access, mode, aclEntries);
            return;
        }
        this.check(inode, access, mode, inode.getUserName(), inode.getGroupName());
    }

    private void checkAccessAcl(INode inode, FsAction access, FsPermission mode, List<AclEntry> featureEntries) throws IOException {
        boolean foundMatch = false;
        if (this.user.equals(inode.getUserName())) {
            if (mode.getUserAction().implies(access)) {
                return;
            }
            foundMatch = true;
        }
        if (!foundMatch) {
            for (AclEntry entry : featureEntries) {
                String group;
                if (entry.getScope() == AclEntryScope.DEFAULT) break;
                AclEntryType type = entry.getType();
                String name = entry.getName();
                if (type == AclEntryType.USER) {
                    if (!this.user.equals(name)) continue;
                    FsAction masked = entry.getPermission().and(mode.getGroupAction());
                    if (masked.implies(access)) {
                        return;
                    }
                    foundMatch = true;
                    break;
                }
                if (type != AclEntryType.GROUP || !this.groups.contains(group = name == null ? inode.getGroupName() : name)) continue;
                FsAction masked = entry.getPermission().and(mode.getGroupAction());
                if (masked.implies(access)) {
                    return;
                }
                foundMatch = true;
            }
        }
        if (!foundMatch && mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException(this.toAccessControlString(inode, access, mode, featureEntries));
    }

    private void checkAccessAcl(ProjectedINode inode, FsAction access, FsPermission mode, List<AclEntry> featureEntries) throws IOException {
        boolean foundMatch = false;
        if (this.user.equals(inode.getUserName())) {
            if (mode.getUserAction().implies(access)) {
                return;
            }
            foundMatch = true;
        }
        if (!foundMatch) {
            for (AclEntry entry : featureEntries) {
                String group;
                if (entry.getScope() == AclEntryScope.DEFAULT) break;
                AclEntryType type = entry.getType();
                String name = entry.getName();
                if (type == AclEntryType.USER) {
                    if (!this.user.equals(name)) continue;
                    FsAction masked = entry.getPermission().and(mode.getGroupAction());
                    if (masked.implies(access)) {
                        return;
                    }
                    foundMatch = true;
                    break;
                }
                if (type != AclEntryType.GROUP || !this.groups.contains(group = name == null ? inode.getGroupName() : name)) continue;
                FsAction masked = entry.getPermission().and(mode.getGroupAction());
                if (masked.implies(access)) {
                    return;
                }
                foundMatch = true;
            }
        }
        if (!foundMatch && mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException(this.toAccessControlString(inode, access, mode, featureEntries));
    }

    void check(ProjectedINode inode, FsAction access, List<AclEntry> aclEntries) throws IOException {
        if (inode == null) {
            return;
        }
        FsPermission mode = new FsPermission(inode.getPermission());
        if (aclEntries != null && !aclEntries.isEmpty() && aclEntries.get(0).getScope() == AclEntryScope.ACCESS) {
            this.checkAccessAcl(inode, access, mode, aclEntries);
            return;
        }
        if (!this.check(inode.getId(), access, mode, inode.getUserName(), inode.getGroupName())) {
            throw new AccessControlException("Permission denied: user=" + this.user + ", access=" + access + ", inode=" + FSPermissionChecker.toAccessControlString(inode));
        }
    }

    void check(INode inode, FsAction access, FsPermission mode, String userName, String groupName) throws AccessControlException, TransactionContextException, IOException {
        if (!this.check(inode.getId(), access, mode, userName, groupName)) {
            throw new AccessControlException("Permission denied: user=" + this.user + ", access=" + access + ", inode=" + FSPermissionChecker.toAccessControlString(inode));
        }
    }

    boolean check(long inodeId, FsAction access, FsPermission mode, String userName, String groupName) throws AccessControlException, TransactionContextException, IOException {
        return this.user.equals(userName) ? mode.getUserAction().implies(access) : (this.groups.contains(groupName) ? mode.getGroupAction().implies(access) : mode.getOtherAction().implies(access));
    }

    private void checkStickyBit(INode parent, INode inode) throws IOException {
        if (!parent.getFsPermission().getStickyBit()) {
            return;
        }
        if (parent.getUserName().equals(this.user)) {
            return;
        }
        if (inode.getUserName().equals(this.user)) {
            return;
        }
        throw new AccessControlException("Permission denied by sticky bit setting: user=" + this.user + ", inode=" + inode);
    }

    public void checkPermission(CachePool pool, FsAction access) throws AccessControlException {
        FsPermission mode = pool.getMode();
        if (this.isSuperUser()) {
            return;
        }
        if (this.user.equals(pool.getOwnerName()) && mode.getUserAction().implies(access)) {
            return;
        }
        if (this.groups.contains(pool.getGroupName()) && mode.getGroupAction().implies(access)) {
            return;
        }
        if (mode.getOtherAction().implies(access)) {
            return;
        }
        throw new AccessControlException("Permission denied while accessing pool " + pool.getPoolName() + ": user " + this.user + " does not have " + access.toString() + " permissions.");
    }
}

