/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;

public class INodesInPath {
    public static final Log LOG = LogFactory.getLog(INodesInPath.class);
    private final byte[][] path;
    private INode[] inodes;
    private int numNonNull;
    private int capacity;

    static INodesInPath fromINode(INode inode) throws StorageException, TransactionContextException {
        INode tmp;
        int depth = 0;
        for (tmp = inode; tmp != null; tmp = tmp.getParent()) {
            ++depth;
        }
        byte[][] path = new byte[depth][];
        INode[] inodes = new INode[depth];
        INodesInPath iip = new INodesInPath(path, depth);
        int index = depth;
        for (tmp = inode; tmp != null; tmp = tmp.getParent()) {
            path[--index] = tmp.getLocalNameBytes();
            inodes[index] = tmp;
        }
        iip.setINodes(inodes);
        return iip;
    }

    private static String constructPath(byte[][] components, int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end; ++i) {
            buf.append(DFSUtil.bytes2String(components[i]));
            if (i >= end - 1) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    static INodesInPath resolve(INodeDirectory startingDir, byte[][] components) throws UnresolvedLinkException, StorageException, TransactionContextException {
        return INodesInPath.resolve(startingDir, components, components.length, false);
    }

    static INodesInPath resolve(INodeDirectory startingDir, byte[][] components, int numOfINodes, boolean resolveLink) throws UnresolvedLinkException, StorageException, TransactionContextException {
        Preconditions.checkArgument((startingDir.compareTo(components[0]) == 0 ? 1 : 0) != 0);
        INode curNode = startingDir;
        INodesInPath existing = new INodesInPath(components, numOfINodes);
        int count = 0;
        int index = numOfINodes - components.length;
        if (index > 0) {
            index = 0;
        }
        while (count < components.length && curNode != null) {
            boolean isDir;
            INodeDirectory dir;
            boolean lastComp;
            boolean bl = lastComp = count == components.length - 1;
            if (index >= 0) {
                existing.addNode(curNode);
            }
            INodeDirectory iNodeDirectory = dir = (isDir = curNode.isDirectory()) ? curNode.asDirectory() : null;
            if (curNode.isSymlink() && (!lastComp || lastComp && resolveLink)) {
                String path = INodesInPath.constructPath(components, 0, components.length);
                String preceding = INodesInPath.constructPath(components, 0, count);
                String remainder = INodesInPath.constructPath(components, count + 1, components.length);
                String link = DFSUtil.bytes2String(components[count]);
                String target = curNode.asSymlink().getSymlinkString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("UnresolvedPathException  path: " + path + " preceding: " + preceding + " count: " + count + " link: " + link + " target: " + target + " remainder: " + remainder));
                }
                throw new UnresolvedPathException(path, preceding, remainder, target);
            }
            if (lastComp || !isDir) break;
            byte[] childName = components[count + 1];
            curNode = dir.getChildINode(childName);
            ++count;
            ++index;
        }
        return existing;
    }

    private INodesInPath(byte[][] path, int number) {
        this.path = path;
        assert (number >= 0);
        this.inodes = new INode[number];
        this.capacity = number;
        this.numNonNull = 0;
    }

    INode[] getINodes() {
        if (this.capacity == this.inodes.length) {
            return this.inodes;
        }
        INode[] newNodes = new INode[this.capacity];
        System.arraycopy(this.inodes, 0, newNodes, 0, this.capacity);
        return newNodes;
    }

    public INode getINode(int i) {
        return this.inodes[i >= 0 ? i : this.inodes.length + i];
    }

    public INode getLastINode() {
        return this.inodes[this.inodes.length - 1];
    }

    byte[] getLastLocalName() {
        return this.path[this.path.length - 1];
    }

    private void addNode(INode node) {
        this.inodes[this.numNonNull++] = node;
    }

    private void setINodes(INode[] inodes) {
        this.inodes = inodes;
        this.numNonNull = this.inodes.length;
    }

    void setINode(int i, INode inode) {
        this.inodes[i >= 0 ? i : this.inodes.length + i] = inode;
    }

    void setLastINode(INode last) {
        this.inodes[this.inodes.length - 1] = last;
    }

    int getNumNonNull() {
        return this.numNonNull;
    }

    private static String toString(INode inode) {
        return inode == null ? null : inode.getLocalName();
    }

    public String toString() {
        try {
            return this.toString(true);
        }
        catch (StorageException | TransactionContextException ex) {
            LOG.error((Object)ex, ex);
            return null;
        }
    }

    private String toString(boolean vaildateObject) throws StorageException, TransactionContextException {
        if (vaildateObject) {
            this.vaildate();
        }
        StringBuilder b = new StringBuilder(this.getClass().getSimpleName()).append(": path = ").append(DFSUtil.byteArray2PathString(this.path)).append("\n  inodes = ");
        if (this.inodes == null) {
            b.append("null");
        } else if (this.inodes.length == 0) {
            b.append("[]");
        } else {
            b.append("[").append(INodesInPath.toString(this.inodes[0]));
            for (int i = 1; i < this.inodes.length; ++i) {
                b.append(", ").append(INodesInPath.toString(this.inodes[i]));
            }
            b.append("], length=").append(this.inodes.length);
        }
        b.append("\n  numNonNull = ").append(this.numNonNull).append("\n  capacity   = ").append(this.capacity);
        return b.toString();
    }

    void vaildate() throws StorageException, TransactionContextException {
        int n = this.numNonNull;
        int i = 0;
        if (this.inodes[i] != null) {
            ++i;
            while (i < n && this.inodes[i] != null) {
                INodeDirectory parent_i = this.inodes[i].getParent();
                INodeDirectory parent_i_1 = this.inodes[i - 1].getParent();
                if (parent_i != this.inodes[i - 1] && (parent_i_1 == null || parent_i != parent_i_1)) {
                    throw new AssertionError((Object)("inodes[" + i + "].getParent() != inodes[" + (i - 1) + "]\n  inodes[" + i + "]=" + this.inodes[i].toDetailString() + "\n  inodes[" + (i - 1) + "]=" + this.inodes[i - 1].toDetailString() + "\n this=" + this.toString(false)));
                }
                ++i;
            }
        }
        if (i != n) {
            throw new AssertionError((Object)("i = " + i + " != " + n + ", this=" + this.toString(false)));
        }
    }
}

