/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestDatanodeBlockScanner;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.junit.Assert;
import org.junit.Test;

public class TestMissingBlocksAlert {
    private static final Log LOG = LogFactory.getLog(TestMissingBlocksAlert.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingBlocksAlert() throws IOException, InterruptedException, MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        MiniDFSCluster cluster = null;
        try {
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.setInt("dfs.namenode.replication.interval", 0);
            conf.setInt("dfs.client.retry.window.base", 10);
            int fileLen = 10240;
            conf.setInt("dfs.blocksize", fileLen / 2);
            cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            cluster.waitActive();
            BlockManager bm = cluster.getNamesystem().getBlockManager();
            DistributedFileSystem dfs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)dfs, new Path("/testMissingBlocksAlert/file1"), fileLen, (short)3, 0L);
            Path corruptFile = new Path("/testMissingBlocks/corruptFile");
            DFSTestUtil.createFile((FileSystem)dfs, corruptFile, fileLen, (short)3, 0L);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)dfs, corruptFile);
            Assert.assertTrue((boolean)TestDatanodeBlockScanner.corruptReplica(block, 0));
            FSDataInputStream in = dfs.open(corruptFile);
            try {
                in.readFully(new byte[fileLen]);
            }
            catch (ChecksumException checksumException) {
                // empty catch block
            }
            in.close();
            LOG.info((Object)"Waiting for missing blocks count to increase...");
            while (dfs.getMissingBlocksCount() <= 0L) {
                Thread.sleep(100L);
            }
            Assert.assertTrue((dfs.getMissingBlocksCount() == 1L ? 1 : 0) != 0);
            Assert.assertEquals((long)4L, (long)dfs.getUnderReplicatedBlocksCount());
            Assert.assertEquals((long)3L, (long)bm.getUnderReplicatedNotMissingBlocks());
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=NameNodeInfo");
            Assert.assertEquals((long)1L, (long)((Long)mbs.getAttribute(mxbeanName, "NumberOfMissingBlocks")));
            dfs.delete(corruptFile, true);
            LOG.info((Object)"Waiting for missing blocks count to be zero...");
            while (dfs.getMissingBlocksCount() > 0L) {
                Thread.sleep(100L);
            }
            Assert.assertEquals((long)2L, (long)dfs.getUnderReplicatedBlocksCount());
            Assert.assertEquals((long)2L, (long)bm.getUnderReplicatedNotMissingBlocks());
            Assert.assertEquals((long)0L, (long)((Long)mbs.getAttribute(mxbeanName, "NumberOfMissingBlocks")));
            Path replOneFile = new Path("/testMissingBlocks/replOneFile");
            DFSTestUtil.createFile((FileSystem)dfs, replOneFile, fileLen, (short)1, 0L);
            ExtendedBlock replOneBlock = DFSTestUtil.getFirstBlock((FileSystem)dfs, replOneFile);
            Assert.assertTrue((boolean)TestDatanodeBlockScanner.corruptReplica(replOneBlock, 0));
            in = dfs.open(replOneFile);
            try {
                in.readFully(new byte[fileLen]);
            }
            catch (ChecksumException checksumException) {
                // empty catch block
            }
            in.close();
            Assert.assertEquals((long)1L, (long)dfs.getMissingReplOneBlocksCount());
            Assert.assertEquals((long)1L, (long)((Long)mbs.getAttribute(mxbeanName, "NumberOfMissingBlocksWithReplicationFactorOne")));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

