/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.junit.Assert;
import org.junit.Test;

public class TestCorruptReplicaInfo {
    private static final Log LOG = LogFactory.getLog(TestCorruptReplicaInfo.class);
    private Map<Integer, BlockInfo> block_map = new HashMap<Integer, BlockInfo>();
    private BlocksMap blocksMap = new BlocksMap(null);

    private BlockInfo getBlock(Integer block_id) {
        if (!this.block_map.containsKey(block_id)) {
            this.block_map.put(block_id, new BlockInfo(new Block((long)block_id.intValue(), 0L, 0L), (long)block_id.intValue()));
        }
        return this.block_map.get(block_id);
    }

    @Test
    public void testCorruptReplicaInfo() throws IOException, InterruptedException, StorageException {
        HdfsStorageFactory.setConfiguration((Configuration)new HdfsConfiguration());
        HdfsStorageFactory.formatStorage();
        CorruptReplicasMap crm = new CorruptReplicasMap(null);
        Assert.assertEquals((String)"Number of corrupt blocks must initially be 0", (long)0L, (long)crm.size());
        Assert.assertNull((String)"Param n cannot be less than 0", (Object)crm.getCorruptReplicaBlockIds(-1, null));
        Assert.assertNull((String)"Param n cannot be greater than 100", (Object)crm.getCorruptReplicaBlockIds(101, null));
        long[] l = crm.getCorruptReplicaBlockIds(0, null);
        Assert.assertNotNull((String)"n = 0 must return non-null", (Object)l);
        Assert.assertEquals((String)"n = 0 must return an empty list", (long)0L, (long)l.length);
        int NUM_BLOCK_IDS = 140;
        LinkedList<Integer> block_ids = new LinkedList<Integer>();
        for (int i = 0; i < NUM_BLOCK_IDS; ++i) {
            block_ids.add(i);
        }
        DatanodeDescriptor dn1 = DFSTestUtil.getLocalDatanodeDescriptor();
        DatanodeStorage ds1 = new DatanodeStorage("storageid_1", DatanodeStorage.State.NORMAL, StorageType.DEFAULT);
        DatanodeStorageInfo storage1 = new DatanodeStorageInfo(dn1, ds1);
        DatanodeDescriptor dn2 = DFSTestUtil.getLocalDatanodeDescriptor();
        DatanodeStorage ds2 = new DatanodeStorage("storageid_2", DatanodeStorage.State.NORMAL, StorageType.DEFAULT);
        DatanodeStorageInfo storage2 = new DatanodeStorageInfo(dn2, ds2);
        this.addToCorruptReplicasMap(crm, this.getBlock(0), storage1);
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)1L, (long)crm.size());
        this.addToCorruptReplicasMap(crm, this.getBlock(1), storage1);
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)2L, (long)crm.size());
        this.addToCorruptReplicasMap(crm, this.getBlock(1), storage2);
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)2L, (long)crm.size());
        this.removeFromCorruptReplicasMap(crm, this.getBlock(1));
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)1L, (long)crm.size());
        this.removeFromCorruptReplicasMap(crm, this.getBlock(0));
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)0L, (long)crm.size());
        for (Integer block_id : block_ids) {
            this.addToCorruptReplicasMap(crm, this.getBlock(block_id), storage1);
        }
        Assert.assertEquals((String)"Number of corrupt blocks not returning correctly", (long)NUM_BLOCK_IDS, (long)crm.size());
        Assert.assertTrue((String)"First five block ids not returned correctly ", (boolean)Arrays.equals(new long[]{0L, 1L, 2L, 3L, 4L}, crm.getCorruptReplicaBlockIds(5, null)));
        LOG.info((Object)crm.getCorruptReplicaBlockIds(10, Long.valueOf(7L)));
        LOG.info(block_ids.subList(7, 18));
        Assert.assertTrue((String)"10 blocks after 7 not returned correctly ", (boolean)Arrays.equals(new long[]{8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L}, crm.getCorruptReplicaBlockIds(10, Long.valueOf(7L))));
    }

    private void addToCorruptReplicasMap(final CorruptReplicasMap crm, final BlockInfo blk, final DatanodeStorageInfo storage) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST_CORRUPT_REPLICA_INFO){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException, IOException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)blk);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(blk.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.CR}));
            }

            public Object performTask() throws StorageException, IOException {
                TestCorruptReplicaInfo.this.blocksMap.addBlockCollection(blk, (BlockCollection)new INodeFile(blk.getInodeId(), new PermissionStatus("n", "n", FsPermission.getDefault()), null, 1, 0L, 0L, 1L, 0));
                crm.addToCorruptReplicasMap(blk, storage, "TEST", CorruptReplicasMap.Reason.NONE);
                return null;
            }
        }.handle();
    }

    private void removeFromCorruptReplicasMap(final CorruptReplicasMap crm, final BlockInfo blk) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST_CORRUPT_REPLICA_INFO){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException, IOException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)blk);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(blk.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.CR}));
            }

            public Object performTask() throws StorageException, IOException {
                crm.removeFromCorruptReplicasMap(blk);
                return null;
            }
        }.handle();
    }
}

