/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlocksMap;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.HashBuckets;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.junit.Assert;
import org.junit.Test;

public class TestDatanodeDescriptor {
    @Test
    public void testGetInvalidateBlocks() throws Exception {
        int MAX_BLOCKS = 10;
        int REMAINING_BLOCKS = 2;
        int MAX_LIMIT = 8;
        DatanodeDescriptor dd = DFSTestUtil.getLocalDatanodeDescriptor();
        ArrayList<Block> blockList = new ArrayList<Block>(10);
        for (int i = 0; i < 10; ++i) {
            blockList.add(new Block((long)i, 0L, 1000L));
        }
        dd.addBlocksToBeInvalidated(blockList);
        Block[] bc = dd.getInvalidateBlocks(8);
        Assert.assertEquals((long)bc.length, (long)8L);
        bc = dd.getInvalidateBlocks(8);
        Assert.assertEquals((long)bc.length, (long)2L);
    }

    @Test
    public void testBlocksCounter() throws Exception {
        HdfsStorageFactory.setConfiguration((Configuration)new HdfsConfiguration());
        HdfsStorageFactory.formatStorage();
        BlocksMap blocksMap = new BlocksMap(null);
        HashBuckets.initialize((int)1000);
        DatanodeDescriptor datanode = DFSTestUtil.getLocalDatanodeDescriptor(true);
        Assert.assertEquals((long)0L, (long)datanode.numBlocks());
        BlockInfo blk = new BlockInfo(new Block(1L), 2L);
        BlockInfo blk1 = new BlockInfo(new Block(2L), 3L);
        DatanodeStorageInfo[] storages = datanode.getStorageInfos();
        Assert.assertTrue((storages.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.addBlock(blocksMap, storages[0], blk));
        Assert.assertEquals((long)1L, (long)datanode.numBlocks());
        Assert.assertFalse((boolean)this.removeBlock(datanode, blk1));
        Assert.assertEquals((long)1L, (long)datanode.numBlocks());
        Assert.assertFalse((boolean)this.addBlock(blocksMap, storages[0], blk));
        System.out.println("number of blks are " + datanode.numBlocks());
        Assert.assertEquals((long)1L, (long)datanode.numBlocks());
        Assert.assertTrue((boolean)this.addBlock(blocksMap, storages[0], blk1));
        Assert.assertEquals((long)2L, (long)datanode.numBlocks());
        Assert.assertTrue((boolean)this.removeBlock(datanode, blk));
        Assert.assertEquals((long)1L, (long)datanode.numBlocks());
        Assert.assertTrue((boolean)this.removeBlock(datanode, blk1));
        Assert.assertEquals((long)0L, (long)datanode.numBlocks());
    }

    private boolean addBlock(final BlocksMap blocksMap, final DatanodeStorageInfo storage, final BlockInfo blk) throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException, IOException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)blk);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(blk.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE}));
            }

            public Object performTask() throws StorageException, IOException {
                blocksMap.addBlockCollection(blk, (BlockCollection)new INodeFile(blk.getInodeId(), new PermissionStatus("n", "n", FsPermission.getDefault()), null, 1, 0L, 0L, 1L, 0));
                return storage.addBlock(blk);
            }
        }.handle();
    }

    private boolean removeBlock(final DatanodeDescriptor dn, final BlockInfo blk) throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException, IOException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)blk);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(blk.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE}));
            }

            public Object performTask() throws StorageException, IOException {
                return dn.removeBlock(blk);
            }
        }.handle();
    }
}

