/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.UnderReplicatedBlocks;
import org.junit.Assert;
import org.junit.Test;

public class TestUnderReplicatedBlockQueues {
    @Test
    public void testBlockPriorities() throws Throwable {
        HdfsStorageFactory.setConfiguration((Configuration)new HdfsConfiguration());
        HdfsStorageFactory.formatStorage();
        UnderReplicatedBlocks queues = new UnderReplicatedBlocks();
        BlockInfo block1 = this.add(new BlockInfo(new Block(1L), 1L));
        BlockInfo block2 = this.add(new BlockInfo(new Block(2L), 2L));
        BlockInfo block_very_under_replicated = this.add(new BlockInfo(new Block(3L), 3L));
        BlockInfo block_corrupt = this.add(new BlockInfo(new Block(4L), 4L));
        BlockInfo block_corrupt_repl_one = this.add(new BlockInfo(new Block(5L), 5L));
        this.assertAdded(queues, block1, 1, 0, 3);
        Assert.assertEquals((long)1L, (long)queues.getUnderReplicatedBlockCount());
        Assert.assertEquals((long)1L, (long)queues.size());
        this.assertInLevel(queues, block1, 0);
        Assert.assertFalse((boolean)this.add(queues, block1, 1, 0, 3));
        this.assertAdded(queues, block2, 2, 0, 3);
        Assert.assertEquals((long)2L, (long)queues.getUnderReplicatedBlockCount());
        Assert.assertEquals((long)2L, (long)queues.size());
        this.assertInLevel(queues, block2, 2);
        this.assertAdded(queues, block_corrupt, 0, 0, 3);
        Assert.assertEquals((long)3L, (long)queues.size());
        Assert.assertEquals((long)2L, (long)queues.getUnderReplicatedBlockCount());
        Assert.assertEquals((long)1L, (long)queues.getCorruptBlockSize());
        this.assertInLevel(queues, block_corrupt, 4);
        this.assertAdded(queues, block_very_under_replicated, 4, 0, 25);
        this.assertInLevel(queues, block_very_under_replicated, 1);
        this.assertAdded(queues, block_corrupt_repl_one, 0, 0, 1);
        Assert.assertEquals((long)2L, (long)queues.getCorruptBlockSize());
        Assert.assertEquals((long)1L, (long)queues.getCorruptReplOneBlockSize());
        this.updateQueue(queues, block_corrupt_repl_one, 0, 0, 3, 0, 2);
        Assert.assertEquals((long)0L, (long)queues.getCorruptReplOneBlockSize());
        this.updateQueue(queues, block_corrupt, 0, 0, 1, 0, -2);
        Assert.assertEquals((long)1L, (long)queues.getCorruptReplOneBlockSize());
        this.updateQueue(queues, block_very_under_replicated, 0, 0, 1, -4, -24);
        Assert.assertEquals((long)2L, (long)queues.getCorruptReplOneBlockSize());
    }

    private void updateQueue(final UnderReplicatedBlocks queues, final BlockInfo block, final int curReplicas, final int decommissionedReplicas, final int curExpectedReplicas, final int curReplicasDelta, final int expectedReplicasDelta) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.READ, this.inodeIdentifier, true)).add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR, LockFactory.BLK.IV}));
            }

            public Object performTask() throws IOException {
                queues.update(block, curReplicas, decommissionedReplicas, curExpectedReplicas, curReplicasDelta, expectedReplicasDelta);
                return null;
            }
        }.handle();
    }

    private void assertAdded(UnderReplicatedBlocks queues, BlockInfo block, int curReplicas, int decomissionedReplicas, int expectedReplicas) throws IOException {
        Assert.assertTrue((String)("Failed to add " + block), (boolean)this.add(queues, block, curReplicas, decomissionedReplicas, expectedReplicas));
    }

    private void assertInLevel(UnderReplicatedBlocks queues, BlockInfo block, int level) {
        UnderReplicatedBlocks.BlockIterator bi = queues.iterator(level);
        while (bi.hasNext()) {
            Block next = bi.next();
            if (!block.equals((Object)next)) continue;
            return;
        }
        Assert.fail((String)("Block " + block + " not found in level " + level));
    }

    private BlockInfo add(final BlockInfo block) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
            }

            public Object performTask() throws StorageException, IOException {
                EntityManager.add((Object)new BlockInfo(block));
                return null;
            }
        }.handle();
        return block;
    }

    private boolean add(final UnderReplicatedBlocks queues, final BlockInfo block, final int curReplicas, final int decomissionedReplicas, final int expectedReplicas) throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(block.getBlockId(), new INodeIdentifier(Long.valueOf(block.getInodeId())))).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.UR}));
            }

            public Object performTask() throws StorageException, IOException {
                return queues.add(block, curReplicas, decomissionedReplicas, expectedReplicas);
            }
        }.handle();
    }
}

