/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestUnderReplicatedBlocks {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSetrepIncWithUnderReplicatedBlocks() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int REPLICATION_FACTOR = 2;
        String FILE_NAME = "/testFile";
        Path FILE_PATH = new Path("/testFile");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, FILE_PATH, 1L, (short)2, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, FILE_PATH, (short)2);
            final BlockManager bm = cluster.getNamesystem().getBlockManager();
            final ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, FILE_PATH);
            HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){
                INodeIdentifier inodeIdentifier;

                public void setUp() throws StorageException {
                    Block blk = b.getLocalBlock();
                    this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)blk);
                }

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier)).add(lf.getIndividualBlockLock(b.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.IV}));
                }

                public Object performTask() throws StorageException, IOException {
                    DatanodeStorageInfo storage = (DatanodeStorageInfo)bm.blocksMap.storageList(b.getLocalBlock()).get(0);
                    DatanodeDescriptor dn = storage.getDatanodeDescriptor();
                    bm.addToInvalidates(b.getLocalBlock(), (DatanodeInfo)dn);
                    bm.blocksMap.removeNode(b.getLocalBlock(), dn);
                    return dn;
                }
            };
            DatanodeDescriptor dn = (DatanodeDescriptor)handler.handle();
            BlockManagerTestUtil.computeAllPendingWork(bm);
            DataNodeTestUtils.triggerHeartbeat(cluster.getDataNode(dn.getIpcPort()));
            Thread.sleep(5000L);
            HopsTransactionalRequestHandler handler2 = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){
                INodeIdentifier inodeIdentifier;

                public void setUp() throws StorageException {
                    Block blk = b.getLocalBlock();
                    this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)blk);
                }

                public void acquireLock(TransactionLocks locks) throws IOException {
                    LockFactory lf = LockFactory.getInstance();
                    locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier)).add(lf.getIndividualBlockLock(b.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.IV}));
                }

                public Object performTask() throws StorageException, IOException {
                    DatanodeDescriptor dn = (DatanodeDescriptor)this.getParams()[0];
                    bm.blocksMap.removeNode(b.getLocalBlock(), dn);
                    return null;
                }
            };
            handler2.setParams(new Object[]{dn});
            handler2.handle();
            FsShell shell = new FsShell((Configuration)conf);
            Assert.assertEquals((long)0L, (long)shell.run(new String[]{"-setrep", "-w", Integer.toString(3), "/testFile"}));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNumberOfBlocksToBeReplicated() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 0L);
        conf.setLong("dfs.blocksize", 1L);
        conf.setInt("dfs.bytes-per-checksum", 1);
        conf.setInt("dfs.heartbeat.interval", 100);
        conf.setInt("dfs.namenode.replication.work.multiplier.per.iteration", 5);
        int NUM_OF_BLOCKS = 10;
        int REP_FACTOR = 2;
        String FILE_NAME = "/testFile";
        Path FILE_PATH = new Path("/testFile");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, FILE_PATH, NUM_OF_BLOCKS, (short)2, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, FILE_PATH, (short)2);
            cluster.startDataNodes((Configuration)conf, 1, true, null, null, null, null);
            BlockManager bm = cluster.getNamesystem().getBlockManager();
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, FILE_PATH);
            Iterator<DatanodeStorageInfo> storageInfos = this.getStorageInfo(b.getLocalBlock(), bm).iterator();
            DatanodeDescriptor firstDn = storageInfos.next().getDatanodeDescriptor();
            DatanodeDescriptor secondDn = storageInfos.next().getDatanodeDescriptor();
            bm.getDatanodeManager().removeDatanode((DatanodeID)firstDn, false);
            Assert.assertEquals((long)NUM_OF_BLOCKS, (long)bm.getUnderReplicatedNotMissingBlocks());
            bm.computeDatanodeWork();
            Assert.assertTrue((String)("The number of blocks to be replicated should be less than or equal to " + bm.replicationStreamsHardLimit), (secondDn.getNumberOfBlocksToBeReplicated() <= bm.replicationStreamsHardLimit ? 1 : 0) != 0);
        }
        finally {
            cluster.shutdown();
        }
    }

    List<DatanodeStorageInfo> getStorageInfo(final Block blk, final BlockManager bm) throws IOException {
        return (List)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)blk);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.WRITE, this.inodeIdentifier)).add(lf.getIndividualBlockLock(blk.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.IV}));
            }

            public Object performTask() throws StorageException, IOException {
                return bm.blocksMap.storageList(blk);
            }
        }.handle();
    }
}

