/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataBlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestFsDatasetImpl {
    private static final String BASE_DIR = new FileSystemTestHelper().getTestRootDir();
    private static final int NUM_INIT_VOLUMES = 2;
    private static final String[] BLOCK_POOL_IDS = new String[]{"bpid-0", "bpid-1"};
    private static final DataStorage dsForStorageUuid = new DataStorage(new StorageInfo(HdfsServerConstants.NodeType.DATA_NODE));
    private Configuration conf;
    private DataNode datanode;
    private DataStorage storage;
    private DataBlockScanner scanner;
    private FsDatasetImpl dataset;

    private static Storage.StorageDirectory createStorageDirectory(File root) {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(root);
        dsForStorageUuid.createStorageID(sd);
        return sd;
    }

    private static void createStorageDirs(DataStorage storage, Configuration conf, int numDirs) throws IOException {
        ArrayList<Storage.StorageDirectory> dirs = new ArrayList<Storage.StorageDirectory>();
        ArrayList<String> dirStrings = new ArrayList<String>();
        for (int i = 0; i < numDirs; ++i) {
            File loc = new File(BASE_DIR + "/data" + i);
            dirStrings.add(loc.toString());
            loc.mkdirs();
            dirs.add(TestFsDatasetImpl.createStorageDirectory(loc));
            Mockito.when((Object)storage.getStorageDir(i)).thenReturn(dirs.get(i));
        }
        String dataDir = StringUtils.join((CharSequence)",", dirStrings);
        conf.set("dfs.datanode.data.dir", dataDir);
        Mockito.when((Object)storage.getNumStorageDirs()).thenReturn((Object)numDirs);
    }

    @Before
    public void setUp() throws IOException {
        this.datanode = (DataNode)Mockito.mock(DataNode.class);
        this.storage = (DataStorage)Mockito.mock(DataStorage.class);
        this.scanner = (DataBlockScanner)Mockito.mock(DataBlockScanner.class);
        this.conf = new Configuration();
        DNConf dnConf = new DNConf(this.conf);
        Mockito.when((Object)this.datanode.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.datanode.getDnConf()).thenReturn((Object)dnConf);
        Mockito.when((Object)this.datanode.getBlockScanner()).thenReturn((Object)this.scanner);
        TestFsDatasetImpl.createStorageDirs(this.storage, this.conf, 2);
        this.dataset = new FsDatasetImpl(this.datanode, this.storage, this.conf);
        for (String bpid : BLOCK_POOL_IDS) {
            this.dataset.addBlockPool(bpid, this.conf);
        }
        Assert.assertEquals((long)2L, (long)this.dataset.getVolumes().size());
        Assert.assertEquals((long)0L, (long)this.dataset.getNumFailedVolumes());
    }

    @Test
    public void testAddVolumes() throws IOException {
        int numNewVolumes = 3;
        int numExistingVolumes = this.dataset.getVolumes().size();
        int totalVolumes = 3 + numExistingVolumes;
        HashSet expectedVolumes = new HashSet();
        ArrayList nsInfos = Lists.newArrayList();
        for (String bpid : BLOCK_POOL_IDS) {
            nsInfos.add(new NamespaceInfo(0, "cluster-id", bpid, 1L));
        }
        for (int i = 0; i < 3; ++i) {
            String path = BASE_DIR + "/newData" + i;
            StorageLocation loc = StorageLocation.parse((String)path);
            Storage.StorageDirectory sd = TestFsDatasetImpl.createStorageDirectory(new File(path));
            DataStorage.VolumeBuilder builder = new DataStorage.VolumeBuilder(this.storage, sd);
            Mockito.when((Object)this.storage.prepareVolume((DataNode)Matchers.eq((Object)this.datanode), (File)Matchers.eq((Object)loc.getFile()), Matchers.anyListOf(NamespaceInfo.class))).thenReturn((Object)builder);
            this.dataset.addVolume(loc, (List)nsInfos);
        }
        Assert.assertEquals((long)totalVolumes, (long)this.dataset.getVolumes().size());
        Assert.assertEquals((long)totalVolumes, (long)this.dataset.storageMap.size());
        HashSet actualVolumes = new HashSet();
        for (int i = 0; i < 3; ++i) {
            ((FsVolumeImpl)this.dataset.getVolumes().get(numExistingVolumes + i)).getBasePath();
        }
        Assert.assertEquals(actualVolumes, expectedVolumes);
    }

    @Test
    public void testRemoveVolumes() throws IOException {
        int NUM_BLOCKS = 100;
        for (int i = 0; i < 100; ++i) {
            String bpid = BLOCK_POOL_IDS[100 % BLOCK_POOL_IDS.length];
            ExtendedBlock eb = new ExtendedBlock(bpid, (long)i);
            this.dataset.createRbw(StorageType.DEFAULT, eb);
        }
        String[] dataDirs = this.conf.get("dfs.datanode.data.dir").split(",");
        String volumePathToRemove = dataDirs[0];
        ArrayList<StorageLocation> volumesToRemove = new ArrayList<StorageLocation>();
        volumesToRemove.add(StorageLocation.parse((String)volumePathToRemove));
        this.dataset.removeVolumes(volumesToRemove);
        int expectedNumVolumes = dataDirs.length - 1;
        Assert.assertEquals((String)"The volume has been removed from the volumeList.", (long)expectedNumVolumes, (long)this.dataset.getVolumes().size());
        Assert.assertEquals((String)"The volume has been removed from the storageMap.", (long)expectedNumVolumes, (long)this.dataset.storageMap.size());
        try {
            this.dataset.asyncDiskService.execute(((StorageLocation)volumesToRemove.get(0)).getFile(), new Runnable(){

                @Override
                public void run() {
                }
            });
            Assert.fail((String)"Expect RuntimeException: the volume has been removed from the AsyncDiskService.");
        }
        catch (RuntimeException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot find root", (Throwable)e);
        }
        int totalNumReplicas = 0;
        for (String bpid : this.dataset.volumeMap.getBlockPoolList()) {
            totalNumReplicas += this.dataset.volumeMap.size(bpid);
        }
        Assert.assertEquals((String)"The replica infos on this volume has been removed from the volumeMap.", (long)50L, (long)totalNumReplicas);
        ((DataBlockScanner)Mockito.verify((Object)this.scanner, (VerificationMode)Mockito.times((int)BLOCK_POOL_IDS.length))).deleteBlocks(Matchers.anyString(), (Block[])Matchers.any(Block[].class));
    }
}

