/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDiskspaceQuotaUpdate {
    private static final int BLOCKSIZE = 1024;
    private static final short REPLICATION = 4;
    static final long seed = 0L;
    private static final Path dir = new Path("/TestQuotaUpdate");
    private Configuration conf;
    private MiniDFSCluster cluster;
    private FSDirectory fsdir;
    private DistributedFileSystem dfs;

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(4).build();
        this.cluster.waitActive();
        this.fsdir = this.cluster.getNamesystem().getFSDirectory();
        this.dfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testQuotaUpdateWithFileCreate() throws Exception {
        Path foo = new Path(dir, "foo");
        Path createdFile = new Path(foo, "created_file.data");
        this.dfs.mkdirs(foo);
        this.dfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        long fileLen = 2560L;
        DFSTestUtil.createFile((FileSystem)this.dfs, createdFile, 64, fileLen, 1024L, (short)4, 0L);
        Thread.sleep(1000L);
        Quota.Counts cnt = this.getSpaceConsumed(foo);
        Assert.assertEquals((long)2L, (long)cnt.get((Enum)Quota.NAMESPACE));
        Assert.assertEquals((long)(fileLen * 4L), (long)cnt.get((Enum)Quota.DISKSPACE));
    }

    @Test(timeout=60000L)
    public void testUpdateQuotaForAppend() throws Exception {
        Path foo = new Path(dir, "foo");
        Path bar = new Path(foo, "bar");
        long currentFileLen = 1024L;
        DFSTestUtil.createFile((FileSystem)this.dfs, bar, currentFileLen, (short)4, 0L);
        this.dfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        DFSTestUtil.appendFile((FileSystem)this.dfs, bar, 512);
        currentFileLen += 512L;
        Thread.sleep(1000L);
        Quota.Counts quota = this.getSpaceConsumed(foo);
        long ns = quota.get((Enum)Quota.NAMESPACE);
        long ds = quota.get((Enum)Quota.DISKSPACE);
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)(currentFileLen * 4L), (long)ds);
        ContentSummary c = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)ds);
        DFSTestUtil.appendFile((FileSystem)this.dfs, bar, 1024);
        currentFileLen += 1024L;
        Thread.sleep(1000L);
        quota = this.getSpaceConsumed(foo);
        ns = quota.get((Enum)Quota.NAMESPACE);
        ds = quota.get((Enum)Quota.DISKSPACE);
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)(currentFileLen * 4L), (long)ds);
        c = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)ds);
        DFSTestUtil.appendFile((FileSystem)this.dfs, bar, 3200);
        currentFileLen += 3200L;
        Thread.sleep(1000L);
        quota = this.getSpaceConsumed(foo);
        ns = quota.get((Enum)Quota.NAMESPACE);
        ds = quota.get((Enum)Quota.DISKSPACE);
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)(currentFileLen * 4L), (long)ds);
        c = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)c.getSpaceConsumed(), (long)ds);
    }

    @Test(timeout=60000L)
    public void testUpdateQuotaForFSync() throws Exception {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        DFSTestUtil.createFile((FileSystem)this.dfs, bar, 1024L, (short)4, 0L);
        this.dfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        FSDataOutputStream out = this.dfs.append(bar);
        out.write(new byte[256]);
        ((DFSOutputStream)out.getWrappedStream()).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        Thread.sleep(1000L);
        Quota.Counts quota = this.getSpaceConsumed(foo);
        long ns = quota.get((Enum)Quota.NAMESPACE);
        long ds = quota.get((Enum)Quota.DISKSPACE);
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)8192L, (long)ds);
        out.write(new byte[256]);
        out.close();
        Thread.sleep(1000L);
        quota = this.getSpaceConsumed(foo);
        ns = quota.get((Enum)Quota.NAMESPACE);
        ds = quota.get((Enum)Quota.DISKSPACE);
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)6144L, (long)ds);
        DFSTestUtil.appendFile((FileSystem)this.dfs, bar, 1024);
        Thread.sleep(1000L);
        quota = this.getSpaceConsumed(foo);
        ns = quota.get((Enum)Quota.NAMESPACE);
        ds = quota.get((Enum)Quota.DISKSPACE);
        Assert.assertEquals((long)2L, (long)ns);
        Assert.assertEquals((long)10240L, (long)ds);
    }

    Quota.Counts getSpaceConsumed(final Path foo) throws IOException {
        HopsTransactionalRequestHandler handler = new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, new String[]{foo.toString()});
                locks.add((Lock)il).add(lf.getLeaseLock(TransactionLockTypes.LockType.READ)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.READ_COMMITTED, foo.toString())).add(lf.getBlockLock()).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.CR, LockFactory.BLK.UC, LockFactory.BLK.UR}));
            }

            public Object performTask() throws IOException {
                INodeDirectory fooNode = TestDiskspaceQuotaUpdate.this.fsdir.getINode4Write(foo.toString()).asDirectory();
                Assert.assertTrue((boolean)fooNode.isQuotaSet());
                return fooNode.getDirectoryWithQuotaFeature().getSpaceConsumed(fooNode);
            }
        };
        return (Quota.Counts)handler.handle();
    }
}

