/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FsTracer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.tracing.SetSpanReceiver;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.TimelineAnnotation;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestTracing {
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private Tracer prevTracer;
    private static final Configuration TRACING_CONF;
    private static final Configuration NO_TRACING_CONF;

    @Ignore
    @Test
    public void testTracing() throws Exception {
        String fileName = "testTracingDisabled.dat";
        this.writeTestFile(fileName);
        Assert.assertEquals((long)0L, (long)SetSpanReceiver.size());
        this.readTestFile(fileName);
        Assert.assertEquals((long)0L, (long)SetSpanReceiver.size());
        this.writeTestFile("testReadTraceHooks.dat");
        FsTracer.clear();
        Tracer tracer = FsTracer.get((Configuration)TRACING_CONF);
        this.writeWithTracing(tracer);
        this.readWithTracing(tracer);
    }

    private void writeWithTracing(Tracer tracer) throws Exception {
        String[] spansInTopTrace;
        long startTime = System.currentTimeMillis();
        TraceScope ts = tracer.newScope("testWriteTraceHooks");
        this.writeTestFile("testWriteTraceHooks.dat");
        long endTime = System.currentTimeMillis();
        ts.close();
        String[] expectedSpanNames = new String[]{"testWriteTraceHooks", "ClientProtocol#create", "ClientNamenodeProtocol#create", "ClientProtocol#fsync", "ClientNamenodeProtocol#fsync", "ClientProtocol#complete", "ClientNamenodeProtocol#complete", "newStreamForCreate", "DFSOutputStream#write", "DFSOutputStream#close", "dataStreamer", "OpWriteBlockProto", "ClientProtocol#addBlock", "ClientNamenodeProtocol#addBlock"};
        SetSpanReceiver.assertSpanNamesFound((String[])expectedSpanNames);
        Map map = SetSpanReceiver.getMap();
        Span s = (Span)((List)map.get("testWriteTraceHooks")).get(0);
        Assert.assertNotNull((Object)s);
        long spanStart = s.getStartTimeMillis();
        long spanEnd = s.getStopTimeMillis();
        for (String desc : spansInTopTrace = new String[]{"testWriteTraceHooks", "ClientProtocol#create", "ClientNamenodeProtocol#create", "ClientProtocol#fsync", "ClientNamenodeProtocol#fsync", "ClientProtocol#complete", "ClientNamenodeProtocol#complete", "newStreamForCreate", "DFSOutputStream#write", "DFSOutputStream#close"}) {
            for (Span span : (List)map.get(desc)) {
                Assert.assertEquals((long)ts.getSpan().getSpanId().getHigh(), (long)span.getSpanId().getHigh());
            }
        }
        Assert.assertEquals((Object)"called", (Object)((TimelineAnnotation)((Span)((List)map.get("ClientProtocol#create")).get(0)).getTimelineAnnotations().get(0)).getMessage());
        SetSpanReceiver.clear();
    }

    private void readWithTracing(Tracer tracer) throws Exception {
        long startTime = System.currentTimeMillis();
        TraceScope ts = tracer.newScope("testReadTraceHooks");
        this.readTestFile("testReadTraceHooks.dat");
        ts.close();
        long endTime = System.currentTimeMillis();
        String[] expectedSpanNames = new String[]{"testReadTraceHooks", "ClientProtocol#getBlockLocations", "ClientNamenodeProtocol#getBlockLocations", "OpReadBlockProto"};
        SetSpanReceiver.assertSpanNamesFound((String[])expectedSpanNames);
        Map map = SetSpanReceiver.getMap();
        Span s = (Span)((List)map.get("testReadTraceHooks")).get(0);
        Assert.assertNotNull((Object)s);
        long spanStart = s.getStartTimeMillis();
        long spanEnd = s.getStopTimeMillis();
        Assert.assertTrue((spanStart - startTime < 100L ? 1 : 0) != 0);
        Assert.assertTrue((spanEnd - endTime < 100L ? 1 : 0) != 0);
        for (Span span : SetSpanReceiver.getSpans()) {
            System.out.println(span.toJson());
        }
        for (Span span : SetSpanReceiver.getSpans()) {
            Assert.assertEquals((long)ts.getSpan().getSpanId().getHigh(), (long)span.getSpanId().getHigh());
        }
        SetSpanReceiver.clear();
    }

    private void writeTestFile(String testFileName) throws Exception {
        Path filePath = new Path(testFileName);
        FSDataOutputStream stream = dfs.create(filePath);
        for (int i = 0; i < 10; ++i) {
            byte[] data = RandomStringUtils.randomAlphabetic((int)102400).getBytes();
            stream.write(data);
        }
        stream.hsync();
        stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTestFile(String testFileName) throws Exception {
        Path filePath = new Path(testFileName);
        FSDataInputStream istream = dfs.open(filePath, 10240);
        ByteBuffer buf = ByteBuffer.allocate(10240);
        int count = 0;
        try {
            while (istream.read(buf) > 0) {
                ++count;
                buf.clear();
                istream.seek(istream.getPos() + 5L);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            istream.close();
        }
    }

    @Before
    public void startCluster() throws IOException {
        cluster = new MiniDFSCluster.Builder(NO_TRACING_CONF).numDataNodes(3).build();
        cluster.waitActive();
        dfs = cluster.getFileSystem();
        SetSpanReceiver.clear();
    }

    @After
    public void shutDown() throws IOException {
        cluster.shutdown();
        FsTracer.clear();
    }

    static {
        NO_TRACING_CONF = new Configuration();
        NO_TRACING_CONF.setLong("dfs.blocksize", 102400L);
        TRACING_CONF = new Configuration(NO_TRACING_CONF);
        TRACING_CONF.set("fs.client.htrace.span.receiver.classes", SetSpanReceiver.class.getName());
        TRACING_CONF.set("fs.client.htrace.sampler.classes", "AlwaysSampler");
    }
}

