/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestBlocksScheduledCounter {
    MiniDFSCluster cluster = null;
    FileSystem fs = null;

    @After
    public void tearDown() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testBlocksScheduledCounter() throws IOException {
        this.cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
        ArrayList dnList = new ArrayList();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        dm.fetchDatanodes(dnList, dnList, false);
        DatanodeDescriptor dn = (DatanodeDescriptor)dnList.get(0);
        Assert.assertEquals((long)0L, (long)dn.getBlocksScheduled());
        FSDataOutputStream out = this.fs.create(new Path("/testBlockScheduledCounter"));
        for (int i = 0; i < 1024; ++i) {
            out.write(i);
        }
        out.hflush();
        Assert.assertEquals((long)1L, (long)dn.getBlocksScheduled());
        out.close();
        Assert.assertEquals((long)0L, (long)dn.getBlocksScheduled());
    }
}

