/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.hops.metadata.HdfsStorageFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mortbay.log.Log;

public class TestDatanodeManager {
    final int NUM_ITERATIONS = 500;

    @Test
    public void testNumVersionsReportedCorrect() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        DatanodeManager dm = new DatanodeManager((BlockManager)Mockito.mock(BlockManager.class), (Namesystem)fsn, new Configuration());
        Random rng = new Random();
        int seed = rng.nextInt();
        rng = new Random(seed);
        Log.info((String)("Using seed " + seed + " for testing"));
        HashMap<String, DatanodeRegistration> sIdToDnReg = new HashMap<String, DatanodeRegistration>();
        for (int i = 0; i < 500; ++i) {
            if (rng.nextBoolean() && i % 3 == 0 && sIdToDnReg.size() != 0) {
                int randomIndex = rng.nextInt() % sIdToDnReg.size();
                Iterator it = sIdToDnReg.entrySet().iterator();
                for (int j = 0; j < randomIndex - 1; ++j) {
                    it.next();
                }
                DatanodeRegistration toRemove = (DatanodeRegistration)it.next().getValue();
                Log.info((String)("Removing node " + toRemove.getDatanodeUuid() + " ip " + toRemove.getXferAddr() + " version : " + toRemove.getSoftwareVersion()));
                dm.removeDatanode((DatanodeID)toRemove, false);
                it.remove();
            } else {
                String storageID = "someStorageID" + rng.nextInt(5000);
                DatanodeRegistration dr = (DatanodeRegistration)Mockito.mock(DatanodeRegistration.class);
                Mockito.when((Object)dr.getDatanodeUuid()).thenReturn((Object)storageID);
                if (sIdToDnReg.containsKey(storageID)) {
                    dr = (DatanodeRegistration)sIdToDnReg.get(storageID);
                    if (rng.nextBoolean()) {
                        dr.setIpAddr(dr.getIpAddr() + "newIP");
                    }
                } else {
                    String ip = "someIP" + storageID;
                    Mockito.when((Object)dr.getIpAddr()).thenReturn((Object)ip);
                    Mockito.when((Object)dr.getXferAddr()).thenReturn((Object)(ip + ":9000"));
                    Mockito.when((Object)dr.getXferPort()).thenReturn((Object)9000);
                }
                Mockito.when((Object)dr.getSoftwareVersion()).thenReturn((Object)("version" + rng.nextInt(5)));
                Log.info((String)("Registering node storageID: " + dr.getDatanodeUuid() + ", version: " + dr.getSoftwareVersion() + ", IP address: " + dr.getXferAddr()));
                dm.registerDatanode(dr);
                sIdToDnReg.put(storageID, dr);
            }
            HashMap mapToCheck = dm.getDatanodesSoftwareVersions();
            for (Map.Entry it : sIdToDnReg.entrySet()) {
                String ver = ((DatanodeRegistration)it.getValue()).getSoftwareVersion();
                if (!mapToCheck.containsKey(ver)) {
                    throw new AssertionError((Object)("The correct number of datanodes of a version was not found on iteration " + i));
                }
                mapToCheck.put(ver, (Integer)mapToCheck.get(ver) - 1);
                if ((Integer)mapToCheck.get(ver) != 0) continue;
                mapToCheck.remove(ver);
            }
            for (Map.Entry entry : mapToCheck.entrySet()) {
                Log.info((String)("Still in map: " + (String)entry.getKey() + " has " + entry.getValue()));
            }
            Assert.assertEquals((String)("The map of version counts returned by DatanodeManager was not what it was expected to be on iteration " + i), (long)0L, (long)mapToCheck.size());
        }
    }
}

