/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class TestTriggerBlockReport {
    private void testTriggerBlockReport(boolean incremental) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blockreport.intervalMsec", 10800000L);
        conf.setLong("dfs.heartbeat.interval", 1080L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        DatanodeProtocolClientSideTranslatorPB spy = DataNodeTestUtils.spyOnBposToNN(cluster.getDataNodes().get(0), cluster.getNameNode());
        DFSTestUtil.createFile((FileSystem)fs, new Path("/abc"), 16L, (short)1, 1L);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spy, (VerificationMode)Mockito.timeout((int)60000).times(1))).blockReceivedAndDeleted((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageReceivedDeletedBlocks[])Matchers.any(StorageReceivedDeletedBlocks[].class));
        for (int i = 0; i < 3; ++i) {
            Thread.sleep(10L);
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)0))).blockReport((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageBlockReport[])Matchers.any(StorageBlockReport[].class));
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).blockReceivedAndDeleted((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageReceivedDeletedBlocks[])Matchers.any(StorageReceivedDeletedBlocks[].class));
        }
        DataNode datanode = cluster.getDataNodes().get(0);
        BPOfferService service = datanode.getAllBpOs()[0];
        String storageUuid = ((FsVolumeSpi)datanode.getFSDataset().getVolumes().get(0)).getStorageID();
        ExtendedBlock rdbi = new ExtendedBlock(service.getBlockPoolId(), 5678L, 512L, 1000L);
        service.notifyNamenodeDeletedBlock(rdbi, storageUuid);
        datanode.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(incremental).build());
        if (incremental) {
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spy, (VerificationMode)Mockito.timeout((int)60000).times(2))).blockReceivedAndDeleted((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageReceivedDeletedBlocks[])Matchers.any(StorageReceivedDeletedBlocks[].class));
        } else {
            ((DatanodeProtocolClientSideTranslatorPB)Mockito.verify((Object)spy, (VerificationMode)Mockito.timeout((int)60000))).blockReport((DatanodeRegistration)Matchers.any(DatanodeRegistration.class), Matchers.anyString(), (StorageBlockReport[])Matchers.any(StorageBlockReport[].class));
        }
        cluster.shutdown();
    }

    @Test
    public void testTriggerFullBlockReport() throws Exception {
        this.testTriggerBlockReport(false);
    }

    @Test
    public void testTriggerIncrementalBlockReport() throws Exception {
        this.testTriggerBlockReport(true);
    }
}

