/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Writer;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="The design of this test needs to be reconsidered. It fails most of the times because of race conditions.")
public class TestHADataNodeFailure
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestHADataNodeFailure.class);
    Configuration conf;
    MiniDFSCluster cluster;
    FileSystem fs;
    int NN1;
    int NN2;
    static int NUM_NAMENODES = 2;
    static int NUM_DATANODES = 1;
    long NNDeathTimeout;
    boolean writeInSameDir;
    boolean killNN;
    boolean waitFileisClosed;
    int fileCloseWaitTime;
    long waitReplicationTimeout;
    Path baseDir;
    Writer[] writers;

    public TestHADataNodeFailure() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        this.conf = new HdfsConfiguration();
        this.cluster = null;
        this.fs = null;
        this.NN1 = 0;
        this.NN2 = 1;
        this.NNDeathTimeout = 10000L;
        this.writeInSameDir = false;
        this.killNN = true;
        this.waitFileisClosed = true;
        this.fileCloseWaitTime = 5000;
        this.waitReplicationTimeout = 300000L;
        this.baseDir = new Path("/testsLoad");
        this.writers = new Writer[25];
    }

    private void setUp(int replicationFactor) throws IOException {
        if (NUM_NAMENODES < 2) {
            NUM_NAMENODES = 2;
        }
        this.conf = new Configuration();
        this.conf.setInt("dfs.replication", replicationFactor);
        this.conf.setInt("dfs.blocksize", 1024);
        this.conf.setLong("dfs.namenode.replication.pending.timeout-sec", 15L);
        this.conf.setInt("dfs.blockreport.intervalMsec", 15000);
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(NUM_NAMENODES)).format(true).numDataNodes(NUM_DATANODES).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getNewFileSystemInstance(this.NN1);
        this.NNDeathTimeout = this.conf.getInt("dfs.leader.check.interval", 2000) * (this.conf.getInt("dfs.leader.missed.hb", 2) + 2);
        TestHADataNodeFailure.assertTrue((boolean)this.fs.mkdirs(this.baseDir));
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i] = new Writer(this.fs, new String("file" + i), this.writeInSameDir, this.baseDir, this.waitFileisClosed, this.fileCloseWaitTime);
        }
    }

    private void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @After
    public void tearDown() throws Exception {
        this.cluster.shutdown();
    }

    @Test(timeout=900000L)
    public void testFailoverWhenDNCrashesTest1() {
        short repFactor = 3;
        LOG.info((Object)("TestNN Running test [testFailoverWhenDNCrashes()] with replication factor " + repFactor));
        this.failoverWhenDNCrashes(repFactor);
    }

    @Test(timeout=900000L)
    public void testFailoverWhenDNCrashesTest2() {
        short repFactor = 6;
        LOG.info((Object)("Running test [testFailoverWhenDNCrashes()] with replication factor " + repFactor));
        this.failoverWhenDNCrashes(repFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failoverWhenDNCrashes(short replicationFactor) {
        try {
            int numDatanodesToKill = 0;
            if (replicationFactor == 3) {
                NUM_DATANODES = 5;
                numDatanodesToKill = 2;
            } else if (replicationFactor == 6) {
                NUM_DATANODES = 11;
                numDatanodesToKill = 5;
            }
            this.setUp(replicationFactor);
            int nnport = this.cluster.getNameNodePort(this.NN1);
            try {
                Writer.startWriters(this.writers);
                Thread.sleep(10000L);
                for (int i = 0; i < numDatanodesToKill; ++i) {
                    int dnIndex = AppendTestUtil.nextInt(numDatanodesToKill);
                    LOG.debug((Object)("TestNN DataNode Killed " + this.cluster.getDataNodes().get(dnIndex).getDatanodeId()));
                    this.cluster.stopDataNode(dnIndex);
                    try {
                        Thread.sleep(15000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                LOG.info((Object)"TestNN Wait a few seconds. Let them write some more");
                Thread.sleep(2000L);
            }
            finally {
                Writer.stopWriters(this.writers);
            }
            Writer.waitReplication(this.fs, this.writers, replicationFactor, this.waitReplicationTimeout);
        }
        catch (Exception ex) {
            LOG.error((Object)("Received exception: " + ex.getMessage()), (Throwable)ex);
            ex.printStackTrace();
            TestHADataNodeFailure.fail((String)("Exception: " + ex.getMessage()));
        }
        finally {
            this.shutdown();
        }
    }
}

