/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TestHABasicFailover;
import org.apache.hadoop.hdfs.server.namenode.Writer;
import org.apache.log4j.Level;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="The design of this test needs to be reconsidered. It fails most of the times because of race conditions.")
public class TestHAFileCreation
extends TestCase {
    public static final Log LOG = LogFactory.getLog(TestHAFileCreation.class);
    Configuration conf;
    MiniDFSCluster cluster;
    FileSystem fs;
    int NN1;
    int NN2;
    static int NUM_NAMENODES = 2;
    static int NUM_DATANODES = 1;
    long NNDeathTimeout;
    boolean writeInSameDir;
    boolean killNN;
    boolean waitFileisClosed;
    int fileCloseWaitTime;
    int waitReplicationTimeout;
    Path baseDir;
    Writer[] writers;

    public TestHAFileCreation() {
        ((Log4JLogger)NameNode.stateChangeLog).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        this.conf = new HdfsConfiguration();
        this.cluster = null;
        this.fs = null;
        this.NN1 = 0;
        this.NN2 = 1;
        this.NNDeathTimeout = 10000L;
        this.writeInSameDir = true;
        this.killNN = true;
        this.waitFileisClosed = true;
        this.fileCloseWaitTime = 5000;
        this.waitReplicationTimeout = 300000;
        this.baseDir = new Path("/testsLoad");
        this.writers = new Writer[10];
    }

    private void setupCluster(int replicationFactor) throws IOException {
        if (NUM_NAMENODES < 2) {
            NUM_NAMENODES = 2;
        }
        if (replicationFactor > NUM_DATANODES) {
            NUM_DATANODES = replicationFactor;
        }
        this.conf = new Configuration();
        this.conf.setInt("dfs.replication", replicationFactor);
        this.conf.setInt("dfs.blocksize", 1024);
        this.conf.setLong("dfs.namenode.replication.pending.timeout-sec", 15L);
        this.conf.setInt("dfs.client.failover.max.attempts", 1);
        this.conf.setInt("dfs.client.retry.max.attempts", 1);
        this.conf.setInt("dfs.client.failover.sleep.base.millis", 500);
        this.conf.setInt("dfs.client.failover.sleep.max.millis", 1000);
        this.conf.setInt("dfs.client.failover.connection.retries", 0);
        this.conf.setInt("dfs.client.failover.connection.retries.on.timeouts", 0);
        this.conf.setInt("ipc.client.connect.max.retries.on.timeouts", 2);
        this.conf.setInt("ipc.client.connect.max.retries", 1);
        this.conf.set("dfs.client.retry.policy.spec", "1000,2");
        this.cluster = new MiniDFSCluster.Builder(this.conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(NUM_NAMENODES)).format(true).numDataNodes(NUM_DATANODES).build();
        this.cluster.waitActive();
        LOG.debug((Object)("NN1 address is " + this.cluster.getNameNode(this.NN1).getNameNodeAddress() + " ld: " + this.cluster.getNameNode(this.NN1).isLeader() + " NN2 address is " + this.cluster.getNameNode(this.NN2).getNameNodeAddress() + " ld: " + this.cluster.getNameNode(this.NN2).isLeader()));
        this.fs = this.cluster.getNewFileSystemInstance(this.NN1);
        this.NNDeathTimeout = this.conf.getInt("dfs.leader.check.interval", 2000) * (this.conf.getInt("dfs.leader.missed.hb", 2) + 2);
        TestHAFileCreation.assertTrue((boolean)this.fs.mkdirs(this.baseDir));
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i] = new Writer(this.fs, new String("file" + i), this.writeInSameDir, this.baseDir, this.waitFileisClosed, this.fileCloseWaitTime);
        }
    }

    private void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testFailoverWhenLeaderNNCrashesTest1() {
        short repFactor = 3;
        LOG.info((Object)("Running test [testFailoverWhenLeaderNNCrashes()] with replication factor " + repFactor));
        this.failoverWhenLeaderNNCrashes(repFactor);
    }

    @Test
    public void testFailoverWhenLeaderNNCrashesTest2() {
        short repFactor = 6;
        LOG.info((Object)("Running test [testFailoverWhenLeaderNNCrashes()] with replication factor " + repFactor));
        this.failoverWhenLeaderNNCrashes(repFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failoverWhenLeaderNNCrashes(short replicationFactor) {
        try {
            this.setupCluster(replicationFactor);
            int nnport = this.cluster.getNameNodePort(this.NN1);
            try {
                Writer.startWriters(this.writers);
                Thread.sleep(10000L);
                LOG.debug((Object)("TestNN about to shutdown the namenode with address " + this.cluster.getNameNode(this.NN1).getNameNodeAddress()));
                if (this.killNN) {
                    this.cluster.shutdownNameNode(this.NN1);
                    LOG.debug((Object)"TestNN KILLED Namenode with address ");
                    TestHABasicFailover.waitLeaderElection(this.cluster.getDataNodes(), this.cluster.getNameNode(this.NN2), this.NNDeathTimeout);
                    TestHAFileCreation.assertTrue((String)"TestNN NN2 is expected to be the leader, but is not", (boolean)this.cluster.getNameNode(this.NN2).isLeader());
                    TestHAFileCreation.assertTrue((String)"TestNN Not all datanodes detected the new leader", (boolean)TestHABasicFailover.doesDataNodesRecognizeLeader(this.cluster.getDataNodes(), this.cluster.getNameNode(this.NN2)));
                }
                LOG.info((Object)"TestNN Wait a few seconds. Let them write some more");
                Thread.sleep(10000L);
            }
            finally {
                Writer.stopWriters(this.writers);
            }
            LOG.debug((Object)"TestNN All File Should Have been closed");
            Writer.verifyFile(this.writers, this.fs);
            Writer.waitReplication(this.fs, this.writers, replicationFactor, this.waitReplicationTimeout);
            return;
        }
        catch (Exception ex) {
            LOG.error((Object)("Received exception: " + ex.getMessage()), (Throwable)ex);
            ex.printStackTrace();
            TestHAFileCreation.fail((String)("Exception: " + ex.getMessage()));
        }
        finally {
            this.shutdown();
        }
    }
}

