/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestLease;
import org.apache.hadoop.hdfs.server.namenode.Lease;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.junit.Assert;
import org.junit.Test;

public class TestLeaseManager {
    Configuration conf = new HdfsConfiguration();

    @Test
    public void testRemoveLeaseWithPrefixPath() throws Exception {
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        cluster.waitActive();
        LeaseManager lm = NameNodeAdapter.getLeaseManager(cluster.getNamesystem());
        this.addLease(lm, "holder1", "/a/b");
        this.addLease(lm, "holder2", "/a/c");
        Assert.assertNotNull((Object)TestLeaseManager.getLeaseByPath(lm, "/a/b"));
        Assert.assertNotNull((Object)TestLeaseManager.getLeaseByPath(lm, "/a/c"));
        TestLeaseManager.removeLeaseWithPrefixPath(lm, "/a");
        Assert.assertNull((Object)TestLeaseManager.getLeaseByPath(lm, "/a/b"));
        Assert.assertNull((Object)TestLeaseManager.getLeaseByPath(lm, "/a/c"));
        this.addLease(lm, "holder1", "/a/b");
        this.addLease(lm, "holder2", "/a/c");
        TestLeaseManager.removeLeaseWithPrefixPath(lm, "/a/");
        Assert.assertNull((Object)TestLeaseManager.getLeaseByPath(lm, "/a/b"));
        Assert.assertNull((Object)TestLeaseManager.getLeaseByPath(lm, "/a/c"));
    }

    private void addLease(final LeaseManager lm, final String holder, final String path) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE, holder));
            }

            public Object performTask() throws IOException {
                lm.addLease(holder, path);
                return null;
            }
        }.handle();
    }

    static Lease getLeaseByPath(final LeaseManager lm, final String path) throws IOException {
        return (Lease)new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                locks.add((Lock)new TestLease.TestLeaseLock(TransactionLockTypes.LockType.READ, TransactionLockTypes.LockType.WRITE, path));
            }

            public Object performTask() throws IOException {
                return lm.getLeaseByPath(path);
            }
        }.handle();
    }

    static void removeLeaseWithPrefixPath(final LeaseManager lm, final String path) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.TEST){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getLeaseLock(TransactionLockTypes.LockType.WRITE)).add(lf.getLeasePathLock(TransactionLockTypes.LockType.WRITE, path));
            }

            public Object performTask() throws IOException {
                lm.removeLeaseWithPrefixPath(path);
                return null;
            }
        }.handle();
    }
}

