/*
 * Decompiled with CFR 0.152.
 */
package io.hops.common;

import io.hops.common.CountersQueue;
import java.io.IOException;

public abstract class IDsGenerator {
    private int batchSize;
    private int threshold;
    private CountersQueue cQ;

    IDsGenerator(int batchSize, float threshold) {
        this.batchSize = batchSize;
        this.threshold = (int)(threshold * (float)batchSize);
        this.cQ = new CountersQueue();
    }

    public long getUniqueID() {
        return this.cQ.next();
    }

    protected synchronized boolean getMoreIdsIfNeeded() throws IOException {
        if (!this.cQ.has(this.threshold)) {
            this.cQ.addCounter(this.incrementCounter(this.batchSize));
            return true;
        }
        return false;
    }

    protected CountersQueue getCQ() {
        return this.cQ;
    }

    abstract CountersQueue.Counter incrementCounter(int var1) throws IOException;
}

