/*
 * Decompiled with CFR 0.152.
 */
package io.hops.common;

import io.hops.common.INodeResolver;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.adaptor.INodeDALAdaptor;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.AceDataAccess;
import io.hops.metadata.hdfs.dal.BlockLookUpDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.dal.LeaseDataAccess;
import io.hops.metadata.hdfs.dal.LeasePathDataAccess;
import io.hops.metadata.hdfs.entity.BlockLookUp;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.LeasePath;
import io.hops.metadata.hdfs.entity.ProjectedINode;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.util.Slicer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAclHelper;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.Lease;

public class INodeUtil {
    private static final Log LOG = LogFactory.getLog(INodeUtil.class);

    public static String constructPath(byte[][] components, int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end; ++i) {
            buf.append(DFSUtil.bytes2String(components[i]));
            if (i >= end - 1) continue;
            buf.append("/");
        }
        return buf.toString();
    }

    public static INode getNode(byte[] name, long parentId, long partitionId, boolean transactional) throws StorageException, TransactionContextException {
        String nameString = DFSUtil.bytes2String(name);
        if (transactional) {
            return (INode)EntityManager.find((FinderType)INode.Finder.ByNameParentIdAndPartitionId, (Object[])new Object[]{nameString, parentId, partitionId});
        }
        return INodeUtil.findINodeWithNoTransaction(nameString, parentId, partitionId);
    }

    public static INode getNode(long inodeId, boolean transactional) throws StorageException, TransactionContextException {
        if (transactional) {
            return (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{inodeId});
        }
        return INodeUtil.findINodeWithNoTransaction(inodeId);
    }

    private static INode findINodeWithNoTransaction(String name, long parentId, long partitionId) throws StorageException {
        LOG.debug((Object)String.format("Read inode with no transaction by parent_id=%d, name=%s, partitionId=%s", parentId, name, parentId));
        INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
        return (INode)da.findInodeByNameParentIdAndPartitionIdPK(name, parentId, partitionId);
    }

    private static INode findINodeWithNoTransaction(long inodeId) throws StorageException {
        LOG.debug((Object)String.format("Read inode with no transaction by inodeId=%d", inodeId));
        INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
        return (INode)da.findInodeByIdFTIS(inodeId);
    }

    public static boolean resolvePathWithNoTransaction(String path, boolean resolveLink, LinkedList<INode> preTxResolvedINodes) throws UnresolvedPathException, StorageException, TransactionContextException {
        preTxResolvedINodes.clear();
        byte[][] components = INode.getPathComponents(path);
        INode curNode = INodeUtil.getRoot();
        preTxResolvedINodes.add(curNode);
        if (components.length == 1) {
            return false;
        }
        INodeResolver resolver = new INodeResolver(components, curNode, resolveLink, false);
        while (resolver.hasNext()) {
            curNode = resolver.next();
            if (curNode == null) continue;
            preTxResolvedINodes.add(curNode);
        }
        return preTxResolvedINodes.size() == components.length;
    }

    public static void findPathINodesById(long inodeId, boolean inTree, LinkedList<INode> preTxResolvedINodes, boolean[] isPreTxPathFullyResolved) throws StorageException {
        if (inTree) {
            INode inode = INodeUtil.indexINodeScanById(inodeId);
            if (inode == null) {
                isPreTxPathFullyResolved[0] = false;
                return;
            }
            preTxResolvedINodes.add(inode);
            INodeUtil.readFromLeafToRoot(inode, preTxResolvedINodes);
        }
        isPreTxPathFullyResolved[0] = true;
        int firstCounter = 0;
        int lastCounter = preTxResolvedINodes.size() - 1 - firstCounter;
        INode firstNode = null;
        INode lastNode = null;
        while (firstCounter < preTxResolvedINodes.size() / 2) {
            firstNode = preTxResolvedINodes.get(firstCounter);
            lastNode = preTxResolvedINodes.get(lastCounter);
            preTxResolvedINodes.remove(firstCounter);
            preTxResolvedINodes.add(firstCounter, lastNode);
            preTxResolvedINodes.remove(lastCounter);
            preTxResolvedINodes.add(lastCounter, firstNode);
            lastCounter = preTxResolvedINodes.size() - 1 - ++firstCounter;
        }
    }

    public static Set<String> findPathsByLeaseHolder(String holder) throws StorageException {
        HashSet<String> paths = new HashSet<String>();
        LeaseDataAccess lda = (LeaseDataAccess)HdfsStorageFactory.getDataAccess(LeaseDataAccess.class);
        Lease rcLease = (Lease)lda.findByPKey(holder, Lease.getHolderId(holder));
        if (rcLease == null) {
            return paths;
        }
        LeasePathDataAccess pda = (LeasePathDataAccess)HdfsStorageFactory.getDataAccess(LeasePathDataAccess.class);
        Collection rclPaths = pda.findByHolderId(rcLease.getHolderID());
        for (LeasePath lp : rclPaths) {
            paths.add(lp.getPath());
        }
        return paths;
    }

    private static INode getRoot() throws StorageException, TransactionContextException {
        return INodeUtil.getNode("".getBytes(), 0L, INodeDirectory.getRootDirPartitionKey(), false);
    }

    public static INode indexINodeScanById(long id) throws StorageException {
        LOG.debug((Object)String.format("Read inode with no transaction by id=%d", id));
        INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
        return (INode)da.findInodeByIdFTIS(id);
    }

    private static void readFromLeafToRoot(INode inode, LinkedList<INode> list) throws StorageException {
        INode temp = inode;
        while (temp != null && temp.getParentId() != 0L) {
            if ((temp = INodeUtil.indexINodeScanById(temp.getParentId())) == null) continue;
            list.add(temp);
        }
    }

    public static INodeIdentifier resolveINodeFromBlockID(final long bid) throws StorageException {
        INodeIdentifier inodeIdentifier;
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.RESOLVE_INODE_FROM_BLOCKID){

            public Object performTask() throws IOException {
                BlockLookUpDataAccess da = (BlockLookUpDataAccess)HdfsStorageFactory.getDataAccess(BlockLookUpDataAccess.class);
                BlockLookUp blu = (BlockLookUp)da.findByBlockId(bid);
                if (blu == null) {
                    return null;
                }
                INodeIdentifier inodeIdent = new INodeIdentifier(Long.valueOf(blu.getInodeId()));
                INodeDALAdaptor ida = (INodeDALAdaptor)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                INode inode = ida.findInodeByIdFTIS(blu.getInodeId());
                if (inode != null) {
                    inodeIdent.setName(inode.getLocalName());
                    inodeIdent.setPid(Long.valueOf(inode.getParentId()));
                    inodeIdent.setPartitionId(inode.getPartitionId());
                }
                return inodeIdent;
            }
        };
        try {
            inodeIdentifier = (INodeIdentifier)handler.handle();
        }
        catch (IOException ex) {
            LOG.error((Object)("Could not resolve iNode from blockId (blockid=" + bid + ")"));
            throw new StorageException(ex.getMessage());
        }
        return inodeIdentifier;
    }

    public static INodeIdentifier resolveINodeFromBlock(Block b) throws StorageException {
        if (b instanceof BlockInfo || b instanceof BlockInfoUnderConstruction) {
            INodeIdentifier inodeIden = new INodeIdentifier(Long.valueOf(((BlockInfo)b).getInodeId()));
            INodeDALAdaptor ida = (INodeDALAdaptor)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
            INode inode = ida.findInodeByIdFTIS(((BlockInfo)b).getInodeId());
            if (inode != null) {
                inodeIden.setName(inode.getLocalName());
                inodeIden.setPid(Long.valueOf(inode.getParentId()));
                inodeIden.setPartitionId(inode.getPartitionId());
            }
            return inodeIden;
        }
        return INodeUtil.resolveINodeFromBlockID(b.getBlockId());
    }

    public static Map<Long, List<Long>> getINodeIdsForBlockIds(final List<Long> blockIds, int batchSize, int nbThreads, ExecutorService executor) throws IOException {
        final HashMap<Long, List<Long>> inodeIds = new HashMap<Long, List<Long>>();
        try {
            Slicer.slice((int)blockIds.size(), (int)batchSize, (int)nbThreads, (ExecutorService)executor, (Slicer.OperationHandler)new Slicer.OperationHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handle(int startIndex, int endIndex) throws Exception {
                    List ids = blockIds.subList(startIndex, endIndex);
                    final long[] array = new long[ids.size()];
                    int i = 0;
                    Iterator iterator = ids.iterator();
                    while (iterator.hasNext()) {
                        long blockId;
                        array[i] = blockId = ((Long)iterator.next()).longValue();
                        ++i;
                    }
                    LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.RESOLVE_INODES_FROM_BLOCKIDS){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object performTask() throws IOException {
                            boolean transactionActive = connector.isTransactionActive();
                            try {
                                Map inodeIds;
                                if (!transactionActive) {
                                    connector.beginTransaction();
                                }
                                BlockLookUpDataAccess da = (BlockLookUpDataAccess)HdfsStorageFactory.getDataAccess(BlockLookUpDataAccess.class);
                                Map map = inodeIds = da.getINodeIdsForBlockIds(array);
                                return map;
                            }
                            finally {
                                if (!transactionActive) {
                                    connector.commit();
                                }
                            }
                        }
                    };
                    try {
                        Map map = (Map)handler.handle();
                        Map map2 = inodeIds;
                        synchronized (map2) {
                            Iterator iterator2 = map.keySet().iterator();
                            while (iterator2.hasNext()) {
                                long inodeId = (Long)iterator2.next();
                                ArrayList blockIds2 = (ArrayList)inodeIds.get(inodeId);
                                if (blockIds2 == null) {
                                    blockIds2 = new ArrayList();
                                    inodeIds.put(inodeId, blockIds2);
                                }
                                blockIds2.addAll((Collection)map.get(inodeId));
                            }
                        }
                    }
                    catch (IOException ex) {
                        LOG.error((Object)("Could not resolve iNode from blockId (blockid=" + Arrays.toString(array) + ")"));
                        throw new StorageException(ex.getMessage());
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return inodeIds;
    }

    public static List<INodeIdentifier> resolveINodesFromIds(final List<Long> inodeIds) throws StorageException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.RESOLVE_INODES_FROM_IDS){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object performTask() throws IOException {
                boolean transactionActive = connector.isTransactionActive();
                try {
                    if (!transactionActive) {
                        connector.beginTransaction();
                    }
                    INodeDALAdaptor ida = (INodeDALAdaptor)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                    long[] ids = new long[inodeIds.size()];
                    int i = 0;
                    Iterator iterator = inodeIds.iterator();
                    while (iterator.hasNext()) {
                        long id;
                        ids[i] = id = ((Long)iterator.next()).longValue();
                        ++i;
                    }
                    ArrayList<INodeIdentifier> result = new ArrayList<INodeIdentifier>(inodeIds.size());
                    Collection<INode> inodes = ida.findInodesByIdsFTIS(ids);
                    if (inodes == null) {
                        ArrayList<INodeIdentifier> arrayList = result;
                        return arrayList;
                    }
                    for (INode inode : inodes) {
                        INodeIdentifier inodeIdent = new INodeIdentifier(Long.valueOf(inode.getId()));
                        inodeIdent.setName(inode.getLocalName());
                        inodeIdent.setPid(Long.valueOf(inode.getParentId()));
                        inodeIdent.setPartitionId(inode.getPartitionId());
                        result.add(inodeIdent);
                    }
                    ArrayList<INodeIdentifier> arrayList = result;
                    return arrayList;
                }
                finally {
                    if (!transactionActive) {
                        connector.commit();
                    }
                }
            }
        };
        try {
            return (List)handler.handle();
        }
        catch (IOException ex) {
            LOG.error((Object)"Could not resolve iNode from their Id");
            throw new StorageException(ex.getMessage());
        }
    }

    public static long[] resolveINodesFromBlockIds(final long[] blockIds) throws StorageException {
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.GET_INODEIDS_FOR_BLKS){

            public Object performTask() throws IOException {
                BlockLookUpDataAccess da = (BlockLookUpDataAccess)HdfsStorageFactory.getDataAccess(BlockLookUpDataAccess.class);
                return da.findINodeIdsByBlockIds(blockIds);
            }
        };
        try {
            return (long[])handler.handle();
        }
        catch (IOException ex) {
            throw new StorageException(ex.getMessage());
        }
    }

    public static INodeIdentifier resolveINodeFromId(final long id) throws StorageException {
        INodeIdentifier inodeIdentifier;
        LightWeightRequestHandler handler = new LightWeightRequestHandler(HDFSOperationType.RESOLVE_INODE_FROM_ID){

            public Object performTask() throws StorageException, IOException {
                INodeDALAdaptor ida = (INodeDALAdaptor)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                INode inode = ida.findInodeByIdFTIS(id);
                INodeIdentifier inodeIdent = new INodeIdentifier(Long.valueOf(id));
                if (inode != null) {
                    inodeIdent.setName(inode.getLocalName());
                    inodeIdent.setPid(Long.valueOf(inode.getParentId()));
                    inodeIdent.setPartitionId(inode.getPartitionId());
                }
                return inodeIdent;
            }
        };
        try {
            inodeIdentifier = (INodeIdentifier)handler.handle();
        }
        catch (IOException ex) {
            throw new StorageException(ex.getMessage());
        }
        return inodeIdentifier;
    }

    public static String constructPath(List<INode> pathINodes) {
        StringBuilder builder = new StringBuilder();
        for (INode node : pathINodes) {
            if (node.isDirectory()) {
                builder.append(node.getLocalName() + "/");
                continue;
            }
            builder.append(node.getLocalName());
        }
        return builder.toString();
    }

    public static List<AclEntry> getInodeOwnAclNoTransaction(INode inode) throws AclException, StorageException {
        AceDataAccess aceDataAccess = (AceDataAccess)HdfsStorageFactory.getDataAccess(AceDataAccess.class);
        int numAces = inode.getNumAces();
        if (numAces == 0) {
            return new ArrayList<AclEntry>();
        }
        int[] aceIndices = new int[numAces];
        for (int i = 0; i < aceIndices.length; ++i) {
            aceIndices[i] = i;
        }
        List acesByPKBatched = aceDataAccess.getAcesByPKBatched(inode.getId(), aceIndices);
        return INodeAclHelper.convert(acesByPKBatched);
    }

    public static List<AclEntry> getInodeOwnAclNoTransaction(ProjectedINode child) throws StorageException, AclException {
        AceDataAccess aceDataAccess = (AceDataAccess)HdfsStorageFactory.getDataAccess(AceDataAccess.class);
        int numAces = child.getNumAces();
        if (numAces == 0) {
            return new ArrayList<AclEntry>();
        }
        int[] aceIndices = new int[numAces];
        for (int i = 0; i < aceIndices.length; ++i) {
            aceIndices[i] = i;
        }
        List acesByPKBatched = aceDataAccess.getAcesByPKBatched(child.getId(), aceIndices);
        return INodeAclHelper.convert(acesByPKBatched);
    }

    public static List<INode> getChildrenListNotTransactional(long inodeId, int depth) throws StorageException, TransactionContextException {
        List<INode> children = INodeUtil.getChildrenNotTransactional(inodeId, depth);
        return children == null ? INode.EMPTY_LIST : children;
    }

    private static List<INode> getChildrenNotTransactional(long inodeId, int depth) throws StorageException, TransactionContextException {
        INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
        short childrenDepth = (short)(depth + 1);
        if (INode.isTreeLevelRandomPartitioned(childrenDepth)) {
            return da.findInodesByParentIdFTIS(inodeId);
        }
        return da.findInodesByParentIdAndPartitionIdPPIS(inodeId, inodeId);
    }
}

