/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.blockmanagement;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.ExcessReplicaDataAccess;
import io.hops.metadata.hdfs.entity.ExcessReplica;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.util.LightWeightLinkedSet;

public class ExcessReplicasMap {
    private final DatanodeManager datanodeManager;

    public ExcessReplicasMap(DatanodeManager datanodeManager) {
        this.datanodeManager = datanodeManager;
    }

    public LightWeightLinkedSet<Block> get(String datanodeUuid, DatanodeManager manager) throws IOException {
        LightWeightLinkedSet<Block> excessReplicas = new LightWeightLinkedSet<Block>();
        List<Integer> sidsOnDatanode = manager.getSidsOnDatanode(datanodeUuid);
        for (int sid : sidsOnDatanode) {
            excessReplicas.addAll((Collection<Block>)this.get(sid));
        }
        return excessReplicas;
    }

    public LightWeightLinkedSet<Block> get(int sid) throws IOException {
        Collection<ExcessReplica> excessReplicas = this.getExcessReplicas(sid);
        if (excessReplicas == null) {
            return null;
        }
        LightWeightLinkedSet<Block> excessBlocks = new LightWeightLinkedSet<Block>();
        for (ExcessReplica er : excessReplicas) {
            excessBlocks.add(new Block(er.getBlockId()));
        }
        return excessBlocks;
    }

    public boolean put(int storageId, BlockInfo excessBlk) throws StorageException, TransactionContextException {
        ExcessReplica er = this.getExcessReplica(storageId, excessBlk);
        if (er == null) {
            this.addExcessReplicaToDB(new ExcessReplica(storageId, excessBlk.getBlockId(), excessBlk.getInodeId()));
            return true;
        }
        return false;
    }

    public boolean remove(DatanodeDescriptor dn, BlockInfo block) throws StorageException, TransactionContextException {
        boolean found = false;
        for (DatanodeStorageInfo storage : dn.getStorageInfos()) {
            ExcessReplica er = this.getExcessReplica(storage.getSid(), block);
            if (er == null) continue;
            this.removeExcessReplicaFromDB(er);
            found = true;
        }
        return found;
    }

    public Collection<String> get(BlockInfo blk) throws StorageException, TransactionContextException {
        Collection<ExcessReplica> excessReplicas = this.getExcessReplicas(blk);
        if (excessReplicas == null) {
            return null;
        }
        TreeSet<String> stIds = new TreeSet<String>();
        for (ExcessReplica er : excessReplicas) {
            stIds.add(this.datanodeManager.getDatanodeBySid(er.getStorageId()).getDatanodeUuid());
        }
        return stIds;
    }

    public boolean contains(DatanodeStorageInfo storageInfo, BlockInfo blk) throws IOException {
        return this.contains(storageInfo.getSid(), blk);
    }

    public boolean contains(final int sid, final BlockInfo blk) throws IOException {
        return new LightWeightRequestHandler(HDFSOperationType.GET_EXCESS_RELPLICAS_BY_STORAGEID){

            public Object performTask() throws StorageException, IOException {
                ExcessReplicaDataAccess da = (ExcessReplicaDataAccess)HdfsStorageFactory.getDataAccess(ExcessReplicaDataAccess.class);
                return da.findByPK(blk.getBlockId(), sid, blk.getInodeId());
            }
        }.handle() != null;
    }

    public void clear() throws IOException {
        new LightWeightRequestHandler(HDFSOperationType.DEL_ALL_EXCESS_BLKS){

            public Object performTask() throws StorageException, IOException {
                ExcessReplicaDataAccess da = (ExcessReplicaDataAccess)HdfsStorageFactory.getDataAccess(ExcessReplicaDataAccess.class);
                da.removeAll();
                return null;
            }
        }.handle();
    }

    private Collection<ExcessReplica> getExcessReplicas(final int sid) throws IOException {
        return (Collection)new LightWeightRequestHandler(HDFSOperationType.GET_EXCESS_RELPLICAS_BY_STORAGEID){

            public Object performTask() throws StorageException, IOException {
                ExcessReplicaDataAccess da = (ExcessReplicaDataAccess)HdfsStorageFactory.getDataAccess(ExcessReplicaDataAccess.class);
                return da.findExcessReplicaBySid(sid);
            }
        }.handle();
    }

    private void addExcessReplicaToDB(ExcessReplica er) throws StorageException, TransactionContextException {
        EntityManager.add((Object)er);
    }

    private void removeExcessReplicaFromDB(ExcessReplica er) throws StorageException, TransactionContextException {
        EntityManager.remove((Object)er);
    }

    private Collection<ExcessReplica> getExcessReplicas(BlockInfo blk) throws StorageException, TransactionContextException {
        return EntityManager.findList((FinderType)ExcessReplica.Finder.ByBlockIdAndINodeId, (Object[])new Object[]{blk.getBlockId(), blk.getInodeId()});
    }

    private ExcessReplica getExcessReplica(int sid, BlockInfo block) throws StorageException, TransactionContextException {
        return (ExcessReplica)EntityManager.find((FinderType)ExcessReplica.Finder.ByBlockIdSidAndINodeId, (Object[])new Object[]{block.getBlockId(), sid, block.getInodeId()});
    }

    public int size() throws IOException {
        return (Integer)new LightWeightRequestHandler(HDFSOperationType.COUNT_CORRUPT_REPLICAS){

            public Object performTask() throws IOException {
                ExcessReplicaDataAccess da = (ExcessReplicaDataAccess)HdfsStorageFactory.getDataAccess(ExcessReplicaDataAccess.class);
                return da.countAllUniqueBlk();
            }
        }.handle();
    }
}

