/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;

class BlockPK {
    private long blockId = Long.MIN_VALUE;
    private long inodeId = BlockInfo.NON_EXISTING_ID;

    BlockPK() {
    }

    BlockPK(Long blockId, Long inodeId) {
        if (blockId != null) {
            this.blockId = blockId;
        }
        if (inodeId != null) {
            this.inodeId = inodeId;
        }
    }

    boolean hasBlockId() {
        return this.blockId != Long.MIN_VALUE;
    }

    boolean hasINodeId() {
        return this.inodeId != (long)BlockInfo.NON_EXISTING_ID;
    }

    long getBlockId() {
        return this.blockId;
    }

    long getInodeId() {
        return this.inodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockPK)) {
            return false;
        }
        BlockPK blockPK = (BlockPK)o;
        if (this.blockId != blockPK.blockId) {
            return false;
        }
        return this.inodeId == blockPK.inodeId;
    }

    public int hashCode() {
        int result = (int)(this.blockId ^ this.blockId >>> 32);
        result = 31 * result + Long.hashCode(this.inodeId);
        return result;
    }

    static List<BlockPK> getBlockKeys(long[] inodeIds) {
        ArrayList<BlockPK> keys = new ArrayList<BlockPK>(inodeIds.length);
        for (long inodeId : inodeIds) {
            keys.add(new BlockPK(null, inodeId));
        }
        return keys;
    }

    static class CachedBlockPK
    extends BlockPK {
        private String datanodeId = null;

        CachedBlockPK(long blockId, long inodeId, String datanodeId) {
            super(blockId, inodeId);
            this.datanodeId = datanodeId;
        }

        CachedBlockPK(long blockId, long inodeId) {
            super(blockId, inodeId);
        }

        CachedBlockPK(String datanodeId) {
            this.datanodeId = datanodeId;
        }

        CachedBlockPK(long inodeId) {
            super(null, inodeId);
        }

        String getDatanodeId() {
            return this.datanodeId;
        }

        boolean hasDatanodeId() {
            return this.datanodeId != null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CachedBlockPK)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CachedBlockPK cachedBlockPK = (CachedBlockPK)o;
            return this.datanodeId.equals(cachedBlockPK.datanodeId);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.datanodeId.hashCode();
            return result;
        }

        static List<CachedBlockPK> getKeys(long[] blockIds, int storageId) {
            ArrayList<CachedBlockPK> keys = new ArrayList<CachedBlockPK>(blockIds.length);
            for (long blockId : blockIds) {
                keys.add(new CachedBlockPK(blockId, storageId));
            }
            return keys;
        }

        static List<CachedBlockPK> getKeys(long[] inodeIds) {
            ArrayList<CachedBlockPK> keys = new ArrayList<CachedBlockPK>(inodeIds.length);
            for (long inodeId : inodeIds) {
                keys.add(new CachedBlockPK(inodeId));
            }
            return keys;
        }

        static List<CachedBlockPK> getKeys(long[] blockIds, int[] inodeIds, String datanodeId) {
            ArrayList<CachedBlockPK> keys = new ArrayList<CachedBlockPK>(blockIds.length);
            for (int i = 0; i < blockIds.length; ++i) {
                keys.add(new CachedBlockPK(blockIds[i], inodeIds[i], datanodeId));
            }
            return keys;
        }
    }

    static class ReplicaPK
    extends BlockPK {
        private int storageId;

        ReplicaPK(long blockId, long inodeId, int storageId) {
            super(blockId, inodeId);
            this.storageId = storageId;
        }

        ReplicaPK(long blockId, int storageId) {
            super(blockId, null);
            this.storageId = storageId;
        }

        ReplicaPK(long inodeId) {
            super(null, inodeId);
        }

        int getStorageId() {
            return this.storageId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReplicaPK)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReplicaPK replicaPK = (ReplicaPK)o;
            return this.storageId == replicaPK.storageId;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.storageId;
            return result;
        }

        static List<ReplicaPK> getKeys(long[] blockIds, int storageId) {
            ArrayList<ReplicaPK> keys = new ArrayList<ReplicaPK>(blockIds.length);
            for (long blockId : blockIds) {
                keys.add(new ReplicaPK(blockId, storageId));
            }
            return keys;
        }

        static List<ReplicaPK> getKeys(long[] inodeIds) {
            ArrayList<ReplicaPK> keys = new ArrayList<ReplicaPK>(inodeIds.length);
            for (long inodeId : inodeIds) {
                keys.add(new ReplicaPK(inodeId));
            }
            return keys;
        }

        static List<ReplicaPK> getKeys(long[] blockIds, long[] inodeIds, int storageId) {
            ArrayList<ReplicaPK> keys = new ArrayList<ReplicaPK>(blockIds.length);
            for (int i = 0; i < blockIds.length; ++i) {
                keys.add(new ReplicaPK(blockIds[i], inodeIds[i], storageId));
            }
            return keys;
        }
    }
}

