/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.context;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.dal.MetadataLogDataAccess;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.transaction.context.BaseEntityContext;
import io.hops.transaction.lock.TransactionLocks;

public class MetadataLogContext
extends BaseEntityContext<Key, MetadataLogEntry> {
    private final MetadataLogDataAccess<MetadataLogEntry> dataAccess;

    public MetadataLogContext(MetadataLogDataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void add(MetadataLogEntry logEntry) throws TransactionContextException {
        Key key = this.getKey(logEntry);
        if (this.get(key) != null) {
            throw new RuntimeException("Conflicting logical time in the MetadataLogEntry");
        }
        super.add((Object)logEntry);
        this.log("metadata-log-added", new Object[]{"baseDirId", logEntry.getDatasetId(), "inodeId", logEntry.getInodeId(), "name", logEntry.getInodeName(), "pid", logEntry.getInodeParentId(), "Operation", logEntry.getOperation()});
    }

    Key getKey(MetadataLogEntry metadataLogEntry) {
        return new Key(metadataLogEntry.getDatasetId(), metadataLogEntry.getInodeId(), metadataLogEntry.getLogicalTime());
    }

    public void prepare(TransactionLocks tlm) throws TransactionContextException, StorageException {
        this.dataAccess.addAll(this.getAdded());
    }

    class Key {
        private long datasetId;
        private long inodeId;
        private long timestamp;

        public Key(long datasetId, long inodeId, long timestamp) {
            this.datasetId = datasetId;
            this.inodeId = inodeId;
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.datasetId != key.datasetId) {
                return false;
            }
            if (this.inodeId != key.inodeId) {
                return false;
            }
            return this.timestamp == key.timestamp;
        }

        public int hashCode() {
            int result = Long.hashCode(this.datasetId);
            result = 31 * result + Long.hashCode(this.inodeId);
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            return result;
        }
    }
}

