/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.RetryCacheEntry;
import io.hops.transaction.EntityManager;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.ipc.RetryCache;

public class RetryCacheEntryLock
extends Lock {
    private final List<byte[]> clientId = new ArrayList<byte[]>();
    private final List<Integer> callId = new ArrayList<Integer>();

    RetryCacheEntryLock(byte[] clientId, int callId) {
        this.clientId.add(clientId);
        this.callId.add(callId);
    }

    RetryCacheEntryLock(List<RetryCache.CacheEntry> entries) {
        for (RetryCache.CacheEntry entry : entries) {
            this.clientId.add(entry.getClientId());
            this.callId.add(entry.getCallId());
        }
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        RetryCacheEntryLock.setLockMode((TransactionLockTypes.LockType)TransactionLockTypes.LockType.WRITE);
        for (int i = 0; i < this.clientId.size(); ++i) {
            byte[] cid = this.clientId.get(i);
            int clid = this.callId.get(i);
            if (EntityManager.find((FinderType)RetryCacheEntry.Finder.ByClientIdAndCallId, (Object[])new Object[]{cid, clid}) != null) continue;
            EntityManager.update((Object)new RetryCacheEntry(cid, clid));
        }
    }

    protected Lock.Type getType() {
        return Lock.Type.retryCachEntry;
    }
}

