/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.NetworkTopologyWithNodeGroup;
import org.apache.hadoop.net.Node;

public class BlockPlacementPolicyWithNodeGroup
extends BlockPlacementPolicyDefault {
    protected BlockPlacementPolicyWithNodeGroup(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap, DatanodeManager datanodeManager) {
        this.initialize(conf, stats, clusterMap, this.host2datanodeMap);
    }

    protected BlockPlacementPolicyWithNodeGroup() {
    }

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap, Host2NodesMap host2datanodeMap) {
        super.initialize(conf, stats, clusterMap, host2datanodeMap);
    }

    @Override
    protected DatanodeStorageInfo chooseLocalStorage(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes, boolean fallbackToLocalRack) throws BlockPlacementPolicy.NotEnoughReplicasException {
        DatanodeStorageInfo chosenStorage;
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        if (localMachine instanceof DatanodeDescriptor) {
            DatanodeDescriptor localDataNode = (DatanodeDescriptor)localMachine;
            if (excludedNodes.add(localMachine)) {
                Iterator<Map.Entry<StorageType, Integer>> iter = storageTypes.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<StorageType, Integer> entry = iter.next();
                    for (DatanodeStorageInfo localStorage : DFSUtil.shuffle(localDataNode.getStorageInfos())) {
                        StorageType type = entry.getKey();
                        if (this.addIfIsGoodTarget(localStorage, excludedNodes, blocksize, maxNodesPerRack, false, results, avoidStaleNodes, type) < 0) continue;
                        int num = entry.getValue();
                        if (num == 1) {
                            iter.remove();
                        } else {
                            entry.setValue(num - 1);
                        }
                        return localStorage;
                    }
                }
            }
        }
        if ((chosenStorage = this.chooseLocalNodeGroup((NetworkTopologyWithNodeGroup)this.clusterMap, localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes)) != null) {
            return chosenStorage;
        }
        if (!fallbackToLocalRack) {
            return null;
        }
        return this.chooseLocalRack(localMachine, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
    }

    private static DatanodeDescriptor secondNode(Node localMachine, List<DatanodeStorageInfo> results) {
        for (DatanodeStorageInfo nextStorage : results) {
            DatanodeDescriptor nextNode = nextStorage.getDatanodeDescriptor();
            if (nextNode == localMachine) continue;
            return nextNode;
        }
        return null;
    }

    @Override
    protected DatanodeStorageInfo chooseLocalRack(Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        try {
            String scope = NetworkTopology.getFirstHalf((String)localMachine.getNetworkLocation());
            return this.chooseRandom(scope, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e1) {
            DatanodeDescriptor newLocal = BlockPlacementPolicyWithNodeGroup.secondNode(localMachine, results);
            if (newLocal != null) {
                try {
                    return this.chooseRandom(this.clusterMap.getRack(newLocal.getNetworkLocation()), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                }
                catch (BlockPlacementPolicy.NotEnoughReplicasException e2) {
                    return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                }
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    @Override
    protected void chooseRemoteRack(int numOfReplicas, DatanodeDescriptor localMachine, Set<Node> excludedNodes, long blocksize, int maxReplicasPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int oldNumOfReplicas = results.size();
        String rackLocation = NetworkTopology.getFirstHalf((String)localMachine.getNetworkLocation());
        try {
            this.chooseRandom(numOfReplicas, "~" + rackLocation, excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e) {
            this.chooseRandom(numOfReplicas - (results.size() - oldNumOfReplicas), rackLocation, excludedNodes, blocksize, maxReplicasPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    private DatanodeStorageInfo chooseLocalNodeGroup(NetworkTopologyWithNodeGroup clusterMap, Node localMachine, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (localMachine == null) {
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        try {
            return this.chooseRandom(clusterMap.getNodeGroup(localMachine.getNetworkLocation()), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
        catch (BlockPlacementPolicy.NotEnoughReplicasException e1) {
            DatanodeDescriptor newLocal = BlockPlacementPolicyWithNodeGroup.secondNode(localMachine, results);
            if (newLocal != null) {
                try {
                    return this.chooseRandom(clusterMap.getNodeGroup(newLocal.getNetworkLocation()), excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                }
                catch (BlockPlacementPolicy.NotEnoughReplicasException e2) {
                    return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
                }
            }
            return this.chooseRandom("", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        }
    }

    @Override
    protected String getRack(DatanodeInfo cur) {
        String nodeGroupString = cur.getNetworkLocation();
        return NetworkTopology.getFirstHalf((String)nodeGroupString);
    }

    @Override
    protected int addToExcludedNodes(DatanodeDescriptor chosenNode, Set<Node> excludedNodes) {
        int countOfExcludedNodes = 0;
        String nodeGroupScope = chosenNode.getNetworkLocation();
        List leafNodes = this.clusterMap.getLeaves(nodeGroupScope);
        for (Node leafNode : leafNodes) {
            if (!excludedNodes.add(leafNode)) continue;
            ++countOfExcludedNodes;
        }
        return countOfExcludedNodes += this.addDependentNodesToExcludedNodes(chosenNode, excludedNodes);
    }

    private int addDependentNodesToExcludedNodes(DatanodeDescriptor chosenNode, Set<Node> excludedNodes) {
        if (this.host2datanodeMap == null) {
            return 0;
        }
        int countOfExcludedNodes = 0;
        for (String hostname : chosenNode.getDependentHostNames()) {
            DatanodeDescriptor node = this.host2datanodeMap.getDataNodeByHostName(hostname);
            if (node != null) {
                if (!excludedNodes.add(node)) continue;
                ++countOfExcludedNodes;
                continue;
            }
            LOG.warn((Object)("Not able to find datanode " + hostname + " which has dependency with datanode " + chosenNode.getHostName()));
        }
        return countOfExcludedNodes;
    }

    @Override
    public Collection<DatanodeStorageInfo> pickupReplicaSet(Collection<DatanodeStorageInfo> first, Collection<DatanodeStorageInfo> second) {
        if (first.isEmpty()) {
            return second;
        }
        HashMap<String, ArrayList<DatanodeStorageInfo>> nodeGroupMap = new HashMap<String, ArrayList<DatanodeStorageInfo>>();
        for (DatanodeStorageInfo storage : first) {
            String nodeGroupName = NetworkTopology.getLastHalf((String)storage.getDatanodeDescriptor().getNetworkLocation());
            ArrayList<DatanodeStorageInfo> storageList = (ArrayList<DatanodeStorageInfo>)nodeGroupMap.get(nodeGroupName);
            if (storageList == null) {
                storageList = new ArrayList<DatanodeStorageInfo>();
                nodeGroupMap.put(nodeGroupName, storageList);
            }
            storageList.add(storage);
        }
        ArrayList moreThanOne = new ArrayList();
        ArrayList<DatanodeStorageInfo> exactlyOne = new ArrayList<DatanodeStorageInfo>();
        for (List datanodeList : nodeGroupMap.values()) {
            if (datanodeList.size() == 1) {
                exactlyOne.add((DatanodeStorageInfo)datanodeList.get(0));
                continue;
            }
            moreThanOne.addAll(datanodeList);
        }
        return moreThanOne.isEmpty() ? exactlyOne : moreThanOne;
    }
}

