/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.annotations.VisibleForTesting;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.HashBucketDataAccess;
import io.hops.metadata.hdfs.entity.HashBucket;
import io.hops.transaction.EntityManager;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.protocol.BlockReport;

public class HashBuckets {
    static final Log LOG = LogFactory.getLog(HashBuckets.class);
    private static HashBuckets instance;
    private static int numBuckets;

    public static void initialize(int numBuckets) {
        if (instance != null) {
            LOG.warn((Object)"initialize called again after already initialized.");
        } else {
            instance = new HashBuckets(numBuckets);
        }
    }

    private HashBuckets(int numBuckets) {
        HashBuckets.numBuckets = numBuckets;
    }

    public static HashBuckets getInstance() {
        if (instance != null) {
            return instance;
        }
        throw new RuntimeException("HashBuckets have not been initialized");
    }

    public int getBucketForBlock(Block block) {
        return (int)(block.getBlockId() % (long)numBuckets);
    }

    public List<HashBucket> getBucketsForStorage(final DatanodeStorageInfo storage) throws IOException {
        LightWeightRequestHandler findHashesHandler = new LightWeightRequestHandler(HDFSOperationType.GET_STORAGE_HASHES){

            public Object performTask() throws IOException {
                HashBucketDataAccess da = (HashBucketDataAccess)HdfsStorageFactory.getDataAccess(HashBucketDataAccess.class);
                return da.findBucketsByStorageId(storage.getSid());
            }
        };
        return (List)findHashesHandler.handle();
    }

    @VisibleForTesting
    public void corruptHashBuckets(final DatanodeStorageInfo storage) throws IOException {
        Random rand = new Random(System.currentTimeMillis());
        LightWeightRequestHandler corruptedHashes = new LightWeightRequestHandler(HDFSOperationType.RESET_STORAGE_HASHES){

            public Object performTask() throws IOException {
                ArrayList<HashBucket> newBuckets = new ArrayList<HashBucket>();
                for (int i = 0; i < numBuckets; ++i) {
                    newBuckets.add(new HashBucket(storage.getSid(), i, rand.nextLong()));
                }
                HashBucketDataAccess da = (HashBucketDataAccess)HdfsStorageFactory.getDataAccess(HashBucketDataAccess.class);
                da.prepare((Collection)Collections.EMPTY_LIST, newBuckets);
                return null;
            }
        };
        corruptedHashes.handle();
    }

    @VisibleForTesting
    public void deleteHashBuckets(final DatanodeStorageInfo storage) throws IOException {
        LightWeightRequestHandler deleteHashes = new LightWeightRequestHandler(HDFSOperationType.RESET_STORAGE_HASHES){

            public Object performTask() throws IOException {
                ArrayList<HashBucket> deleted = new ArrayList<HashBucket>();
                for (int i = 0; i < numBuckets; ++i) {
                    deleted.add(new HashBucket(storage.getSid(), i, 0L));
                }
                HashBucketDataAccess da = (HashBucketDataAccess)HdfsStorageFactory.getDataAccess(HashBucketDataAccess.class);
                da.prepare(deleted, (Collection)Collections.EMPTY_LIST);
                return null;
            }
        };
        deleteHashes.handle();
    }

    public void createBucketsForStorage(final DatanodeStorageInfo storage) throws IOException {
        List<HashBucket> existing = this.getBucketsForStorage(storage);
        final HashMap<Integer, HashBucket> existingMap = new HashMap<Integer, HashBucket>();
        for (HashBucket bucket : existing) {
            existingMap.put(bucket.getBucketId(), bucket);
        }
        final ArrayList<HashBucket> newBuckets = new ArrayList<HashBucket>();
        for (int i = 0; i < numBuckets; ++i) {
            if (existingMap.containsKey(i)) continue;
            newBuckets.add(new HashBucket(storage.getSid(), i, 0L));
        }
        LightWeightRequestHandler findHashesHandler = new LightWeightRequestHandler(HDFSOperationType.CREATE_ALL_STORAGE_HASHES){

            public Object performTask() throws IOException {
                HashBucketDataAccess da = (HashBucketDataAccess)HdfsStorageFactory.getDataAccess(HashBucketDataAccess.class);
                da.prepare((Collection)Collections.EMPTY_LIST, (Collection)newBuckets);
                LOG.debug((Object)("Created " + newBuckets.size() + " buckets for the storage " + storage + " Existing Buckets: " + existingMap.size()));
                return null;
            }
        };
        findHashesHandler.handle();
    }

    HashBucket getBucket(int storageId, int bucketId) throws TransactionContextException, StorageException {
        HashBucket result = (HashBucket)EntityManager.find((FinderType)HashBucket.Finder.ByStorageIdAndBucketId, (Object[])new Object[]{storageId, bucketId});
        if (result == null) {
            result = new HashBucket(storageId, bucketId, 0L);
        }
        return result;
    }

    Collection<HashBucket> getBuckets(int storageId) throws TransactionContextException, StorageException {
        Collection result = EntityManager.findList((FinderType)HashBucket.Finder.ByStorageId, (Object[])new Object[]{storageId});
        return result;
    }

    private static String blockToString(Block block) {
        return "(id: " + block.getBlockId() + ",#bytes: " + block.getNumBytes() + ",GS: " + block.getGenerationStamp() + ")";
    }

    public void applyHash(int storageId, HdfsServerConstants.ReplicaState state, Block block) throws TransactionContextException, StorageException {
        int bucketId = this.getBucketForBlock(block);
        HashBucket bucket = this.getBucket(storageId, bucketId);
        long curVal = bucket.getHash();
        long newHash = curVal + BlockReport.hash(block, state);
        LOG.debug((Object)("Applying block:" + HashBuckets.blockToString(block) + "sid=" + storageId + " state=" + state.name() + ", hash (" + curVal + " + " + BlockReport.hash(block, state) + " = " + newHash + ")"));
        bucket.setHash(newHash);
    }

    public void undoHash(int storageId, HdfsServerConstants.ReplicaState state, Block block) throws TransactionContextException, StorageException {
        int bucketId = this.getBucketForBlock(block);
        HashBucket bucket = this.getBucket(storageId, bucketId);
        long currVal = bucket.getHash();
        long newHash = currVal - BlockReport.hash(block, state);
        LOG.debug((Object)("Undo block:" + HashBuckets.blockToString(block) + " sid=" + storageId + " state=" + state.name() + ", hash (" + currVal + " - " + BlockReport.hash(block, state) + " = " + newHash + ")"));
        bucket.setHash(newHash);
    }

    public void resetBuckets(final int storageId) throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.RESET_STORAGE_HASHES){

            public void acquireLock(TransactionLocks tl) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                tl.add(lf.getHashBucketLock(storageId));
            }

            public Object performTask() throws IOException {
                Collection<HashBucket> buckets = HashBuckets.this.getBuckets(storageId);
                for (HashBucket bucket : buckets) {
                    bucket.setHash(0L);
                }
                return null;
            }
        }.handle();
    }
}

