/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclTransformation;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.ScopedAclEntries;

@InterfaceAudience.Private
final class AclStorage {
    public static void copyINodeDefaultAcl(INode child) throws TransactionContextException, StorageException, AclException {
        FsPermission newPerm;
        List<Object> defaultEntries;
        INodeDirectory parent = child.getParent();
        AclFeature parentAclFeature = parent.getAclFeature();
        if (parentAclFeature == null || !child.isFile() && !child.isDirectory()) {
            return;
        }
        List<AclEntry> featureEntries = parent.getAclFeature().getEntries();
        ScopedAclEntries scopedEntries = new ScopedAclEntries(featureEntries);
        List<AclEntry> parentDefaultEntries = scopedEntries.getDefaultEntries();
        if (parentDefaultEntries.isEmpty()) {
            return;
        }
        ArrayList accessEntries = Lists.newArrayListWithCapacity((int)parentDefaultEntries.size());
        FsPermission childPerm = child.getFsPermission();
        boolean parentDefaultIsMinimal = AclStorage.isMinimalAcl(parentDefaultEntries);
        for (AclEntry entry : parentDefaultEntries) {
            AclEntryType type = entry.getType();
            String name = entry.getName();
            AclEntry.Builder builder = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(type).setName(name);
            FsAction permission = type == AclEntryType.USER && name == null ? entry.getPermission().and(childPerm.getUserAction()) : (type == AclEntryType.GROUP && parentDefaultIsMinimal ? entry.getPermission().and(childPerm.getGroupAction()) : (type == AclEntryType.MASK ? entry.getPermission().and(childPerm.getGroupAction()) : (type == AclEntryType.OTHER ? entry.getPermission().and(childPerm.getOtherAction()) : entry.getPermission())));
            builder.setPermission(permission);
            accessEntries.add(builder.build());
        }
        List<Object> list = defaultEntries = child.isDirectory() ? parentDefaultEntries : Collections.emptyList();
        if (!AclStorage.isMinimalAcl(accessEntries) || !defaultEntries.isEmpty()) {
            child.addAclFeature(AclStorage.createAclFeature(accessEntries, defaultEntries));
            newPerm = AclStorage.createFsPermissionForExtendedAcl(accessEntries, childPerm);
        } else {
            newPerm = AclStorage.createFsPermissionForMinimalAcl(accessEntries, childPerm);
        }
        child.setPermission(newPerm);
    }

    public static List<AclEntry> readINodeAcl(INode inode) throws TransactionContextException, StorageException, AclException {
        AclFeature f = inode.getAclFeature();
        return f == null ? ImmutableList.of() : f.getEntries();
    }

    public static boolean hasOwnAcl(INode inode) {
        return inode.getNumAces() > 0;
    }

    public static List<AclEntry> readINodeLogicalAcl(INode inode) throws TransactionContextException, StorageException, AclException {
        FsPermission perm = inode.getFsPermission();
        AclFeature f = inode.getAclFeature();
        if (f == null) {
            return AclStorage.getMinimalAcl(perm);
        }
        List<AclEntry> featureEntries = f.getEntries();
        ScopedAclEntries scoped = new ScopedAclEntries(featureEntries);
        List<AclEntry> accessEntries = scoped.getAccessEntries();
        List<AclEntry> defaultEntries = scoped.getDefaultEntries();
        ArrayList existingAcl = Lists.newArrayListWithCapacity((int)(featureEntries.size() + 3));
        if (!accessEntries.isEmpty()) {
            existingAcl.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setPermission(perm.getUserAction()).build());
            existingAcl.addAll(accessEntries);
            existingAcl.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.MASK).setPermission(perm.getGroupAction()).build());
            existingAcl.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.OTHER).setPermission(perm.getOtherAction()).build());
        } else {
            existingAcl.addAll(AclStorage.getMinimalAcl(perm));
        }
        existingAcl.addAll(defaultEntries);
        return existingAcl;
    }

    public static void removeINodeAcl(INode inode) throws QuotaExceededException, TransactionContextException, StorageException, AclException {
        if (inode.getNumAces() <= 0) {
            return;
        }
        AclFeature f = inode.getAclFeature();
        FsPermission perm = inode.getFsPermission();
        List<AclEntry> featureEntries = f.getEntries();
        if (featureEntries.get(0).getScope() == AclEntryScope.ACCESS) {
            AclEntry groupEntryKey = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).build();
            int groupEntryIndex = Collections.binarySearch(featureEntries, groupEntryKey, AclTransformation.ACL_ENTRY_COMPARATOR);
            assert (groupEntryIndex >= 0);
            FsAction groupPerm = featureEntries.get(groupEntryIndex).getPermission();
            FsPermission newPerm = new FsPermission(perm.getUserAction(), groupPerm, perm.getOtherAction(), perm.getStickyBit());
            inode.setPermission(newPerm);
        }
        inode.removeAclFeature();
    }

    public static void updateINodeAcl(INode inode, List<AclEntry> newAcl) throws AclException, QuotaExceededException, TransactionContextException, StorageException {
        FsPermission newPerm;
        assert (newAcl.size() >= 3);
        FsPermission perm = inode.getFsPermission();
        if (!AclStorage.isMinimalAcl(newAcl)) {
            ScopedAclEntries scoped = new ScopedAclEntries(newAcl);
            List<AclEntry> accessEntries = scoped.getAccessEntries();
            List<AclEntry> defaultEntries = scoped.getDefaultEntries();
            if (!defaultEntries.isEmpty() && !inode.isDirectory()) {
                throw new AclException("Invalid ACL: only directories may have a default ACL.");
            }
            if (inode.getNumAces() > 0) {
                inode.removeAclFeature();
            }
            inode.addAclFeature(AclStorage.createAclFeature(accessEntries, defaultEntries));
            newPerm = AclStorage.createFsPermissionForExtendedAcl(accessEntries, perm);
        } else {
            if (AclStorage.hasOwnAcl(inode)) {
                inode.removeAclFeature();
            }
            newPerm = AclStorage.createFsPermissionForMinimalAcl(newAcl, perm);
        }
        inode.setPermission(newPerm);
    }

    private AclStorage() {
    }

    private static AclFeature createAclFeature(List<AclEntry> accessEntries, List<AclEntry> defaultEntries) {
        ArrayList featureEntries = Lists.newArrayListWithCapacity((int)(accessEntries.size() - 3 + defaultEntries.size()));
        if (!AclStorage.isMinimalAcl(accessEntries)) {
            featureEntries.addAll(accessEntries.subList(1, accessEntries.size() - 2));
        }
        featureEntries.addAll(defaultEntries);
        return new AclFeature(Collections.unmodifiableList(featureEntries));
    }

    private static FsPermission createFsPermissionForExtendedAcl(List<AclEntry> accessEntries, FsPermission existingPerm) {
        return new FsPermission(accessEntries.get(0).getPermission(), accessEntries.get(accessEntries.size() - 2).getPermission(), accessEntries.get(accessEntries.size() - 1).getPermission(), existingPerm.getStickyBit());
    }

    private static FsPermission createFsPermissionForMinimalAcl(List<AclEntry> accessEntries, FsPermission existingPerm) {
        return new FsPermission(accessEntries.get(0).getPermission(), accessEntries.get(1).getPermission(), accessEntries.get(2).getPermission(), existingPerm.getStickyBit());
    }

    public static List<AclEntry> getMinimalAcl(INode inode) {
        return AclStorage.getMinimalAcl(inode.getFsPermission());
    }

    private static List<AclEntry> getMinimalAcl(FsPermission perm) {
        return Lists.newArrayList((Object[])new AclEntry[]{new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setPermission(perm.getUserAction()).build(), new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).setPermission(perm.getGroupAction()).build(), new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.OTHER).setPermission(perm.getOtherAction()).build()});
    }

    private static boolean isMinimalAcl(List<AclEntry> entries) {
        return entries.size() == 3;
    }

    public static void validateAclSpec(List<AclEntry> aclSpec) throws AclException {
        for (AclEntry aclEntry : aclSpec) {
            if (!aclEntry.getScope().equals((Object)AclEntryScope.DEFAULT) || aclEntry.getName() != null && !aclEntry.getName().isEmpty()) continue;
            switch (aclEntry.getType()) {
                case USER: 
                case OTHER: 
                case MASK: {
                    throw new AclException("HOPS: No default USER (unnamed), OTHER or MASK entries allowed");
                }
            }
        }
    }
}

