/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.hops.common.IDsGeneratorFactory;
import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.dal.INodeAttributesDataAccess;
import io.hops.metadata.hdfs.dal.INodeDataAccess;
import io.hops.metadata.hdfs.entity.INodeCandidatePrimaryKey;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.metadata.hdfs.entity.MetadataLogEntry;
import io.hops.metadata.hdfs.entity.QuotaUpdate;
import io.hops.resolvingcache.Cache;
import io.hops.security.UsersGroups;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.HdfsTransactionContextMaintenanceCmds;
import io.hops.transaction.context.TransactionContextMaintenanceCmds;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSLimitException;
import org.apache.hadoop.hdfs.protocol.FsAclPermission;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTransformation;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.server.namenode.ContentSummaryComputationContext;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameCache;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.util.ByteArray;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Time;

public class FSDirectory
implements Closeable {
    @VisibleForTesting
    static boolean CHECK_RESERVED_FILE_NAMES = true;
    public static final String DOT_RESERVED_STRING = ".reserved";
    public static final String DOT_RESERVED_PATH_PREFIX = "/.reserved";
    public static final byte[] DOT_RESERVED = DFSUtil.string2Bytes(".reserved");
    public static final String DOT_INODES_STRING = ".inodes";
    public static final byte[] DOT_INODES = DFSUtil.string2Bytes(".inodes");
    private final FSNamesystem namesystem;
    private final int maxComponentLength;
    private final int maxDirItems;
    private final int lsLimit;
    private final int contentCountLimit;
    private long yieldCount = 0L;
    private boolean quotaEnabled;
    private final NameCache<ByteArray> nameCache;

    FSDirectory(FSNamesystem ns, Configuration conf) throws IOException {
        this.quotaEnabled = conf.getBoolean("dfs.namenode.quota.enabled", true);
        this.namesystem = ns;
        this.createRoot(ns.createFsOwnerPermissions(new FsPermission(493)), false);
        int configuredLimit = conf.getInt("dfs.ls.limit", Integer.MAX_VALUE);
        this.lsLimit = configuredLimit > 0 ? configuredLimit : Integer.MAX_VALUE;
        this.contentCountLimit = conf.getInt("dfs.content-summary.limit", 0);
        this.maxComponentLength = conf.getInt("dfs.namenode.fs-limits.max-component-length", 255);
        this.maxDirItems = conf.getInt("dfs.namenode.fs-limits.max-directory-items", 0);
        Preconditions.checkArgument((this.maxDirItems >= 0 ? 1 : 0) != 0, (Object)"Cannot set dfs.namenode.fs-limits.max-directory-items to a value less than 0");
        int threshold = conf.getInt("dfs.namenode.name.cache.threshold", 10);
        NameNode.LOG.info((Object)("Caching file names occuring more than " + threshold + " times"));
        this.nameCache = new NameCache(threshold);
    }

    private FSNamesystem getFSNamesystem() {
        return this.namesystem;
    }

    private BlockManager getBlockManager() {
        return this.getFSNamesystem().getBlockManager();
    }

    @Override
    public void close() throws IOException {
    }

    void markNameCacheInitialized() {
        this.nameCache.initialized();
    }

    INodeFile addFile(String path, PermissionStatus permissions, short replication, long preferredBlockSize, String clientName, String clientMachine) throws IOException {
        long modTime = Time.now();
        INodeFile newNode = new INodeFile(IDsGeneratorFactory.getInstance().getUniqueINodeID(), permissions, BlockInfo.EMPTY_ARRAY, replication, modTime, modTime, preferredBlockSize, 0);
        newNode.toUnderConstruction(clientName, clientMachine);
        boolean added = false;
        added = this.addINode(path, newNode);
        if (!added) {
            NameNode.stateChangeLog.info((Object)("DIR* addFile: failed to add " + path));
            return null;
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* addFile: " + path + " is added"));
        }
        return newNode;
    }

    BlockInfo addBlock(String path, INodesInPath inodesInPath, Block block, DatanodeStorageInfo[] targets) throws QuotaExceededException, StorageException, TransactionContextException, IOException {
        INode[] inodes = inodesInPath.getINodes();
        INodeFile fileINode = inodes[inodes.length - 1].asFile();
        Preconditions.checkState((boolean)fileINode.isUnderConstruction());
        long diskspaceTobeConsumed = fileINode.getBlockDiskspace();
        if (fileINode.isFileStoredInDB()) {
            diskspaceTobeConsumed -= fileINode.getSize() * (long)fileINode.getBlockReplication();
        }
        this.updateCount(inodesInPath, inodes.length - 1, 0L, diskspaceTobeConsumed, true);
        BlockInfoUnderConstruction blockInfo = new BlockInfoUnderConstruction(block, fileINode.getId(), HdfsServerConstants.BlockUCState.UNDER_CONSTRUCTION, targets);
        this.getBlockManager().addBlockCollection(blockInfo, fileINode);
        fileINode.addBlock(blockInfo);
        fileINode.setHasBlocks(true);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.addBlock: " + path + " with " + block + " block is added to the in-memory file system"));
        }
        return blockInfo;
    }

    boolean removeBlock(String path, INodeFile fileNode, Block block) throws IOException, StorageException {
        Preconditions.checkArgument((boolean)fileNode.isUnderConstruction());
        return this.unprotectedRemoveBlock(path, fileNode, block);
    }

    boolean unprotectedRemoveBlock(String path, INodeFile fileNode, Block block) throws IOException, StorageException {
        Preconditions.checkArgument((boolean)fileNode.isUnderConstruction());
        boolean removed = fileNode.removeLastBlock(block);
        if (!removed) {
            return false;
        }
        this.getBlockManager().removeBlockFromMap(block);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.removeReplica: " + path + " with " + block + " block is removed from the file system"));
        }
        INodesInPath inodesInPath = this.getINodesInPath4Write(path, true);
        INode[] inodes = inodesInPath.getINodes();
        this.updateCount(inodesInPath, inodes.length - 1, 0L, -fileNode.getPreferredBlockSize() * (long)fileNode.getBlockReplication(), true);
        return true;
    }

    @Deprecated
    boolean renameTo(String src, String dst, long mtime, INode.DirCounts srcCounts, INode.DirCounts dstCounts) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.renameTo: " + src + " to " + dst));
        }
        return this.unprotectedRenameTo(src, dst, mtime, srcCounts, dstCounts);
    }

    void renameTo(String src, String dst, long mtime, INode.DirCounts srcCounts, INode.DirCounts dstCounts, Options.Rename ... options) throws FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, QuotaExceededException, UnresolvedLinkException, IOException, StorageException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.renameTo: " + src + " to " + dst));
        }
        if (this.unprotectedRenameTo(src, dst, mtime, srcCounts, dstCounts, options)) {
            this.namesystem.incrDeletedFileCount(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unprotectedRenameTo(String src, String dst, long timestamp, INode.DirCounts srcCounts, INode.DirCounts dstCounts, Options.Rename ... options) throws FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, QuotaExceededException, UnresolvedLinkException, IOException, StorageException {
        boolean restoreDst;
        boolean restoreSrc;
        INode removedDst;
        String dstChildName;
        RenameOperation tx;
        INodesInPath dstInodesInPath;
        block21: {
            boolean bl;
            block22: {
                boolean overwrite = options != null && Arrays.asList(options).contains(Options.Rename.OVERWRITE);
                String error = null;
                INodesInPath srcInodesInPath = this.getINodesInPath4Write(src, false);
                INode[] srcInodes = srcInodesInPath.getINodes();
                INode srcInode = srcInodes[srcInodes.length - 1];
                FSDirectory.validateRenameSource(src, srcInodes);
                if (dst.equals(src)) {
                    throw new FileAlreadyExistsException("The source " + src + " and destination " + dst + " are the same");
                }
                FSDirectory.validateRenameDestination(src, dst, srcInode);
                byte[][] dstComponents = INode.getPathComponents(dst);
                dstInodesInPath = this.getExistingPathINodes(dstComponents);
                INode[] dstInodes = dstInodesInPath.getINodes();
                INode dstInode = dstInodes[dstInodes.length - 1];
                if (dstInodes.length == 1) {
                    error = "rename destination cannot be the root";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new IOException(error);
                }
                if (dstInode != null) {
                    FSDirectory.validateRenameOverwrite(src, dst, overwrite, srcInode, dstInode);
                }
                if (dstInodes[dstInodes.length - 2] == null) {
                    error = "rename destination parent " + dst + " not found.";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new FileNotFoundException(error);
                }
                if (!dstInodes[dstInodes.length - 2].isDirectory()) {
                    error = "rename destination parent " + dst + " is a file.";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new ParentNotDirectoryException(error);
                }
                this.verifyFsLimitsForRename(srcInodesInPath, dstInodesInPath, dstComponents[dstComponents.length - 1]);
                this.verifyQuotaForRename(srcInodes, dstInodes, srcCounts, dstCounts);
                tx = new RenameOperation(src, dst, srcInodesInPath, dstInodesInPath, srcCounts);
                INode removedSrc = this.removeLastINodeForRename(srcInodesInPath, srcCounts);
                if (removedSrc == null) {
                    error = "Failed to rename " + src + " to " + dst + " because the source can not be removed";
                    NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                    throw new IOException(error);
                }
                INode srcClone = removedSrc.cloneInode();
                String srcChildName = removedSrc.getLocalName();
                dstChildName = null;
                removedDst = null;
                restoreSrc = true;
                restoreDst = false;
                try {
                    if (dstInode != null) {
                        removedDst = this.removeLastINode(dstInodesInPath, dstCounts);
                        dstChildName = removedDst.getLocalName();
                        restoreDst = true;
                    }
                    if (!tx.addSourceToDestination()) break block21;
                    restoreSrc = false;
                    if (NameNode.stateChangeLog.isDebugEnabled()) {
                        NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst));
                    }
                    tx.updateMtimeAndLease(timestamp);
                    boolean filesDeleted = false;
                    if (removedDst != null) {
                        INode rmdst = removedDst;
                        restoreDst = false;
                        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
                        filesDeleted = true;
                        if (rmdst instanceof INodeFile && !((INodeFile)rmdst).isFileStoredInDB()) {
                            BlockInfo[] blocks;
                            for (BlockInfo blk : blocks = ((INodeFile)rmdst).getBlocks()) {
                                collectedBlocks.addDeleteBlock(blk);
                            }
                        } else if (rmdst instanceof INodeFile && ((INodeFile)rmdst).isFileStoredInDB()) {
                            ((INodeFile)rmdst).deleteFileDataStoredInDB();
                        }
                        this.getFSNamesystem().removePathAndBlocks(src, collectedBlocks);
                    }
                    if (!restoreSrc && !restoreDst) {
                        this.logMetadataEventForRename(srcClone, removedSrc);
                    }
                    EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.INodePKChanged, (Object[])new Object[]{srcClone, removedSrc});
                    tx.updateQuotasInSourceTree();
                    bl = filesDeleted;
                    if (!restoreSrc) break block22;
                }
                catch (Throwable throwable) {
                    if (restoreSrc) {
                        tx.restoreSource();
                    }
                    if (restoreDst) {
                        removedDst.setLocalNameNoPersistance(dstChildName);
                        this.addLastINodeNoQuotaCheck(dstInodesInPath, removedDst, dstCounts);
                    }
                    throw throwable;
                }
                tx.restoreSource();
            }
            if (restoreDst) {
                removedDst.setLocalNameNoPersistance(dstChildName);
                this.addLastINodeNoQuotaCheck(dstInodesInPath, removedDst, dstCounts);
            }
            return bl;
        }
        if (restoreSrc) {
            tx.restoreSource();
        }
        if (restoreDst) {
            removedDst.setLocalNameNoPersistance(dstChildName);
            this.addLastINodeNoQuotaCheck(dstInodesInPath, removedDst, dstCounts);
        }
        NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst));
        throw new IOException("rename from " + src + " to " + dst + " failed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    boolean unprotectedRenameTo(String src, String dst, long timestamp, INode.DirCounts srcCounts, INode.DirCounts dstCounts) throws IOException {
        INodesInPath srcInodesInPath = this.getINodesInPath4Write(src, false);
        INode[] srcInodes = srcInodesInPath.getINodes();
        INode srcInode = srcInodes[srcInodes.length - 1];
        try {
            FSDirectory.validateRenameSource(src, srcInodes);
        }
        catch (IOException ignored) {
            return false;
        }
        if (this.isDir(dst)) {
            dst = dst + "/" + new Path(src).getName();
        }
        if (dst.equals(src)) {
            return true;
        }
        try {
            FSDirectory.validateRenameDestination(src, dst, srcInode);
        }
        catch (IOException ignored) {
            return false;
        }
        byte[][] dstComponents = INode.getPathComponents(dst);
        FSNamesystem.LOG.debug((Object)("destination is " + dst));
        INodesInPath dstInodesInPath = this.getExistingPathINodes(dstComponents);
        INode[] dstInodes = dstInodesInPath.getINodes();
        if (dstInodes[dstInodes.length - 1] != null) {
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination exists"));
            return false;
        }
        if (dstInodes[dstInodes.length - 2] == null) {
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because destination's parent does not exist"));
            return false;
        }
        this.verifyFsLimitsForRename(srcInodesInPath, dstInodesInPath, dstComponents[dstComponents.length - 1]);
        this.verifyQuotaForRename(srcInodes, dstInodes, srcCounts, dstCounts);
        RenameOperation tx = new RenameOperation(src, dst, srcInodesInPath, dstInodesInPath, srcCounts);
        boolean added = false;
        INode srcChild = null;
        String srcChildName = null;
        try {
            srcChild = this.removeLastINodeForRename(srcInodesInPath, srcCounts);
            if (srcChild == null) {
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst + " because the source can not be removed"));
                boolean bl = false;
                return bl;
            }
            INode srcClone = srcChild.cloneInode();
            srcChildName = srcChild.getLocalName();
            srcChild.setLocalNameNoPersistance(dstComponents[dstInodes.length - 1]);
            added = tx.addSourceToDestination();
            if (added) {
                if (NameNode.stateChangeLog.isDebugEnabled()) {
                    NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedRenameTo: " + src + " is renamed to " + dst));
                }
                tx.updateMtimeAndLease(timestamp);
                tx.updateQuotasInSourceTree();
                this.logMetadataEventForRename(srcClone, srcChild);
                EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.INodePKChanged, (Object[])new Object[]{srcClone, srcChild});
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (!added && srcChild != null) {
                tx.restoreSource();
            }
        }
        NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: failed to rename " + src + " to " + dst));
        return false;
    }

    private void logMetadataEventForRename(INode srcClone, INode srcChild) throws TransactionContextException, StorageException {
        INodeDirectory srcDataset = srcClone.getMetaEnabledParent();
        INodeDirectory dstDataset = srcChild.getMetaEnabledParent();
        if (srcDataset == null) {
            if (dstDataset != null) {
                srcChild.logMetadataEvent(MetadataLogEntry.Operation.ADD);
            }
        } else if (dstDataset == null) {
            EntityManager.add((Object)new MetadataLogEntry(((INode)srcDataset).getId(), srcClone.getId(), srcClone.getPartitionId().longValue(), srcClone.getParentId(), srcClone.getLocalName(), srcChild.incrementLogicalTime(), MetadataLogEntry.Operation.DELETE));
        } else {
            srcChild.logMetadataEvent(MetadataLogEntry.Operation.RENAME);
        }
    }

    private static void validateRenameOverwrite(String src, String dst, boolean overwrite, INode srcInode, INode dstInode) throws IOException {
        if (dstInode.isDirectory() != srcInode.isDirectory()) {
            String error = "Source " + src + " and destination " + dst + " must both be directories";
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
            throw new IOException(error);
        }
        if (!overwrite) {
            String error = "rename destination " + dst + " already exists";
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
            throw new FileAlreadyExistsException(error);
        }
        if (dstInode.isDirectory()) {
            INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
            Short depth = dstInode.myDepth();
            boolean areChildrenRandomlyPartitioned = INode.isTreeLevelRandomPartitioned((short)(depth + 1));
            if (ida.hasChildren(dstInode.getId(), areChildrenRandomlyPartitioned)) {
                String error = "rename destination directory is not empty: " + dst;
                NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
                throw new IOException(error);
            }
        }
    }

    private static void validateRenameDestination(String src, String dst, INode srcInode) throws IOException {
        if (srcInode.isSymlink() && dst.equals(srcInode.asSymlink().getSymlinkString())) {
            throw new FileAlreadyExistsException("Cannot rename symlink " + src + " to its target " + dst);
        }
        if (dst.startsWith(src) && dst.charAt(src.length()) == '/') {
            String error = "Rename destination " + dst + " is a directory or file under source " + src;
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
            throw new IOException(error);
        }
    }

    private static void validateRenameSource(String src, INode[] srcInodes) throws IOException {
        INode srcInode = srcInodes[srcInodes.length - 1];
        if (srcInode == null) {
            String error = "rename source " + src + " is not found.";
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
            throw new FileNotFoundException(error);
        }
        if (srcInodes.length == 1) {
            String error = "rename source cannot be the root";
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedRenameTo: " + error));
            throw new IOException(error);
        }
    }

    Block[] setReplication(String src, short replication, short[] oldReplication) throws QuotaExceededException, UnresolvedLinkException, StorageException, TransactionContextException {
        return this.unprotectedSetReplication(src, replication, oldReplication);
    }

    Block[] unprotectedSetReplication(String src, short replication, short[] oldReplication) throws QuotaExceededException, UnresolvedLinkException, StorageException, TransactionContextException {
        INodesInPath inodesInPath = this.getINodesInPath4Write(src, true);
        INode[] inodes = inodesInPath.getINodes();
        INode inode = inodes[inodes.length - 1];
        if (inode == null || !inode.isFile()) {
            return null;
        }
        INodeFile fileNode = (INodeFile)inode;
        short oldRepl = fileNode.getBlockReplication();
        long dsDelta = (long)(replication - oldRepl) * (fileNode.diskspaceConsumed() / (long)oldRepl);
        this.updateCount(inodesInPath, inodes.length - 1, 0L, dsDelta, true);
        fileNode.setReplication(replication);
        if (oldReplication != null) {
            oldReplication[0] = oldRepl;
        }
        return fileNode.getBlocks();
    }

    void setStoragePolicy(String src, BlockStoragePolicy policy) throws IOException {
        this.unprotectedSetStoragePolicy(src, policy);
    }

    void unprotectedSetStoragePolicy(String src, BlockStoragePolicy policy) throws IOException {
        INodesInPath inodesInPath = this.getINodesInPath4Write(src, true);
        INode[] inodes = inodesInPath.getINodes();
        INode inode = inodes[inodes.length - 1];
        if (inode == null) {
            throw new FileNotFoundException("File/Directory does not exist: " + src);
        }
        if (inode.isSymlink()) {
            throw new IOException("Cannot set storage policy for symlink: " + src);
        }
        inode.setBlockStoragePolicyID(policy.getId());
    }

    long getPreferredBlockSize(String path) throws UnresolvedLinkException, FileNotFoundException, IOException, StorageException {
        return INodeFile.valueOf(this.getNode(path, false), path).getPreferredBlockSize();
    }

    void setPermission(String src, FsPermission permission) throws FileNotFoundException, UnresolvedLinkException, StorageException, TransactionContextException {
        this.unprotectedSetPermission(src, permission);
    }

    void unprotectedSetPermission(String src, FsPermission permissions) throws FileNotFoundException, UnresolvedLinkException, StorageException, TransactionContextException {
        INode inode = this.getNode(src, true);
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        inode.setPermission(permissions);
    }

    void setOwner(String src, String username, String groupname) throws IOException {
        this.unprotectedSetOwner(src, username, groupname);
    }

    void unprotectedSetOwner(String src, String username, String groupname) throws IOException {
        INode inode = this.getNode(src, true);
        if (inode == null) {
            throw new FileNotFoundException("File does not exist: " + src);
        }
        if (username != null) {
            UsersGroups.addUser((String)username);
            inode.setUser(username);
        }
        if (groupname != null) {
            UsersGroups.addGroup((String)groupname);
            inode.setGroup(groupname);
        }
        inode.logMetadataEvent(MetadataLogEntry.Operation.UPDATE);
    }

    public void concat(String target, String[] srcs, long timestamp) throws UnresolvedLinkException, StorageException, TransactionContextException {
        this.unprotectedConcat(target, srcs, timestamp);
    }

    /*
     * WARNING - void declaration
     */
    public void unprotectedConcat(String target, String[] srcs, long timestamp) throws UnresolvedLinkException, StorageException, TransactionContextException {
        void var17_20;
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSNamesystem.concat to " + target));
        }
        INodesInPath trgINodesInPath = this.getINodesInPath4Write(target);
        INode[] trgINodes = trgINodesInPath.getINodes();
        INodeFile trgInode = (INodeFile)trgINodes[trgINodes.length - 1];
        INodeDirectory trgParent = (INodeDirectory)trgINodes[trgINodes.length - 2];
        INodeFile[] allSrcInodes = new INodeFile[srcs.length];
        int i = 0;
        int totalBlocks = 0;
        long concatSize = 0L;
        for (String string : srcs) {
            INodeFile srcInode = (INodeFile)this.getINode(string);
            allSrcInodes[i++] = srcInode;
            totalBlocks += srcInode.numBlocks();
            concatSize += srcInode.getSize();
        }
        List<BlockInfo> oldBlks = trgInode.appendBlocks(allSrcInodes, totalBlocks);
        trgInode.recomputeFileSize();
        INodeCandidatePrimaryKey trg_param = new INodeCandidatePrimaryKey(trgInode.getId());
        ArrayList<INodeCandidatePrimaryKey> srcs_param = new ArrayList<INodeCandidatePrimaryKey>();
        for (INodeFile allSrcInode : allSrcInodes) {
            srcs_param.add(new INodeCandidatePrimaryKey(allSrcInode.getId()));
        }
        boolean bl = false;
        for (INodeFile nodeToRemove : allSrcInodes) {
            if (nodeToRemove == null) continue;
            trgParent.removeChild(nodeToRemove);
            ++var17_20;
        }
        trgInode.setModificationTimeForce(timestamp);
        trgParent.setModificationTime(timestamp);
        this.unprotectedUpdateCount(trgINodesInPath, trgINodes.length - 1, (long)(-var17_20), 0L);
        EntityManager.snapshotMaintenance((TransactionContextMaintenanceCmds)HdfsTransactionContextMaintenanceCmds.Concat, (Object[])new Object[]{trg_param, srcs_param, oldBlks});
    }

    long delete(String src, INode.BlocksMapUpdateInfo collectedBlocks, long mtime) throws UnresolvedLinkException, StorageException, IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.delete: " + src));
        }
        int filesRemoved = this.unprotectedDelete(src, collectedBlocks, mtime);
        return filesRemoved;
    }

    boolean isNonEmptyDirectory(String path) throws UnresolvedLinkException, StorageException, TransactionContextException {
        INode inode = this.getNode(path, false);
        if (inode == null || !inode.isDirectory()) {
            return false;
        }
        return ((INodeDirectory)inode).getChildrenList().size() != 0;
    }

    void unprotectedDelete(String src, long mtime) throws UnresolvedLinkException, StorageException, IOException {
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        int filesRemoved = this.unprotectedDelete(src, collectedBlocks, mtime);
        if (filesRemoved > 0) {
            this.getFSNamesystem().removePathAndBlocks(src, collectedBlocks);
        }
    }

    int unprotectedDelete(String src, INode.BlocksMapUpdateInfo collectedBlocks, long mtime) throws UnresolvedLinkException, StorageException, TransactionContextException {
        INodesInPath inodesInPath = this.getINodesInPath4Write(src = FSDirectory.normalizePath(src), false);
        INode[] inodes = inodesInPath.getINodes();
        INode targetNode = inodes[inodes.length - 1];
        if (targetNode == null) {
            if (NameNode.stateChangeLog.isDebugEnabled()) {
                NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because it does not exist"));
            }
            return -1;
        }
        if (inodes.length == 1) {
            NameNode.stateChangeLog.warn((Object)("DIR* FSDirectory.unprotectedDelete: failed to remove " + src + " because the root is not allowed to be deleted"));
            return -1;
        }
        this.addMetaDataLogForDirDeletion(targetNode);
        targetNode = this.removeLastINode(inodesInPath);
        if (targetNode == null) {
            return -1;
        }
        inodes[inodes.length - 2].setModificationTime(mtime);
        inodes[inodes.length - 2].asDirectory().decreaseChildrenNum();
        int filesRemoved = targetNode.collectSubtreeBlocksAndClear(collectedBlocks);
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* FSDirectory.unprotectedDelete: " + src + " is removed"));
        }
        return filesRemoved;
    }

    private void addMetaDataLogForDirDeletion(INode targetNode) throws TransactionContextException, StorageException {
        if (targetNode.isDirectory()) {
            List<INode> children = ((INodeDirectory)targetNode).getChildrenList();
            for (INode child : children) {
                if (child.isDirectory()) {
                    this.addMetaDataLogForDirDeletion(child);
                    continue;
                }
                child.logMetadataEvent(MetadataLogEntry.Operation.DELETE);
            }
        }
        targetNode.logMetadataEvent(MetadataLogEntry.Operation.DELETE);
    }

    private byte getStoragePolicyID(byte inodePolicy, byte parentPolicy) {
        return inodePolicy != 0 ? inodePolicy : parentPolicy;
    }

    DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation, boolean isSuperUser) throws UnresolvedLinkException, IOException, StorageException {
        byte parentStoragePolicy;
        String srcs = FSDirectory.normalizePath(src);
        INode targetNode = this.getNode(srcs, true);
        if (targetNode == null) {
            return null;
        }
        byte by = parentStoragePolicy = isSuperUser ? targetNode.getStoragePolicyID() : (byte)0;
        if (!targetNode.isDirectory()) {
            return new DirectoryListing(new HdfsFileStatus[]{this.createFileStatus(HdfsFileStatus.EMPTY_NAME, targetNode, needLocation, parentStoragePolicy)}, 0);
        }
        INodeDirectory dirInode = (INodeDirectory)targetNode;
        List<INode> contents = dirInode.getChildrenList();
        int startChild = dirInode.nextChild(contents, startAfter);
        int totalNumChildren = contents.size();
        int numOfListing = Math.min(totalNumChildren - startChild, this.lsLimit);
        int locationBudget = this.lsLimit;
        int listingCnt = 0;
        HdfsFileStatus[] listing = new HdfsFileStatus[numOfListing];
        for (int i = 0; i < numOfListing && locationBudget > 0; ++i) {
            INode cur = contents.get(startChild + i);
            byte curPolicy = isSuperUser && !cur.isSymlink() ? cur.getLocalStoragePolicyID() : (byte)0;
            listing[i] = this.createFileStatus(cur.getLocalNameBytes(), cur, needLocation, this.getStoragePolicyID(curPolicy, parentStoragePolicy));
            ++listingCnt;
            if (!needLocation) continue;
            LocatedBlocks blks = ((HdfsLocatedFileStatus)listing[i]).getBlockLocations();
            locationBudget -= blks == null ? 0 : blks.locatedBlockCount() * listing[i].getReplication();
        }
        if (listingCnt < numOfListing) {
            listing = Arrays.copyOf(listing, listingCnt);
        }
        return new DirectoryListing(listing, totalNumChildren - startChild - listingCnt);
    }

    HdfsFileStatus getFileInfo(String src, boolean resolveLink, boolean includeStoragePolicy) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        INode targetNode = this.getNode(srcs, resolveLink);
        if (targetNode == null) {
            return null;
        }
        byte policyId = includeStoragePolicy && targetNode != null && !targetNode.isSymlink() ? targetNode.getStoragePolicyID() : (byte)0;
        return this.createFileStatus(HdfsFileStatus.EMPTY_NAME, targetNode, policyId);
    }

    INodesInPath getExistingPathINodes(byte[][] components) throws UnresolvedLinkException, StorageException, TransactionContextException {
        return INodesInPath.resolve(this.getRootDir(), components);
    }

    public INode getINode(String src) throws UnresolvedLinkException, StorageException, TransactionContextException {
        return this.getNode(src, true);
    }

    INodesInPath getINodesInPath4Write(String path) throws UnresolvedLinkException, StorageException, TransactionContextException {
        return this.getINodesInPath4Write(path, true);
    }

    public INodesInPath getLastINodeInPath(String src) throws UnresolvedLinkException, StorageException, TransactionContextException {
        return this.getLastINodeInPath(src, true);
    }

    boolean isValidToCreate(String src) throws UnresolvedLinkException, StorageException, TransactionContextException {
        String srcs = FSDirectory.normalizePath(src);
        return srcs.startsWith("/") && !srcs.endsWith("/") && this.getINode4Write(srcs, false) == null;
    }

    boolean isDir(String src) throws UnresolvedLinkException, StorageException, TransactionContextException {
        INode node = this.getNode(src = FSDirectory.normalizePath(src), false);
        return node != null && node.isDirectory();
    }

    void updateSpaceConsumed(String path, long nsDelta, long dsDelta) throws QuotaExceededException, FileNotFoundException, UnresolvedLinkException, StorageException, TransactionContextException {
        int len;
        INodesInPath inodesInPath = this.getINodesInPath4Write(path, false);
        INode[] inodes = inodesInPath.getINodes();
        if (inodes[(len = inodes.length) - 1] == null) {
            throw new FileNotFoundException("Path not found: " + path);
        }
        this.updateCount(inodesInPath, len - 1, nsDelta, dsDelta, true);
    }

    private void updateCount(INodesInPath inodesInPath, int numOfINodes, long nsDelta, long dsDelta, boolean checkQuota) throws QuotaExceededException, StorageException, TransactionContextException {
        if (!this.isQuotaEnabled()) {
            return;
        }
        if (!this.namesystem.isImageLoaded()) {
            return;
        }
        INode[] inodes = inodesInPath.getINodes();
        if (numOfINodes > inodes.length) {
            numOfINodes = inodes.length;
        }
        if (checkQuota) {
            this.verifyQuota(inodes, numOfINodes, nsDelta, dsDelta, null);
        }
        INode iNode = inodes[numOfINodes - 1];
        this.namesystem.getQuotaUpdateManager().addUpdate(iNode.getId(), nsDelta, dsDelta);
    }

    private void updateCountNoQuotaCheck(INodesInPath inodesInPath, int numOfINodes, long nsDelta, long dsDelta) throws StorageException, TransactionContextException {
        try {
            this.updateCount(inodesInPath, numOfINodes, nsDelta, dsDelta, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.warn((Object)"FSDirectory.updateCountNoQuotaCheck - unexpected ", (Throwable)e);
        }
    }

    void unprotectedUpdateCount(INodesInPath inodesInPath, int numOfINodes, long nsDelta, long dsDelta) throws StorageException, TransactionContextException {
        if (!this.isQuotaEnabled()) {
            return;
        }
        INode[] inodes = inodesInPath.getINodes();
        INode iNode = inodes[numOfINodes - 1];
        this.namesystem.getQuotaUpdateManager().addUpdate(iNode.getId(), nsDelta, dsDelta);
    }

    private static String getFullPathName(INode[] inodes, int pos) {
        StringBuilder fullPathName = new StringBuilder();
        if (inodes[0].isRoot()) {
            if (pos == 0) {
                return "/";
            }
        } else {
            fullPathName.append(inodes[0].getLocalName());
        }
        for (int i = 1; i <= pos; ++i) {
            fullPathName.append('/').append(inodes[i].getLocalName());
        }
        return fullPathName.toString();
    }

    static String getFullPathName(INode inode) throws StorageException, TransactionContextException {
        int depth = 0;
        for (INode i = inode; i != null; i = i.getParent()) {
            ++depth;
        }
        INode[] inodes = new INode[depth];
        for (int i = 0; i < depth; ++i) {
            if (inode == null) {
                NameNode.stateChangeLog.warn((Object)"Could not get full path. Corresponding file might have deleted already.");
                return null;
            }
            inodes[depth - i - 1] = inode;
            inode = inode.getParent();
        }
        return FSDirectory.getFullPathName(inodes, depth - 1);
    }

    INode unprotectedMkdir(int inodeId, String src, PermissionStatus permissions, long timestamp) throws IOException {
        byte[][] components = INode.getPathComponents(src);
        INodesInPath inodesInPath = this.getExistingPathINodes(components);
        INode[] inodes = inodesInPath.getINodes();
        this.unprotectedMkdir(inodeId, inodesInPath, inodes.length - 1, components[inodes.length - 1], permissions, timestamp);
        return inodes[inodes.length - 1];
    }

    void unprotectedMkdir(long inodeId, INodesInPath inodesInPath, int pos, byte[] name, PermissionStatus permission, long timestamp) throws IOException {
        INodeDirectory dir = new INodeDirectory(inodeId, name, permission, timestamp);
        if (this.addChild(inodesInPath, pos, dir, true)) {
            inodesInPath.setINode(pos, dir);
        }
    }

    private boolean addINode(String src, INode child) throws IOException {
        byte[][] components = INode.getPathComponents(src);
        byte[] path = components[components.length - 1];
        child.setLocalNameNoPersistance(path);
        this.cacheName(child);
        INodesInPath inodesInPath = this.getExistingPathINodes(components);
        return this.addLastINode(inodesInPath, child, true);
    }

    private void verifyQuota(INode[] inodes, int pos, long nsDelta, long dsDelta, INode commonAncestor) throws QuotaExceededException, StorageException, TransactionContextException {
        int i;
        if (!this.namesystem.isImageLoaded()) {
            return;
        }
        if (nsDelta <= 0L && dsDelta <= 0L) {
            return;
        }
        if (pos > inodes.length) {
            pos = inodes.length;
        }
        try {
            for (i = pos - 1; i >= 0; --i) {
                if (commonAncestor == inodes[i]) {
                    return;
                }
                DirectoryWithQuotaFeature q = inodes[i].asDirectory().getDirectoryWithQuotaFeature();
                if (q == null) continue;
                q.verifyQuota(inodes[i].asDirectory(), nsDelta, dsDelta);
            }
        }
        catch (QuotaExceededException e) {
            e.setPathName(FSDirectory.getFullPathName(inodes, i));
            throw e;
        }
    }

    private void verifyQuotaForRename(INode[] srcInodes, INode[] dstInodes, INode.DirCounts srcCounts, INode.DirCounts dstCounts) throws QuotaExceededException, StorageException, TransactionContextException {
        if (!this.isQuotaEnabled()) {
            return;
        }
        if (!this.namesystem.isImageLoaded()) {
            return;
        }
        INode commonAncestor = null;
        int i = 0;
        while (srcInodes[i] == dstInodes[i]) {
            commonAncestor = srcInodes[i];
            ++i;
        }
        long nsDelta = srcCounts.getNsCount();
        long dsDelta = srcCounts.getDsCount();
        INode dstInode = dstInodes[dstInodes.length - 1];
        if (dstInode != null) {
            nsDelta -= dstCounts.getNsCount();
            dsDelta -= dstCounts.getDsCount();
        }
        this.verifyQuota(dstInodes, dstInodes.length - 1, nsDelta, dsDelta, commonAncestor);
    }

    private void verifyFsLimitsForRename(INodesInPath srcIIP, INodesInPath dstIIP, byte[] dstChildName) throws FSLimitException.PathComponentTooLongException, FSLimitException.MaxDirectoryItemsExceededException, StorageException, TransactionContextException {
        INode[] dstInodes = dstIIP.getINodes();
        int pos = dstInodes.length - 1;
        this.verifyMaxComponentLength(dstChildName, dstInodes, pos);
        if (this.maxDirItems > 0 && srcIIP.getINode(-2) != dstIIP.getINode(-2)) {
            this.verifyMaxDirItems(dstInodes, pos);
        }
    }

    private void verifyMaxComponentLength(byte[] childName, Object parentPath, int pos) throws FSLimitException.PathComponentTooLongException {
        if (this.maxComponentLength == 0) {
            return;
        }
        int length = childName.length;
        if (length > this.maxComponentLength) {
            String p = parentPath instanceof INode[] ? FSDirectory.getFullPathName((INode[])parentPath, pos - 1) : (String)parentPath;
            FSLimitException.PathComponentTooLongException e = new FSLimitException.PathComponentTooLongException(this.maxComponentLength, length, p, DFSUtil.bytes2String(childName));
            if (this.namesystem.isImageLoaded()) {
                throw e;
            }
            NameNode.LOG.error((Object)"ERROR in FSDirectory.verifyINodeName", (Throwable)e);
        }
    }

    private void verifyMaxDirItems(INode[] pathComponents, int pos) throws FSLimitException.MaxDirectoryItemsExceededException, StorageException, TransactionContextException {
        INodeDirectory parent = pathComponents[pos - 1].asDirectory();
        int count = parent.getChildrenNum();
        if (count >= this.maxDirItems) {
            FSLimitException.MaxDirectoryItemsExceededException e = new FSLimitException.MaxDirectoryItemsExceededException(this.maxDirItems, count);
            if (this.namesystem.isImageLoaded()) {
                e.setPathName(FSDirectory.getFullPathName(pathComponents, pos - 1));
                throw e;
            }
            NameNode.LOG.error((Object)("FSDirectory.verifyMaxDirItems: " + e.getLocalizedMessage()));
        }
    }

    protected <T extends INode> void verifyFsLimits(INode[] pathComponents, int pos, T child) throws FSLimitException, StorageException, TransactionContextException {
        boolean includeChildName = false;
        try {
            INodeDirectory parent;
            int count;
            int length;
            if (this.maxComponentLength != 0 && (length = child.getLocalName().length()) > this.maxComponentLength) {
                includeChildName = true;
                String p = FSDirectory.getFullPathName(pathComponents, pos - 1);
                throw new FSLimitException.PathComponentTooLongException(this.maxComponentLength, length, p, child.getLocalName());
            }
            if (this.maxDirItems != 0 && (count = (parent = (INodeDirectory)pathComponents[pos - 1]).getChildrenNum()) >= this.maxDirItems) {
                throw new FSLimitException.MaxDirectoryItemsExceededException(this.maxDirItems, count);
            }
        }
        catch (FSLimitException e) {
            String badPath = FSDirectory.getFullPathName(pathComponents, pos - 1);
            if (includeChildName) {
                badPath = badPath + "/" + child.getLocalName();
            }
            e.setPathName(badPath);
            if (this.namesystem.isImageLoaded()) {
                throw e;
            }
            NameNode.LOG.error((Object)("FSDirectory.verifyFsLimits - " + e.getLocalizedMessage()));
        }
    }

    private boolean addLastINode(INodesInPath inodesInPath, INode inode, INode.DirCounts counts, boolean checkQuota, boolean logMetadataEvent) throws QuotaExceededException, StorageException, IOException {
        int pos = inodesInPath.getINodes().length - 1;
        return this.addChild(inodesInPath, pos, inode, counts, checkQuota, logMetadataEvent);
    }

    private boolean addLastINode(INodesInPath inodesInPath, INode inode, boolean checkQuota) throws QuotaExceededException, StorageException, IOException {
        int pos = inodesInPath.getINodes().length - 1;
        return this.addChild(inodesInPath, pos, inode, checkQuota);
    }

    private boolean addChild(INodesInPath inodesInPath, int pos, INode child, boolean checkQuota) throws QuotaExceededException, StorageException, IOException {
        INode[] inodes = inodesInPath.getINodes();
        if (checkQuota) {
            this.verifyFsLimits(inodes, pos, child);
        }
        INode.DirCounts counts = new INode.DirCounts();
        if (this.isQuotaEnabled()) {
            child.spaceConsumedInTree(counts);
        }
        return this.addChild(inodesInPath, pos, child, counts, checkQuota);
    }

    private boolean addChild(INodesInPath inodesInPath, int pos, INode child, INode.DirCounts counts, boolean checkQuota) throws IOException {
        return this.addChild(inodesInPath, pos, child, counts, checkQuota, true);
    }

    private boolean addChild(INodesInPath inodesInPath, int pos, INode child, INode.DirCounts counts, boolean checkQuota, boolean logMetadataEvent) throws IOException {
        INode[] inodes = inodesInPath.getINodes();
        if (pos == 1 && inodes[0] == this.getRootDir() && FSDirectory.isReservedName(child)) {
            throw new HadoopIllegalArgumentException("File name \"" + child.getLocalName() + "\" is reserved and cannot be created. If this is during upgrade change the name of the existing file or directory to another name before upgrading to the new release.");
        }
        if (checkQuota) {
            this.verifyFsLimits(inodes, pos, child);
        }
        this.updateCount(inodesInPath, pos, counts.getNsCount(), counts.getDsCount(), checkQuota);
        if (inodes[pos - 1] == null) {
            throw new NullPointerException("Panic: parent does not exist");
        }
        boolean added = ((INodeDirectory)inodes[pos - 1]).addChild(child, true, logMetadataEvent);
        if (!added) {
            this.updateCount(inodesInPath, pos, -counts.getNsCount(), -counts.getDsCount(), true);
        }
        if (added && !child.isDirectory()) {
            INode[] pc = Arrays.copyOf(inodes, inodes.length);
            pc[pc.length - 1] = child;
            String path = FSDirectory.getFullPathName(pc, pc.length - 1);
            Cache.getInstance().set(path, pc);
        }
        return added;
    }

    private boolean addLastINodeNoQuotaCheck(INodesInPath inodesInPath, INode child, INode.DirCounts counts) throws IOException {
        try {
            return this.addLastINode(inodesInPath, child, counts, false, false);
        }
        catch (QuotaExceededException e) {
            NameNode.LOG.warn((Object)"FSDirectory.addChildNoQuotaCheck - unexpected", (Throwable)e);
            return false;
        }
    }

    private INode removeLastINode(INodesInPath inodesInPath) throws StorageException, TransactionContextException {
        INode[] inodes = inodesInPath.getINodes();
        int pos = inodes.length - 1;
        INode.DirCounts counts = new INode.DirCounts();
        if (this.isQuotaEnabled()) {
            INode nodeToBeRemored = inodes[pos];
            nodeToBeRemored.spaceConsumedInTree(counts);
        }
        return this.removeLastINode(inodesInPath, false, counts);
    }

    private INode removeLastINode(INodesInPath inodesInPath, boolean forRename, INode.DirCounts counts) throws StorageException, TransactionContextException {
        INode[] inodes = inodesInPath.getINodes();
        int pos = inodes.length - 1;
        INode removedNode = null;
        removedNode = forRename ? inodes[pos] : ((INodeDirectory)inodes[pos - 1]).removeChild(inodes[pos]);
        if (removedNode != null && this.isQuotaEnabled()) {
            List outstandingUpdates = (List)EntityManager.findList((FinderType)QuotaUpdate.Finder.ByINodeId, (Object[])new Object[]{removedNode.getId()});
            long nsDelta = 0L;
            long dsDelta = 0L;
            for (QuotaUpdate update : outstandingUpdates) {
                nsDelta += update.getNamespaceDelta();
                dsDelta += update.getDiskspaceDelta();
            }
            this.updateCountNoQuotaCheck(inodesInPath, pos, -counts.getNsCount() + nsDelta, -counts.getDsCount() + dsDelta);
        }
        return removedNode;
    }

    INode removeChildNonRecursively(INodesInPath inodesInPath, int pos) throws StorageException, TransactionContextException {
        INode[] inodes = inodesInPath.getINodes();
        INode removedNode = ((INodeDirectory)inodes[pos - 1]).removeChild(inodes[pos]);
        if (removedNode != null && this.isQuotaEnabled()) {
            List outstandingUpdates = (List)EntityManager.findList((FinderType)QuotaUpdate.Finder.ByINodeId, (Object[])new Object[]{removedNode.getId()});
            long nsDelta = 0L;
            long dsDelta = 0L;
            for (QuotaUpdate update : outstandingUpdates) {
                nsDelta += update.getNamespaceDelta();
                dsDelta += update.getDiskspaceDelta();
            }
            if (removedNode.isDirectory()) {
                this.updateCountNoQuotaCheck(inodesInPath, pos, -1L + nsDelta, dsDelta);
            } else {
                INode.DirCounts counts = new INode.DirCounts();
                removedNode.spaceConsumedInTree(counts);
                this.updateCountNoQuotaCheck(inodesInPath, pos, -counts.getNsCount() + nsDelta, -counts.getDsCount() + dsDelta);
            }
        }
        return removedNode;
    }

    private INode removeLastINode(INodesInPath inodesInPath, INode.DirCounts counts) throws StorageException, TransactionContextException {
        return this.removeLastINode(inodesInPath, false, counts);
    }

    private INode removeLastINodeForRename(INodesInPath inodesInPath, INode.DirCounts counts) throws StorageException, TransactionContextException {
        return this.removeLastINode(inodesInPath, true, counts);
    }

    static String normalizePath(String src) {
        if (src.length() > 1 && src.endsWith("/")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }

    ContentSummary getContentSummary(String src) throws FileNotFoundException, UnresolvedLinkException, StorageException, TransactionContextException {
        String srcs = FSDirectory.normalizePath(src);
        INode targetNode = this.getNode(srcs, false);
        if (targetNode == null) {
            throw new FileNotFoundException("File does not exist: " + srcs);
        }
        ContentSummaryComputationContext cscc = new ContentSummaryComputationContext(this, this.getFSNamesystem(), this.contentCountLimit);
        ContentSummary cs = targetNode.computeAndConvertContentSummary(cscc);
        this.yieldCount += cscc.getYieldCount();
        return cs;
    }

    @VisibleForTesting
    public long getYieldCount() {
        return this.yieldCount;
    }

    void updateCountForINodeWithQuota() throws StorageException, TransactionContextException {
        FSDirectory.updateCountForINodeWithQuota(this, this.getRootDir(), new INode.DirCounts(), new ArrayList<INode>(50));
    }

    private static void updateCountForINodeWithQuota(FSDirectory fsd, INodeDirectory dir, INode.DirCounts counts, ArrayList<INode> nodesInPath) throws StorageException, TransactionContextException {
        long parentNamespace = counts.nsCount;
        long parentDiskspace = counts.dsCount;
        counts.nsCount = 1L;
        counts.dsCount = 0L;
        nodesInPath.add(dir);
        for (INode child : dir.getChildrenList()) {
            if (child.isDirectory()) {
                FSDirectory.updateCountForINodeWithQuota(fsd, (INodeDirectory)child, counts, nodesInPath);
                continue;
            }
            if (child.isSymlink()) {
                ++counts.nsCount;
                continue;
            }
            ++counts.nsCount;
            counts.dsCount += ((INodeFile)child).diskspaceConsumed();
        }
        if (dir.isQuotaSet()) {
            Quota.Counts oldQuota;
            DirectoryWithQuotaFeature q = dir.getDirectoryWithQuotaFeature();
            if (q != null) {
                q.setSpaceConsumed(dir, counts.nsCount, counts.dsCount);
            }
            if ((oldQuota = dir.getQuotaCounts()).get(Quota.NAMESPACE) >= 0L && counts.nsCount > oldQuota.get(Quota.NAMESPACE) || oldQuota.get(Quota.DISKSPACE) >= 0L && counts.dsCount > oldQuota.get(Quota.DISKSPACE)) {
                StringBuilder path = new StringBuilder(512);
                for (INode n : nodesInPath) {
                    path.append('/');
                    path.append(n.getLocalName());
                }
                NameNode.LOG.warn((Object)("Quota violation in image for " + path + " (Namespace quota : " + oldQuota.get(Quota.NAMESPACE) + " consumed : " + counts.nsCount + ") (Diskspace quota : " + oldQuota.get(Quota.DISKSPACE) + " consumed : " + counts.dsCount + ")."));
            }
        }
        nodesInPath.remove(nodesInPath.size() - 1);
        counts.nsCount += parentNamespace;
        counts.dsCount += parentDiskspace;
    }

    INodeDirectory setQuota(String src, long nsQuota, long dsQuota, long nsCount, long dsCount) throws FileNotFoundException, PathIsNotDirectoryException, QuotaExceededException, UnresolvedLinkException, IOException {
        return this.unprotectedSetQuota(src, nsQuota, dsQuota, nsCount, dsCount);
    }

    INodeDirectory unprotectedSetQuota(String src, long nsQuota, long dsQuota, long nsCount, long dsCount) throws FileNotFoundException, PathIsNotDirectoryException, IOException, QuotaExceededException, UnresolvedLinkException, StorageException, TransactionContextException {
        if (!this.isQuotaEnabled()) {
            return null;
        }
        if (nsQuota < 0L && nsQuota != Long.MAX_VALUE && nsQuota != -1L || dsQuota < 0L && dsQuota != Long.MAX_VALUE && dsQuota != -1L) {
            throw new IllegalArgumentException("Illegal value for nsQuota or dsQuota : " + nsQuota + " and " + dsQuota);
        }
        String srcs = FSDirectory.normalizePath(src);
        INodesInPath inodesInPath = this.getINodesInPath4Write(src, true);
        INode[] inodes = inodesInPath.getINodes();
        INodeDirectory dirNode = INodeDirectory.valueOf(inodes[inodes.length - 1], srcs);
        if (dirNode.isRoot() && nsQuota == -1L) {
            throw new IllegalArgumentException("Cannot clear namespace quota on root.");
        }
        Quota.Counts oldQuota = dirNode.getQuotaCounts();
        long oldNsQuota = oldQuota.get(Quota.NAMESPACE);
        long oldDsQuota = oldQuota.get(Quota.DISKSPACE);
        if (nsQuota == Long.MAX_VALUE) {
            nsQuota = oldNsQuota;
        }
        if (dsQuota == Long.MAX_VALUE) {
            dsQuota = oldDsQuota;
        }
        if (!dirNode.isRoot()) {
            dirNode.setQuota(nsQuota, nsCount, dsQuota, dsCount);
            INodeDirectory parent = (INodeDirectory)inodes[inodes.length - 2];
            parent.replaceChild(dirNode);
        }
        return oldNsQuota != nsQuota || oldDsQuota != dsQuota ? dirNode : null;
    }

    long totalInodes() throws IOException {
        LightWeightRequestHandler totalInodesHandler = new LightWeightRequestHandler(HDFSOperationType.TOTAL_FILES){

            public Object performTask() throws StorageException, IOException {
                INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return da.countAll();
            }
        };
        return ((Integer)totalInodesHandler.handle()).intValue();
    }

    boolean setTimes(INode inode, long mtime, long atime, boolean force) throws StorageException, TransactionContextException, AccessControlException {
        return this.unprotectedSetTimes(inode, mtime, atime, force);
    }

    boolean unprotectedSetTimes(String src, long mtime, long atime, boolean force) throws UnresolvedLinkException, StorageException, TransactionContextException, AccessControlException {
        INode inode = this.getINode(src);
        return this.unprotectedSetTimes(inode, mtime, atime, force);
    }

    private boolean unprotectedSetTimes(INode inode, long mtime, long atime, boolean force) throws StorageException, TransactionContextException, AccessControlException {
        boolean status = false;
        if (mtime != -1L) {
            inode.setModificationTimeForce(mtime);
            status = true;
        }
        if (atime != -1L) {
            long inodeTime = inode.getAccessTime();
            if (atime <= inodeTime + this.getFSNamesystem().getAccessTimePrecision() && !force) {
                status = false;
            } else {
                inode.setAccessTime(atime);
                status = true;
            }
        }
        return status;
    }

    void reset() throws IOException {
        this.createRoot(this.namesystem.createFsOwnerPermissions(new FsPermission(493)), true);
        this.nameCache.reset();
    }

    private HdfsFileStatus createFileStatus(byte[] path, INode node, boolean needLocation, byte storagePolicy) throws IOException, StorageException {
        if (needLocation) {
            return this.createLocatedFileStatus(path, node, storagePolicy);
        }
        return this.createFileStatus(path, node, storagePolicy);
    }

    private HdfsFileStatus createFileStatus(byte[] path, INode node, byte storagePolicy) throws IOException {
        long size = 0L;
        if (node instanceof INodeFile) {
            INodeFile fileNode = (INodeFile)node;
            size = fileNode.getSize();
        }
        short replication = 0;
        long blocksize = 0L;
        boolean isStoredInDB = false;
        if (node instanceof INodeFile) {
            INodeFile fileNode = (INodeFile)node;
            replication = fileNode.getBlockReplication();
            blocksize = fileNode.getPreferredBlockSize();
            isStoredInDB = fileNode.isFileStoredInDB();
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum() : 0;
        return new HdfsFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(), node.getAccessTime(), FSDirectory.getPermissionForFileStatus(node), node.getUserName(), node.getGroupName(), node.isSymlink() ? ((INodeSymlink)node).getSymlink() : null, path, node.getId(), childrenNum, isStoredInDB, storagePolicy);
    }

    private HdfsLocatedFileStatus createLocatedFileStatus(byte[] path, INode node, byte storagePolicy) throws IOException {
        long size = 0L;
        short replication = 0;
        long blocksize = 0L;
        LocatedBlocks loc = null;
        boolean isFileStoredInDB = false;
        if (node.isFile()) {
            INodeFile fileNode = node.asFile();
            isFileStoredInDB = fileNode.isFileStoredInDB();
            size = isFileStoredInDB ? fileNode.getSize() : fileNode.computeFileSize(true);
            replication = fileNode.getBlockReplication();
            blocksize = fileNode.getPreferredBlockSize();
            boolean isUc = fileNode.isUnderConstruction();
            long fileSize = isUc ? fileNode.computeFileSizeNotIncludingLastUcBlock() : size;
            loc = isFileStoredInDB ? this.getFSNamesystem().getBlockManager().createPhantomLocatedBlocks(fileNode, null, isUc, false) : this.getFSNamesystem().getBlockManager().createLocatedBlocks(fileNode.getBlocks(), fileSize, isUc, 0L, size, false);
            if (loc == null) {
                loc = new LocatedBlocks();
            }
        }
        int childrenNum = node.isDirectory() ? node.asDirectory().getChildrenNum() : 0;
        HdfsLocatedFileStatus status = new HdfsLocatedFileStatus(size, node.isDirectory(), replication, blocksize, node.getModificationTime(), node.getAccessTime(), node.getFsPermission(), node.getUserName(), node.getGroupName(), node.isSymlink() ? node.asSymlink().getSymlink() : null, path, node.getId(), loc, childrenNum, isFileStoredInDB, storagePolicy);
        if (loc != null) {
            CacheManager cacheManager = this.namesystem.getCacheManager();
            for (LocatedBlock lb : loc.getLocatedBlocks()) {
                cacheManager.setCachedLocations(lb, node.getId());
            }
        }
        return status;
    }

    private static FsPermission getPermissionForFileStatus(INode node) throws TransactionContextException, StorageException, AclException {
        FsPermission perm = node.getFsPermission();
        if (node.getAclFeature() != null) {
            perm = new FsAclPermission(perm);
        }
        return perm;
    }

    INodeSymlink addSymlink(long id, String path, String target, long mtime, long atime, PermissionStatus perm) throws UnresolvedLinkException, QuotaExceededException, IOException {
        return this.unprotectedAddSymlink(id, path, target, mtime, atime, perm);
    }

    INodeSymlink unprotectedAddSymlink(long id, String path, String target, long mtime, long atime, PermissionStatus perm) throws IOException {
        INodeSymlink symlink = new INodeSymlink(id, target, mtime, atime, perm);
        return this.addINode(path, symlink) ? symlink : null;
    }

    List<AclEntry> modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        return this.unprotectedModifyAclEntries(src, aclSpec);
    }

    private List<AclEntry> unprotectedModifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        AclStorage.validateAclSpec(aclSpec);
        INode inode = this.getINode(src);
        if (inode == null) {
            throw new FileNotFoundException();
        }
        if (aclSpec.size() == 1 && aclSpec.get(0).getType().equals((Object)AclEntryType.MASK)) {
            FsPermission fsPermission = inode.getFsPermission();
            inode.setPermission(new FsPermission(fsPermission.getUserAction(), aclSpec.get(0).getPermission(), fsPermission.getOtherAction()));
            return AclStorage.readINodeLogicalAcl(inode);
        }
        List<AclEntry> existingAcl = AclStorage.hasOwnAcl(inode) ? AclStorage.readINodeLogicalAcl(inode) : AclStorage.getMinimalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.mergeAclEntries(existingAcl, aclSpec);
        AclStorage.updateINodeAcl(inode, newAcl);
        return newAcl;
    }

    List<AclEntry> removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        return this.unprotectedRemoveAclEntries(src, aclSpec);
    }

    private List<AclEntry> unprotectedRemoveAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        AclStorage.validateAclSpec(aclSpec);
        INode inode = this.getINode(src);
        if (inode == null) {
            throw new FileNotFoundException();
        }
        List<AclEntry> existingAcl = AclStorage.hasOwnAcl(inode) ? AclStorage.readINodeLogicalAcl(inode) : AclStorage.getMinimalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.filterAclEntriesByAclSpec(existingAcl, aclSpec);
        AclStorage.updateINodeAcl(inode, newAcl);
        return newAcl;
    }

    List<AclEntry> removeDefaultAcl(String src) throws IOException {
        return this.unprotectedRemoveDefaultAcl(src);
    }

    private List<AclEntry> unprotectedRemoveDefaultAcl(String src) throws IOException {
        INode inode = this.getINode(src);
        if (inode == null) {
            throw new FileNotFoundException();
        }
        List<AclEntry> existingAcl = AclStorage.hasOwnAcl(inode) ? AclStorage.readINodeLogicalAcl(inode) : AclStorage.getMinimalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.filterDefaultAclEntries(existingAcl);
        AclStorage.updateINodeAcl(inode, newAcl);
        return newAcl;
    }

    void removeAcl(String src) throws IOException {
        this.unprotectedRemoveAcl(src);
    }

    private void unprotectedRemoveAcl(String src) throws IOException {
        INode inode = this.getINode(src);
        if (inode == null) {
            throw new FileNotFoundException();
        }
        AclStorage.removeINodeAcl(inode);
    }

    List<AclEntry> setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        return this.unprotectedSetAcl(src, aclSpec);
    }

    List<AclEntry> unprotectedSetAcl(String src, List<AclEntry> aclSpec) throws IOException {
        AclStorage.validateAclSpec(aclSpec);
        if (aclSpec.isEmpty()) {
            this.unprotectedRemoveAcl(src);
            return AclFeature.EMPTY_ENTRY_LIST;
        }
        INode inode = this.getINode(src);
        if (inode == null) {
            throw new FileNotFoundException();
        }
        List<AclEntry> existingAcl = AclStorage.hasOwnAcl(inode) ? AclStorage.readINodeLogicalAcl(inode) : AclStorage.getMinimalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.replaceAclEntries(existingAcl, aclSpec);
        AclStorage.updateINodeAcl(inode, newAcl);
        return newAcl;
    }

    AclStatus getAclStatus(String src) throws IOException {
        String srcs = FSDirectory.normalizePath(src);
        INode inode = this.getINode(srcs);
        List<AclEntry> acl = AclStorage.readINodeAcl(inode);
        return new AclStatus.Builder().owner(inode.getUserName()).group(inode.getGroupName()).stickyBit(inode.getFsPermission().getStickyBit()).addEntries(acl).build();
    }

    void cacheName(INode inode) throws StorageException, TransactionContextException {
        if (!inode.isFile()) {
            return;
        }
        ByteArray name = new ByteArray(inode.getLocalNameBytes());
        if ((name = this.nameCache.put(name)) != null) {
            inode.setLocalName(name.getBytes());
        }
    }

    static byte[][] getPathComponents(INode inode) throws StorageException, TransactionContextException {
        ArrayList<byte[]> components = new ArrayList<byte[]>();
        components.add(0, inode.getLocalNameBytes());
        while (inode.getParent() != null) {
            components.add(0, inode.getParent().getLocalNameBytes());
            inode = inode.getParent();
        }
        return (byte[][])components.toArray((T[])new byte[components.size()][]);
    }

    static byte[][] getPathComponentsForReservedPath(String src) {
        return !FSDirectory.isReservedName(src) ? (byte[][])null : INode.getPathComponents(src);
    }

    public static boolean isReservedName(INode inode) {
        return CHECK_RESERVED_FILE_NAMES && Arrays.equals(inode.getLocalNameBytes(), DOT_RESERVED);
    }

    public static boolean isReservedName(String src) {
        return src.startsWith(DOT_RESERVED_PATH_PREFIX);
    }

    static String resolvePath(String src, byte[][] pathComponents, FSDirectory fsd) throws FileNotFoundException, StorageException, TransactionContextException, IOException {
        int id;
        if (pathComponents == null || pathComponents.length <= 3) {
            return src;
        }
        if (!Arrays.equals(DOT_RESERVED, pathComponents[1]) || !Arrays.equals(DOT_INODES, pathComponents[2])) {
            return src;
        }
        String inodeId = DFSUtil.bytes2String(pathComponents[3]);
        try {
            id = Integer.valueOf(inodeId);
        }
        catch (NumberFormatException e) {
            throw new FileNotFoundException("Invalid inode path: " + src);
        }
        if ((long)id == 1L && pathComponents.length == 4) {
            return "/";
        }
        if (pathComponents.length > 4 && DFSUtil.bytes2String(pathComponents[4]).equals("..")) {
            INode parent = fsd.getParent(id, src);
            if (parent == null || parent.getId() == 1L) {
                return "/";
            }
            return fsd.getFullPathName(parent.getId(), src);
        }
        StringBuilder path = (long)id == 1L ? new StringBuilder() : new StringBuilder(fsd.getFullPathName(id, src));
        for (int i = 4; i < pathComponents.length; ++i) {
            path.append("/").append(DFSUtil.bytes2String(pathComponents[i]));
        }
        if (NameNode.LOG.isDebugEnabled()) {
            NameNode.LOG.debug((Object)("Resolved path is " + path));
        }
        return path.toString();
    }

    String getFullPathName(final long id, final String src) throws IOException {
        HopsTransactionalRequestHandler getFullPathNameHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_INODE){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = new INodeIdentifier(Long.valueOf(id));
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, this.inodeIdentifier, true));
            }

            public Object performTask() throws IOException {
                INode inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{id});
                if (inode == null) {
                    throw new FileNotFoundException("File for given inode path does not exist: " + src);
                }
                return inode.getFullPathName();
            }
        };
        return (String)getFullPathNameHandler.handle();
    }

    INode getParent(final long id, final String src) throws IOException {
        HopsTransactionalRequestHandler getParentHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_INODE){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = new INodeIdentifier(Long.valueOf(id));
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, this.inodeIdentifier, true));
            }

            public Object performTask() throws IOException {
                INode inode = (INode)EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{id});
                if (inode == null) {
                    throw new FileNotFoundException("File for given inode path does not exist: " + src);
                }
                return inode.getParent();
            }
        };
        return (INode)getParentHandler.handle();
    }

    INode getInode(final long id) throws IOException {
        HopsTransactionalRequestHandler getInodeHandler = new HopsTransactionalRequestHandler(HDFSOperationType.GET_INODE){
            INodeIdentifier inodeIdentifier;

            @Override
            public void setUp() throws StorageException {
                this.inodeIdentifier = new INodeIdentifier(Long.valueOf(id));
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualINodeLock(TransactionLockTypes.INodeLockType.READ_COMMITTED, this.inodeIdentifier, true));
            }

            public Object performTask() throws IOException {
                return EntityManager.find((FinderType)INode.Finder.ByINodeIdFTIS, (Object[])new Object[]{id});
            }
        };
        return (INode)getInodeHandler.handle();
    }

    private INodesInPath getLastINodeInPath(String path, boolean resolveLink) throws UnresolvedLinkException, StorageException, TransactionContextException {
        return INodesInPath.resolve(this.getRootDir(), INode.getPathComponents(path), 1, resolveLink);
    }

    INodesInPath getINodesInPath(String path, boolean resolveLink) throws UnresolvedLinkException, StorageException, TransactionContextException {
        byte[][] components = INode.getPathComponents(path);
        return INodesInPath.resolve(this.getRootDir(), components, components.length, resolveLink);
    }

    INode getNode(String path, boolean resolveLink) throws UnresolvedLinkException, StorageException, TransactionContextException {
        return this.getLastINodeInPath(path, resolveLink).getINode(0);
    }

    private INode getINode4Write(String src, boolean resolveLink) throws UnresolvedLinkException, StorageException, TransactionContextException {
        return this.getINodesInPath4Write(src, resolveLink).getLastINode();
    }

    private INodesInPath getINodesInPath4Write(String src, boolean resolveLink) throws UnresolvedLinkException, StorageException, TransactionContextException {
        byte[][] components = INode.getPathComponents(src);
        INodesInPath inodesInPath = INodesInPath.resolve(this.getRootDir(), components, components.length, resolveLink);
        return inodesInPath;
    }

    public INode getINode4Write(String src) throws UnresolvedLinkException, StorageException, TransactionContextException {
        return this.getINode4Write(src, true);
    }

    public INodeDirectory getRootDir() throws StorageException, TransactionContextException {
        return INodeDirectory.getRootDir();
    }

    public boolean isQuotaEnabled() {
        return this.quotaEnabled;
    }

    public INodeDirectory createRoot(final PermissionStatus ps, final boolean overwrite) throws IOException {
        LightWeightRequestHandler addRootINode = new LightWeightRequestHandler(HDFSOperationType.SET_ROOT){

            public Object performTask() throws IOException {
                INodeDirectory newRootINode = null;
                INodeDataAccess da = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                INodeDirectory rootInode = (INodeDirectory)da.findInodeByNameParentIdAndPartitionIdPK("", 0L, INodeDirectory.getRootDirPartitionKey());
                if (rootInode == null || overwrite) {
                    newRootINode = INodeDirectory.createRootDir(ps);
                    ArrayList<INodeDirectory> newINodes = new ArrayList<INodeDirectory>();
                    newINodes.add(newRootINode);
                    da.prepare(INode.EMPTY_LIST, newINodes, INode.EMPTY_LIST);
                    INodeAttributes inodeAttributes = new INodeAttributes(newRootINode.getId(), Long.MAX_VALUE, 1L, -1L, 0L);
                    INodeAttributesDataAccess ida = (INodeAttributesDataAccess)HdfsStorageFactory.getDataAccess(INodeAttributesDataAccess.class);
                    ArrayList<INodeAttributes> attrList = new ArrayList<INodeAttributes>();
                    attrList.add(inodeAttributes);
                    ida.prepare(attrList, null);
                    FSNamesystem.LOG.info((Object)"Added new root inode");
                }
                return newRootINode;
            }
        };
        return (INodeDirectory)addRootINode.handle();
    }

    public boolean hasChildren(final long parentId, final boolean areChildrenRandomlyPartitioned) throws IOException {
        LightWeightRequestHandler hasChildrenHandler = new LightWeightRequestHandler(HDFSOperationType.HAS_CHILDREN){

            public Object performTask() throws IOException {
                INodeDataAccess ida = (INodeDataAccess)HdfsStorageFactory.getDataAccess(INodeDataAccess.class);
                return ida.hasChildren(parentId, areChildrenRandomlyPartitioned);
            }
        };
        return (Boolean)hasChildrenHandler.handle();
    }

    private class RenameOperation {
        private final INodesInPath srcIIP;
        private final INodesInPath dstIIP;
        private final String src;
        private final String dst;
        private INode srcChild;
        private final INodeDirectory srcParent;
        private final byte[] srcChildName;
        private final Quota.Counts oldSrcCounts;
        private final INode.DirCounts srcCounts;

        private RenameOperation(String src, String dst, INodesInPath srcIIP, INodesInPath dstIIP, INode.DirCounts srcCounts) throws QuotaExceededException, StorageException, TransactionContextException {
            this.srcIIP = srcIIP;
            this.dstIIP = dstIIP;
            this.src = src;
            this.dst = dst;
            this.srcChild = srcIIP.getLastINode();
            this.srcChildName = this.srcChild.getLocalNameBytes();
            this.srcParent = srcIIP.getINode(-2).asDirectory();
            this.oldSrcCounts = Quota.Counts.newInstance();
            this.srcCounts = srcCounts;
        }

        boolean addSourceToDestination() throws IOException {
            INode dstParent = this.dstIIP.getINode(-2);
            this.srcChild = this.srcIIP.getLastINode();
            byte[] dstChildName = this.dstIIP.getLastLocalName();
            this.srcChild.setLocalNameNoPersistance(dstChildName);
            INode toDst = this.srcChild;
            return FSDirectory.this.addLastINodeNoQuotaCheck(this.dstIIP, toDst, this.srcCounts);
        }

        void updateMtimeAndLease(long timestamp) throws QuotaExceededException, StorageException, TransactionContextException {
            this.srcParent.updateModificationTime(timestamp);
            this.srcParent.decreaseChildrenNum();
            INode dstParent = this.dstIIP.getINode(-2);
            dstParent.updateModificationTime(timestamp);
            FSDirectory.this.getFSNamesystem().unprotectedChangeLease(this.src, this.dst);
        }

        void restoreSource() throws IOException {
            this.srcChild.setLocalNameNoPersistance(this.srcChildName);
            FSDirectory.this.addLastINodeNoQuotaCheck(this.srcIIP, this.srcChild, this.srcCounts);
        }

        void updateQuotasInSourceTree() throws QuotaExceededException {
        }
    }
}

