/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.exception.StorageException;
import io.hops.exception.TransactionContextException;
import io.hops.metadata.hdfs.entity.LeasePath;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.Lease;

@InterfaceAudience.Private
public class FileUnderConstructionFeature
implements INode.Feature {
    private String clientName;
    private final String clientMachine;
    private final INode inode;
    private long lastBlockId = -1L;
    private long penultimateBlockId = -1L;

    public FileUnderConstructionFeature(String clientName, String clientMachine, INode inode) {
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.inode = inode;
    }

    public String getClientName() {
        return this.clientName;
    }

    void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientMachine() {
        return this.clientMachine;
    }

    void updateLengthOfLastBlock(INodeFile f, long lastBlockLength) throws IOException {
        BlockInfo lastBlock = f.getLastBlock();
        assert (lastBlock != null) : "The last block for path " + f.getFullPathName() + " is null when updating its length";
        assert (lastBlock instanceof BlockInfoUnderConstruction) : "The last block for path " + f.getFullPathName() + " is not a BlockInfoUnderConstruction when updating its length";
        lastBlock.setNumBytes(lastBlockLength);
    }

    void cleanZeroSizeBlock(INodeFile f, INode.BlocksMapUpdateInfo collectedBlocks) throws IOException, StorageException, TransactionContextException {
        BlockInfoUnderConstruction lastUC;
        BlockInfo[] blocks = f.getBlocks();
        if (blocks != null && blocks.length > 0 && blocks[blocks.length - 1] instanceof BlockInfoUnderConstruction && (lastUC = (BlockInfoUnderConstruction)blocks[blocks.length - 1]).getNumBytes() == 0L) {
            collectedBlocks.addDeleteBlock(lastUC);
            f.removeLastBlock(lastUC);
        }
    }

    public void updateLastTwoBlocks(Lease lease) throws TransactionContextException, StorageException {
        this.updateLastTwoBlocks(lease, this.getFullPathName());
    }

    public void updateLastTwoBlocks(Lease lease, String src) throws TransactionContextException, StorageException {
        LeasePath lp = lease.getLeasePath(src);
        this.setLastBlockId(lp.getLastBlockId());
        this.setPenultimateBlockId(lp.getPenultimateBlockId());
    }

    private String getFullPathName() throws StorageException, TransactionContextException {
        return FSDirectory.getFullPathName(this.inode);
    }

    void setLastBlockId(long lastBlockId) {
        this.lastBlockId = lastBlockId;
    }

    void setPenultimateBlockId(long penultimateBlockId) {
        this.penultimateBlockId = penultimateBlockId;
    }

    public long getLastBlockId() {
        return this.lastBlockId;
    }

    public long getPenultimateBlockId() {
        return this.penultimateBlockId;
    }
}

