/*
 * Decompiled with CFR 0.152.
 */
package io.hops.erasure_coding;

import io.hops.erasure_coding.Codec;
import io.hops.erasure_coding.TooManyErasedLocations;
import java.util.ArrayList;
import java.util.List;

public abstract class ErasureCode {
    public abstract void encode(int[] var1, int[] var2);

    public abstract void decode(int[] var1, int[] var2, int[] var3);

    public abstract void decode(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    public List<Integer> locationsToReadForDecode(List<Integer> erasedLocations) throws TooManyErasedLocations {
        ArrayList<Integer> locationsToRead = new ArrayList<Integer>(this.stripeSize());
        int limit = this.stripeSize() + this.paritySize();
        for (int loc = limit - 1; loc >= 0; --loc) {
            if (erasedLocations.indexOf(loc) != -1) continue;
            locationsToRead.add(loc);
            if (this.stripeSize() == locationsToRead.size()) break;
        }
        if (locationsToRead.size() != this.stripeSize()) {
            String locationsStr = "";
            for (Integer erasedLocation : erasedLocations) {
                locationsStr = locationsStr + " " + erasedLocation;
            }
            throw new TooManyErasedLocations("Locations " + locationsStr);
        }
        return locationsToRead;
    }

    public abstract int stripeSize();

    public abstract int paritySize();

    public abstract void init(Codec var1);

    public abstract int symbolSize();

    public void encodeBulk(byte[][] inputs, byte[][] outputs) {
        int stripeSize = this.stripeSize();
        int paritySize = this.paritySize();
        assert (stripeSize == inputs.length);
        assert (paritySize == outputs.length);
        int[] data = new int[stripeSize];
        int[] code = new int[paritySize];
        for (int j = 0; j < outputs[0].length; ++j) {
            int i;
            for (i = 0; i < paritySize; ++i) {
                code[i] = 0;
            }
            for (i = 0; i < stripeSize; ++i) {
                data[i] = inputs[i][j] & 0xFF;
            }
            this.encode(data, code);
            for (i = 0; i < paritySize; ++i) {
                outputs[i][j] = (byte)code[i];
            }
        }
    }

    public void decodeBulk(byte[][] readBufs, byte[][] writeBufs, int[] erasedLocations, int[] locationsToRead, int[] locationsNotToRead) {
        int[] tmpInput = new int[readBufs.length];
        int[] tmpOutput = new int[erasedLocations.length];
        int numBytes = readBufs[0].length;
        for (int idx = 0; idx < numBytes; ++idx) {
            int i;
            for (i = 0; i < tmpOutput.length; ++i) {
                tmpOutput[i] = 0;
            }
            for (i = 0; i < tmpInput.length; ++i) {
                tmpInput[i] = readBufs[i][idx] & 0xFF;
            }
            this.decode(tmpInput, erasedLocations, tmpOutput, locationsToRead, locationsNotToRead);
            for (i = 0; i < tmpOutput.length; ++i) {
                writeBufs[i][idx] = (byte)tmpOutput[i];
            }
        }
    }
}

