/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.util.StringUtils;

final class INodesLocks
extends BaseINodeLock {
    private static final INodeIdentifier NON_EXISTING_INODE = new INodeIdentifier();
    private final TransactionLockTypes.INodeLockType lockType;
    private final List<INodeIdentifier> inodeIdentifiers;

    INodesLocks(TransactionLockTypes.INodeLockType lockType, List<INodeIdentifier> inodeIdentifiers) {
        this.lockType = lockType;
        this.inodeIdentifiers = inodeIdentifiers;
        if (lockType.equals((Object)TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT)) {
            throw new UnsupportedOperationException();
        }
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        if (this.inodeIdentifiers == null || this.inodeIdentifiers.isEmpty()) {
            return;
        }
        Collections.sort(this.inodeIdentifiers);
        for (INodeIdentifier inodeIdentifier : this.inodeIdentifiers) {
            this.setPartitioningKey(inodeIdentifier.getInodeId());
            INode inode = null;
            if (inodeIdentifier.getName() != null && inodeIdentifier.getPid() != null) {
                inode = this.find(this.lockType, inodeIdentifier.getName(), inodeIdentifier.getPid(), inodeIdentifier.getPartitionId(), inodeIdentifier.getInodeId());
            } else if (inodeIdentifier.getInodeId() != null) {
                inode = this.find(this.lockType, inodeIdentifier.getInodeId());
            } else {
                throw new StorageException("INodeIdentifier object is not properly initialized ");
            }
            this.addIndividualINode(inode);
        }
        this.acquireINodeAttributes();
    }

    public String toString() {
        if (this.lockType != null && this.inodeIdentifiers != null && !this.inodeIdentifiers.isEmpty()) {
            String ids = StringUtils.join((CharSequence)", ", this.inodeIdentifiers);
            return "InodesLocks = { identifiers: " + ids + " Lock: " + this.lockType + " }";
        }
        return "Individual Inode Lock not set";
    }
}

