/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.server.namenode.INode;

final class IndividualINodeLock
extends BaseINodeLock {
    private static final INodeIdentifier NON_EXISTING_INODE = new INodeIdentifier();
    private final TransactionLockTypes.INodeLockType lockType;
    private final INodeIdentifier inodeIdentifier;
    private final boolean readUpPathInodes;

    IndividualINodeLock(TransactionLockTypes.INodeLockType lockType, INodeIdentifier inodeIdentifier, boolean readUpPathInodes) {
        this.lockType = lockType;
        this.inodeIdentifier = inodeIdentifier == null ? NON_EXISTING_INODE : inodeIdentifier;
        this.readUpPathInodes = readUpPathInodes;
        if (lockType.equals((Object)TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT)) {
            throw new UnsupportedOperationException();
        }
    }

    IndividualINodeLock(TransactionLockTypes.INodeLockType lockType, INodeIdentifier inodeIdentifier) {
        this(lockType, inodeIdentifier, false);
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        this.setPartitioningKey(this.inodeIdentifier.getInodeId());
        INode inode = null;
        if (this.inodeIdentifier.getName() != null && this.inodeIdentifier.getPid() != null) {
            inode = this.find(this.lockType, this.inodeIdentifier.getName(), this.inodeIdentifier.getPid(), this.inodeIdentifier.getPartitionId(), this.inodeIdentifier.getInodeId());
        } else if (this.inodeIdentifier.getInodeId() != null) {
            inode = this.find(this.lockType, this.inodeIdentifier.getInodeId());
        } else {
            throw new StorageException("INodeIdentifier object is not properly initialized ");
        }
        if (this.readUpPathInodes && inode != null) {
            List<INode> pathInodes = this.readUpInodes(inode);
            this.addPathINodesAndUpdateResolvingCache(INodeUtil.constructPath(pathInodes), pathInodes);
        } else {
            this.addIndividualINode(inode);
        }
        this.acquireINodeAttributes();
    }

    public String toString() {
        if (this.lockType != null && this.inodeIdentifier != null) {
            return "Individual InodeLock = { ID: " + this.inodeIdentifier.getInodeId() + " Name: " + this.inodeIdentifier.getName() + " Lock: " + this.lockType + " }";
        }
        return "Individual Inode Lock not set";
    }
}

