/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class XAttr {
    private final NameSpace ns;
    private final String name;
    private final byte[] value;

    private XAttr(NameSpace ns, String name, byte[] value) {
        this.ns = ns;
        this.name = name;
        this.value = value;
    }

    public NameSpace getNameSpace() {
        return this.ns;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ns == null ? 0 : this.ns.hashCode());
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XAttr other = (XAttr)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.ns != other.ns) {
            return false;
        }
        return Arrays.equals(this.value, other.value);
    }

    public String toString() {
        return "XAttr [ns=" + (Object)((Object)this.ns) + ", name=" + this.name + ", value=" + Arrays.toString(this.value) + "]";
    }

    public static class Builder {
        private NameSpace ns = NameSpace.USER;
        private String name;
        private byte[] value;

        public Builder setNameSpace(NameSpace ns) {
            this.ns = ns;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setValue(byte[] value) {
            this.value = value;
            return this;
        }

        public XAttr build() {
            return new XAttr(this.ns, this.name, this.value);
        }
    }

    public static enum NameSpace {
        USER(0),
        TRUSTED(1),
        SECURITY(2),
        SYSTEM(3);

        private final byte ns;

        private NameSpace(byte ns) {
            this.ns = ns;
        }

        public byte getId() {
            return this.ns;
        }

        public static NameSpace valueOf(byte ns) {
            for (NameSpace nameSpace : NameSpace.values()) {
                if (nameSpace.getId() != ns) continue;
                return nameSpace;
            }
            return null;
        }
    }
}

