/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.protobuf.ByteString;
import com.google.protobuf.ServiceException;
import io.hops.leader_election.node.ActiveNode;
import io.hops.leader_election.node.ActiveNodePBImpl;
import io.hops.leader_election.node.SortedActiveNodeList;
import io.hops.leader_election.node.SortedActiveNodeListPBImpl;
import io.hops.leader_election.proto.ActiveNodeProtos;
import io.hops.metadata.hdfs.entity.EncodingPolicy;
import io.hops.metadata.hdfs.entity.EncodingStatus;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LastUpdatedContentSummary;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ClientNamenodeProtocolTranslatorPB
implements ProtocolMetaInterface,
ClientProtocol,
Closeable,
ProtocolTranslator {
    private final ClientNamenodeProtocolPB rpcProxy;
    static final ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto VOID_GET_SERVER_DEFAULT_REQUEST = ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetFsStatusRequestProto VOID_GET_FSSTATUS_REQUEST = ClientNamenodeProtocolProtos.GetFsStatusRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.RefreshNodesRequestProto VOID_REFRESH_NODES_REQUEST = ClientNamenodeProtocolProtos.RefreshNodesRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto VOID_GET_DATA_ENCRYPTIONKEY_REQUEST = ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto.newBuilder().build();
    private static final ClientNamenodeProtocolProtos.GetStoragePoliciesRequestProto VOID_GET_STORAGE_POLICIES_REQUEST = ClientNamenodeProtocolProtos.GetStoragePoliciesRequestProto.newBuilder().build();

    public ClientNamenodeProtocolTranslatorPB(ClientNamenodeProtocolPB proxy) {
        this.rpcProxy = proxy;
    }

    @Override
    public void close() {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    @Override
    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto req = ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto.newBuilder().setSrc(src).setOffset(offset).setLength(length).build();
        try {
            ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto resp = this.rpcProxy.getBlockLocations(null, req);
            return resp.hasLocations() ? PBHelper.convert(resp.getLocations()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public LocatedBlocks getMissingBlockLocations(String filePath) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetMissingBlockLocationsRequestProto req = ClientNamenodeProtocolProtos.GetMissingBlockLocationsRequestProto.newBuilder().setFilePath(filePath).build();
        try {
            ClientNamenodeProtocolProtos.GetMissingBlockLocationsResponseProto resp = this.rpcProxy.getMissingBlockLocations(null, req);
            return resp.hasLocations() ? PBHelper.convert(resp.getLocations()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void addBlockChecksum(String src, int blockIndex, long checksum) throws IOException {
        ClientNamenodeProtocolProtos.AddBlockChecksumRequestProto req = ClientNamenodeProtocolProtos.AddBlockChecksumRequestProto.newBuilder().setSrc(src).setBlockIndex(blockIndex).setChecksum(checksum).build();
        try {
            this.rpcProxy.addBlockChecksum(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public long getBlockChecksum(String src, int blockIndex) throws IOException {
        ClientNamenodeProtocolProtos.GetBlockChecksumRequestProto req = ClientNamenodeProtocolProtos.GetBlockChecksumRequestProto.newBuilder().setSrc(src).setBlockIndex(blockIndex).build();
        try {
            ClientNamenodeProtocolProtos.GetBlockChecksumResponseProto resp = this.rpcProxy.getBlockChecksum(null, req);
            return resp.getChecksum();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto req = VOID_GET_SERVER_DEFAULT_REQUEST;
        try {
            return PBHelper.convert(this.rpcProxy.getServerDefaults(null, req).getServerDefaults());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize) throws AccessControlException, AlreadyBeingCreatedException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        return this.create(src, masked, clientName, flag, createParent, replication, blockSize, null);
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, EncodingPolicy policy) throws AccessControlException, AlreadyBeingCreatedException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.CreateRequestProto.Builder builder = ClientNamenodeProtocolProtos.CreateRequestProto.newBuilder().setSrc(src).setMasked(PBHelper.convert(masked)).setClientName(clientName).setCreateFlag(PBHelper.convertCreateFlag(flag)).setCreateParent(createParent).setReplication(replication).setBlockSize(blockSize);
        if (policy != null) {
            builder.setPolicy(PBHelper.convert(policy));
        }
        ClientNamenodeProtocolProtos.CreateRequestProto req = builder.build();
        try {
            ClientNamenodeProtocolProtos.CreateResponseProto result = this.rpcProxy.create(null, req);
            return result.hasFs() ? PBHelper.convert(result.getFs()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean truncate(String src, long newLength, String clientName) throws IOException, UnresolvedLinkException {
        ClientNamenodeProtocolProtos.TruncateRequestProto req = ClientNamenodeProtocolProtos.TruncateRequestProto.newBuilder().setSrc(src).setNewLength(newLength).setClientName(clientName).build();
        try {
            return this.rpcProxy.truncate(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.AppendRequestProto req = ClientNamenodeProtocolProtos.AppendRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFlag(PBHelper.convertCreateFlag(flag)).build();
        try {
            ClientNamenodeProtocolProtos.AppendResponseProto res = this.rpcProxy.append(null, req);
            LocatedBlock lastBlock = res.hasBlock() ? PBHelper.convert(res.getBlock()) : null;
            HdfsFileStatus stat = res.hasStat() ? PBHelper.convert(res.getStat()) : null;
            return new LastBlockWithStatus(lastBlock, stat);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean setReplication(String src, short replication) throws AccessControlException, DSQuotaExceededException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetReplicationRequestProto req = ClientNamenodeProtocolProtos.SetReplicationRequestProto.newBuilder().setSrc(src).setReplication(replication).build();
        try {
            return this.rpcProxy.setReplication(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public BlockStoragePolicy getStoragePolicy(byte storagePolicyID) throws IOException {
        try {
            ClientNamenodeProtocolProtos.GetStoragePolicyRequestProto req = ClientNamenodeProtocolProtos.GetStoragePolicyRequestProto.newBuilder().setStoragePolicyID(storagePolicyID).build();
            ClientNamenodeProtocolProtos.GetStoragePolicyResponseProto response = this.rpcProxy.getStoragePolicy(null, req);
            return PBHelper.convert(response.getPolicy());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        try {
            ClientNamenodeProtocolProtos.GetStoragePoliciesResponseProto response = this.rpcProxy.getStoragePolicies(null, VOID_GET_STORAGE_POLICIES_REQUEST);
            return PBHelper.convertStoragePolicies(response.getPoliciesList());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void setStoragePolicy(String src, String policyName) throws UnresolvedLinkException, FileNotFoundException, QuotaExceededException, IOException {
        ClientNamenodeProtocolProtos.SetStoragePolicyRequestProto req = ClientNamenodeProtocolProtos.SetStoragePolicyRequestProto.newBuilder().setSrc(src).setPolicyName(policyName).build();
        try {
            this.rpcProxy.setStoragePolicy(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void setMetaEnabled(String src, boolean metaEnabled) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetMetaEnabledRequestProto req = ClientNamenodeProtocolProtos.SetMetaEnabledRequestProto.newBuilder().setSrc(src).setMetaEnabled(metaEnabled).build();
        try {
            this.rpcProxy.setMetaEnabled(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void setPermission(String src, FsPermission permission) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetPermissionRequestProto req = ClientNamenodeProtocolProtos.SetPermissionRequestProto.newBuilder().setSrc(src).setPermission(PBHelper.convert(permission)).build();
        try {
            this.rpcProxy.setPermission(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void setOwner(String src, String username, String groupname) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetOwnerRequestProto.Builder req = ClientNamenodeProtocolProtos.SetOwnerRequestProto.newBuilder().setSrc(src);
        if (username != null) {
            req.setUsername(username);
        }
        if (groupname != null) {
            req.setGroupname(groupname);
        }
        try {
            this.rpcProxy.setOwner(null, req.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.AbandonBlockRequestProto req = ClientNamenodeProtocolProtos.AbandonBlockRequestProto.newBuilder().setB(PBHelper.convert(b)).setSrc(src).setHolder(holder).setFileId(fileId).build();
        try {
            this.rpcProxy.abandonBlock(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludeNodes, long fileId, String[] favoredNodes) throws AccessControlException, FileNotFoundException, NotReplicatedYetException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.AddBlockRequestProto.Builder req = ClientNamenodeProtocolProtos.AddBlockRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFileId(fileId);
        if (previous != null) {
            req.setPrevious(PBHelper.convert(previous));
        }
        if (excludeNodes != null) {
            req.addAllExcludeNodes(PBHelper.convert(excludeNodes));
        }
        if (favoredNodes != null) {
            req.addAllFavoredNodes(Arrays.asList(favoredNodes));
        }
        try {
            return PBHelper.convert(this.rpcProxy.addBlock(null, req.build()).getBlock());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto req = ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto.newBuilder().setSrc(src).setFileId(fileId).setBlk(PBHelper.convert(blk)).addAllExistings(PBHelper.convert(existings)).addAllExistingStorageUuids(Arrays.asList(existingStorageIDs)).addAllExcludes(PBHelper.convert(excludes)).setNumAdditionalNodes(numAdditionalNodes).setClientName(clientName).build();
        try {
            return PBHelper.convert(this.rpcProxy.getAdditionalDatanode(null, req).getBlock());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId, byte[] data) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.CompleteRequestProto.Builder req = ClientNamenodeProtocolProtos.CompleteRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFileId(fileId);
        if (last != null) {
            req.setLast(PBHelper.convert(last));
        }
        if (data != null) {
            req.setData(ByteString.copyFrom((byte[])data));
        }
        try {
            return this.rpcProxy.complete(null, req.build()).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto req = ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto.newBuilder().addAllBlocks(Arrays.asList(PBHelper.convertLocatedBlock(blocks))).build();
        try {
            this.rpcProxy.reportBadBlocks(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean rename(String src, String dst) throws UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.RenameRequestProto req = ClientNamenodeProtocolProtos.RenameRequestProto.newBuilder().setSrc(src).setDst(dst).build();
        try {
            return this.rpcProxy.rename(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws AccessControlException, DSQuotaExceededException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        boolean overwrite = false;
        boolean keepEncodingStatus = false;
        if (options != null) {
            for (Options.Rename option : options) {
                if (option == Options.Rename.OVERWRITE) {
                    overwrite = true;
                }
                if (option != Options.Rename.KEEP_ENCODING_STATUS) continue;
                keepEncodingStatus = true;
            }
        }
        ClientNamenodeProtocolProtos.Rename2RequestProto req = ClientNamenodeProtocolProtos.Rename2RequestProto.newBuilder().setSrc(src).setDst(dst).setOverwriteDest(overwrite).setKeepEncodingStatus(keepEncodingStatus).build();
        try {
            this.rpcProxy.rename2(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void concat(String trg, String[] srcs) throws IOException, UnresolvedLinkException {
        ClientNamenodeProtocolProtos.ConcatRequestProto req = ClientNamenodeProtocolProtos.ConcatRequestProto.newBuilder().setTrg(trg).addAllSrcs(Arrays.asList(srcs)).build();
        try {
            this.rpcProxy.concat(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean delete(String src, boolean recursive) throws AccessControlException, FileNotFoundException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.DeleteRequestProto req = ClientNamenodeProtocolProtos.DeleteRequestProto.newBuilder().setSrc(src).setRecursive(recursive).build();
        try {
            return this.rpcProxy.delete(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, NSQuotaExceededException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.MkdirsRequestProto req = ClientNamenodeProtocolProtos.MkdirsRequestProto.newBuilder().setSrc(src).setMasked(PBHelper.convert(masked)).setCreateParent(createParent).build();
        try {
            return this.rpcProxy.mkdirs(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetListingRequestProto req = ClientNamenodeProtocolProtos.GetListingRequestProto.newBuilder().setSrc(src).setStartAfter(ByteString.copyFrom((byte[])startAfter)).setNeedLocation(needLocation).build();
        try {
            ClientNamenodeProtocolProtos.GetListingResponseProto result = this.rpcProxy.getListing(null, req);
            if (result.hasDirList()) {
                return PBHelper.convert(result.getDirList());
            }
            return null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void renewLease(String clientName) throws AccessControlException, IOException {
        ClientNamenodeProtocolProtos.RenewLeaseRequestProto req = ClientNamenodeProtocolProtos.RenewLeaseRequestProto.newBuilder().setClientName(clientName).build();
        try {
            this.rpcProxy.renewLease(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        ClientNamenodeProtocolProtos.RecoverLeaseRequestProto req = ClientNamenodeProtocolProtos.RecoverLeaseRequestProto.newBuilder().setSrc(src).setClientName(clientName).build();
        try {
            return this.rpcProxy.recoverLease(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public long[] getStats() throws IOException {
        try {
            return PBHelper.convert(this.rpcProxy.getFsStats(null, VOID_GET_FSSTATUS_REQUEST));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto req = ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto.newBuilder().setType(PBHelper.convert(type)).build();
        try {
            return PBHelper.convert(this.rpcProxy.getDatanodeReport(null, req).getDiList());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        ClientNamenodeProtocolProtos.GetDatanodeStorageReportRequestProto req = ClientNamenodeProtocolProtos.GetDatanodeStorageReportRequestProto.newBuilder().setType(PBHelper.convert(type)).build();
        try {
            return PBHelper.convertDatanodeStorageReports(this.rpcProxy.getDatanodeStorageReport(null, req).getDatanodeStorageReportsList());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public long getPreferredBlockSize(String filename) throws IOException {
        ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto req = ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto.newBuilder().setFilename(filename).build();
        try {
            return this.rpcProxy.getPreferredBlockSize(null, req).getBsize();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        ClientNamenodeProtocolProtos.SetSafeModeRequestProto req = ClientNamenodeProtocolProtos.SetSafeModeRequestProto.newBuilder().setAction(PBHelper.convert(action)).setChecked(isChecked).build();
        try {
            return this.rpcProxy.setSafeMode(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void refreshNodes() throws IOException {
        try {
            this.rpcProxy.refreshNodes(null, VOID_REFRESH_NODES_REQUEST);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        ClientNamenodeProtocolProtos.RollingUpgradeRequestProto r = ClientNamenodeProtocolProtos.RollingUpgradeRequestProto.newBuilder().setAction(PBHelper.convert(action)).build();
        try {
            ClientNamenodeProtocolProtos.RollingUpgradeResponseProto proto = this.rpcProxy.rollingUpgrade(null, r);
            if (proto.hasRollingUpgradeInfo()) {
                return PBHelper.convert(proto.getRollingUpgradeInfo());
            }
            return null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto.Builder req = ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto.newBuilder().setPath(path);
        if (cookie != null) {
            req.setCookie(cookie);
        }
        try {
            return PBHelper.convert(this.rpcProxy.listCorruptFileBlocks(null, req.build()).getCorrupt());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetFileInfoRequestProto req = ClientNamenodeProtocolProtos.GetFileInfoRequestProto.newBuilder().setSrc(src).build();
        try {
            ClientNamenodeProtocolProtos.GetFileInfoResponseProto res = this.rpcProxy.getFileInfo(null, req);
            return res.hasFs() ? PBHelper.convert(res.getFs()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public HdfsFileStatus getFileLinkInfo(String src) throws AccessControlException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto req = ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto.newBuilder().setSrc(src).build();
        try {
            ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto result = this.rpcProxy.getFileLinkInfo(null, req);
            return result.hasFs() ? PBHelper.convert(this.rpcProxy.getFileLinkInfo(null, req).getFs()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public ContentSummary getContentSummary(String path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetContentSummaryRequestProto req = ClientNamenodeProtocolProtos.GetContentSummaryRequestProto.newBuilder().setPath(path).build();
        try {
            return PBHelper.convert(this.rpcProxy.getContentSummary(null, req).getSummary());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetQuotaRequestProto.Builder builder = ClientNamenodeProtocolProtos.SetQuotaRequestProto.newBuilder().setPath(path).setNamespaceQuota(namespaceQuota).setStoragespaceQuota(storagespaceQuota);
        if (type != null) {
            builder.setStorageType(PBHelper.convertStorageType(type));
        }
        ClientNamenodeProtocolProtos.SetQuotaRequestProto req = builder.build();
        try {
            this.rpcProxy.setQuota(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void fsync(String src, long fileId, String client, long lastBlockLength) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.FsyncRequestProto req = ClientNamenodeProtocolProtos.FsyncRequestProto.newBuilder().setSrc(src).setClient(client).setLastBlockLength(lastBlockLength).setFileId(fileId).build();
        try {
            this.rpcProxy.fsync(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void setTimes(String src, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.SetTimesRequestProto req = ClientNamenodeProtocolProtos.SetTimesRequestProto.newBuilder().setSrc(src).setMtime(mtime).setAtime(atime).build();
        try {
            this.rpcProxy.setTimes(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void createSymlink(String target, String link, FsPermission dirPerm, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, SafeModeException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.CreateSymlinkRequestProto req = ClientNamenodeProtocolProtos.CreateSymlinkRequestProto.newBuilder().setTarget(target).setLink(link).setDirPerm(PBHelper.convert(dirPerm)).setCreateParent(createParent).build();
        try {
            this.rpcProxy.createSymlink(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public String getLinkTarget(String path) throws AccessControlException, FileNotFoundException, IOException {
        ClientNamenodeProtocolProtos.GetLinkTargetRequestProto req = ClientNamenodeProtocolProtos.GetLinkTargetRequestProto.newBuilder().setPath(path).build();
        try {
            ClientNamenodeProtocolProtos.GetLinkTargetResponseProto rsp = this.rpcProxy.getLinkTarget(null, req);
            return rsp.hasTargetPath() ? rsp.getTargetPath() : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto req = ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto.newBuilder().setBlock(PBHelper.convert(block)).setClientName(clientName).build();
        try {
            return PBHelper.convert(this.rpcProxy.updateBlockForPipeline(null, req).getBlock());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] storageIDs) throws IOException {
        ClientNamenodeProtocolProtos.UpdatePipelineRequestProto req = ClientNamenodeProtocolProtos.UpdatePipelineRequestProto.newBuilder().setClientName(clientName).setOldBlock(PBHelper.convert(oldBlock)).setNewBlock(PBHelper.convert(newBlock)).addAllNewNodes(Arrays.asList(PBHelper.convert(newNodes))).addAllStorageIDs(storageIDs == null ? null : Arrays.asList(storageIDs)).build();
        try {
            this.rpcProxy.updatePipeline(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        SecurityProtos.GetDelegationTokenRequestProto req = SecurityProtos.GetDelegationTokenRequestProto.newBuilder().setRenewer(renewer.toString()).build();
        try {
            SecurityProtos.GetDelegationTokenResponseProto resp = this.rpcProxy.getDelegationToken(null, req);
            return resp.hasToken() ? PBHelper.convertDelegationToken(resp.getToken()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        SecurityProtos.RenewDelegationTokenRequestProto req = SecurityProtos.RenewDelegationTokenRequestProto.newBuilder().setToken(PBHelper.convert(token)).build();
        try {
            return this.rpcProxy.renewDelegationToken(null, req).getNewExpiryTime();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        SecurityProtos.CancelDelegationTokenRequestProto req = SecurityProtos.CancelDelegationTokenRequestProto.newBuilder().setToken(PBHelper.convert(token)).build();
        try {
            this.rpcProxy.cancelDelegationToken(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto req = ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto.newBuilder().setBandwidth(bandwidth).build();
        try {
            this.rpcProxy.setBalancerBandwidth(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, ClientNamenodeProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(ClientNamenodeProtocolPB.class), (String)methodName);
    }

    @Override
    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        try {
            ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto rsp = this.rpcProxy.getDataEncryptionKey(null, VOID_GET_DATA_ENCRYPTIONKEY_REQUEST);
            return rsp.hasDataEncryptionKey() ? PBHelper.convert(rsp.getDataEncryptionKey()) : null;
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public boolean isFileClosed(String src) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.IsFileClosedRequestProto req = ClientNamenodeProtocolProtos.IsFileClosedRequestProto.newBuilder().setSrc(src).build();
        try {
            return this.rpcProxy.isFileClosed(null, req).getResult();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void ping() throws IOException {
        try {
            ClientNamenodeProtocolProtos.PingRequestProto pingRequestProto = ClientNamenodeProtocolProtos.PingRequestProto.newBuilder().build();
            this.rpcProxy.ping(null, pingRequestProto);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public SortedActiveNodeList getActiveNamenodesForClient() throws IOException {
        try {
            ClientNamenodeProtocolProtos.ActiveNamenodeListRequestProto.Builder request = ClientNamenodeProtocolProtos.ActiveNamenodeListRequestProto.newBuilder();
            ClientNamenodeProtocolProtos.ActiveNamenodeListResponseProto response = this.rpcProxy.getActiveNamenodesForClient(null, request.build());
            SortedActiveNodeList anl = this.convertProtoANListToANList(response);
            return anl;
        }
        catch (ServiceException se) {
            throw ProtobufHelper.getRemoteException((ServiceException)se);
        }
    }

    @Override
    public EncodingStatus getEncodingStatus(String filePath) throws IOException {
        try {
            ClientNamenodeProtocolProtos.GetEncodingStatusRequestProto request = ClientNamenodeProtocolProtos.GetEncodingStatusRequestProto.newBuilder().setPath(filePath).build();
            return PBHelper.convert(this.rpcProxy.getEncodingStatus(null, request).getEncodingStatus());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void encodeFile(String filePath, EncodingPolicy policy) throws IOException {
        try {
            ClientNamenodeProtocolProtos.EncodeFileRequestProto request = ClientNamenodeProtocolProtos.EncodeFileRequestProto.newBuilder().setPath(filePath).setPolicy(PBHelper.convert(policy)).build();
            this.rpcProxy.encodeFile(null, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public LocatedBlock getRepairedBlockLocations(String sourcePath, String parityPath, LocatedBlock block, boolean isParity) throws IOException {
        ClientNamenodeProtocolProtos.GetRepairedBlockLocationsRequsestProto request = ClientNamenodeProtocolProtos.GetRepairedBlockLocationsRequsestProto.newBuilder().setSourcePath(sourcePath).setParityPath(parityPath).setIsParity(isParity).setBlock(PBHelper.convert(block)).build();
        try {
            return PBHelper.convert(this.rpcProxy.getRepairedBlockLocations(null, request).getLocatedBlocks());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void revokeEncoding(String filePath, short replication) throws IOException {
        try {
            ClientNamenodeProtocolProtos.RevokeEncodingRequestProto request = ClientNamenodeProtocolProtos.RevokeEncodingRequestProto.newBuilder().setPath(filePath).setReplication(replication).build();
            this.rpcProxy.revokeEncoding(null, request);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    private SortedActiveNodeList convertProtoANListToANList(ClientNamenodeProtocolProtos.ActiveNamenodeListResponseProto p) {
        ArrayList<ActiveNode> anl = new ArrayList<ActiveNode>();
        List<ActiveNodeProtos.ActiveNodeProto> anlp = p.getNamenodesList();
        for (ActiveNodeProtos.ActiveNodeProto anAnlp : anlp) {
            ActiveNode an = this.convertProtoANToAN(anAnlp);
            anl.add(an);
        }
        return new SortedActiveNodeListPBImpl(anl);
    }

    private ActiveNode convertProtoANToAN(ActiveNodeProtos.ActiveNodeProto p) {
        ActiveNodePBImpl an = new ActiveNodePBImpl(p.getId(), p.getRpcHostname(), p.getRpcIpAddress(), p.getRpcPort(), p.getHttpAddress(), p.getServiceIpAddress(), p.getServicePort(), p.getLocationDomainId());
        return an;
    }

    @Override
    public void changeConf(List<String> props, List<String> newVals) throws IOException {
        try {
            ClientNamenodeProtocolProtos.ChangeConfProto.Builder req = ClientNamenodeProtocolProtos.ChangeConfProto.newBuilder();
            req.addAllProps(props);
            req.addAllNewVals(newVals);
            this.rpcProxy.changeConf(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void checkAccess(String path, FsAction mode) throws IOException {
        ClientNamenodeProtocolProtos.CheckAccessRequestProto req = ClientNamenodeProtocolProtos.CheckAccessRequestProto.newBuilder().setPath(path).setMode(PBHelper.convert(mode)).build();
        try {
            this.rpcProxy.checkAccess(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public LastUpdatedContentSummary getLastUpdatedContentSummary(String path) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        ClientNamenodeProtocolProtos.GetLastUpdatedContentSummaryRequestProto req = ClientNamenodeProtocolProtos.GetLastUpdatedContentSummaryRequestProto.newBuilder().setPath(path).build();
        try {
            return PBHelper.convert(this.rpcProxy.getLastUpdatedContentSummary(null, req).getSummary());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        AclProtos.ModifyAclEntriesRequestProto req = AclProtos.ModifyAclEntriesRequestProto.newBuilder().setSrc(src).addAllAclSpec(PBHelper.convertAclEntryProto(aclSpec)).build();
        try {
            this.rpcProxy.modifyAclEntries(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        AclProtos.RemoveAclEntriesRequestProto req = AclProtos.RemoveAclEntriesRequestProto.newBuilder().setSrc(src).addAllAclSpec(PBHelper.convertAclEntryProto(aclSpec)).build();
        try {
            this.rpcProxy.removeAclEntries(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void removeDefaultAcl(String src) throws IOException {
        AclProtos.RemoveDefaultAclRequestProto req = AclProtos.RemoveDefaultAclRequestProto.newBuilder().setSrc(src).build();
        try {
            this.rpcProxy.removeDefaultAcl(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void removeAcl(String src) throws IOException {
        AclProtos.RemoveAclRequestProto req = AclProtos.RemoveAclRequestProto.newBuilder().setSrc(src).build();
        try {
            this.rpcProxy.removeAcl(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        AclProtos.SetAclRequestProto req = AclProtos.SetAclRequestProto.newBuilder().setSrc(src).addAllAclSpec(PBHelper.convertAclEntryProto(aclSpec)).build();
        try {
            this.rpcProxy.setAcl(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public AclStatus getAclStatus(String src) throws IOException {
        AclProtos.GetAclStatusRequestProto req = AclProtos.GetAclStatusRequestProto.newBuilder().setSrc(src).build();
        try {
            return PBHelper.convert(this.rpcProxy.getAclStatus(null, req));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public long addCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        try {
            ClientNamenodeProtocolProtos.AddCacheDirectiveRequestProto.Builder builder = ClientNamenodeProtocolProtos.AddCacheDirectiveRequestProto.newBuilder().setInfo(PBHelper.convert(directive));
            if (!flags.isEmpty()) {
                builder.setCacheFlags(PBHelper.convertCacheFlags(flags));
            }
            return this.rpcProxy.addCacheDirective(null, builder.build()).getId();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        try {
            ClientNamenodeProtocolProtos.ModifyCacheDirectiveRequestProto.Builder builder = ClientNamenodeProtocolProtos.ModifyCacheDirectiveRequestProto.newBuilder().setInfo(PBHelper.convert(directive));
            if (!flags.isEmpty()) {
                builder.setCacheFlags(PBHelper.convertCacheFlags(flags));
            }
            this.rpcProxy.modifyCacheDirective(null, builder.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void removeCacheDirective(long id) throws IOException {
        try {
            this.rpcProxy.removeCacheDirective(null, ClientNamenodeProtocolProtos.RemoveCacheDirectiveRequestProto.newBuilder().setId(id).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        try {
            return new BatchedCacheEntries(this.rpcProxy.listCacheDirectives(null, ClientNamenodeProtocolProtos.ListCacheDirectivesRequestProto.newBuilder().setPrevId(prevId).setFilter(PBHelper.convert(filter)).build()));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void addCachePool(CachePoolInfo info) throws IOException {
        ClientNamenodeProtocolProtos.AddCachePoolRequestProto.Builder builder = ClientNamenodeProtocolProtos.AddCachePoolRequestProto.newBuilder();
        builder.setInfo(PBHelper.convert(info));
        try {
            this.rpcProxy.addCachePool(null, builder.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void modifyCachePool(CachePoolInfo req) throws IOException {
        ClientNamenodeProtocolProtos.ModifyCachePoolRequestProto.Builder builder = ClientNamenodeProtocolProtos.ModifyCachePoolRequestProto.newBuilder();
        builder.setInfo(PBHelper.convert(req));
        try {
            this.rpcProxy.modifyCachePool(null, builder.build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void removeCachePool(String cachePoolName) throws IOException {
        try {
            this.rpcProxy.removeCachePool(null, ClientNamenodeProtocolProtos.RemoveCachePoolRequestProto.newBuilder().setPoolName(cachePoolName).build());
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        try {
            return new BatchedCachePoolEntries(this.rpcProxy.listCachePools(null, ClientNamenodeProtocolProtos.ListCachePoolsRequestProto.newBuilder().setPrevPoolName(prevKey).build()));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void addUser(String userName) throws IOException {
        try {
            ClientNamenodeProtocolProtos.AddUserRequestProto.Builder req = ClientNamenodeProtocolProtos.AddUserRequestProto.newBuilder();
            if (userName != null) {
                req.setUserName(userName);
            }
            this.rpcProxy.addUser(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void addGroup(String groupName) throws IOException {
        try {
            ClientNamenodeProtocolProtos.AddGroupRequestProto.Builder req = ClientNamenodeProtocolProtos.AddGroupRequestProto.newBuilder();
            if (groupName != null) {
                req.setGroupName(groupName);
            }
            this.rpcProxy.addGroup(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void addUserToGroup(String userName, String groupName) throws IOException {
        try {
            ClientNamenodeProtocolProtos.AddUserToGroupRequestProto.Builder req = ClientNamenodeProtocolProtos.AddUserToGroupRequestProto.newBuilder();
            if (userName != null) {
                req.setUserName(userName);
            }
            if (groupName != null) {
                req.setGroupName(groupName);
            }
            this.rpcProxy.addUserToGroup(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void removeUser(String userName) throws IOException {
        try {
            ClientNamenodeProtocolProtos.RemoveUserRequestProto.Builder req = ClientNamenodeProtocolProtos.RemoveUserRequestProto.newBuilder();
            if (userName != null) {
                req.setUserName(userName);
            }
            this.rpcProxy.removeUser(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void removeGroup(String groupName) throws IOException {
        try {
            ClientNamenodeProtocolProtos.RemoveGroupRequestProto.Builder req = ClientNamenodeProtocolProtos.RemoveGroupRequestProto.newBuilder();
            if (groupName != null) {
                req.setGroupName(groupName);
            }
            this.rpcProxy.removeGroup(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void removeUserFromGroup(String userName, String groupName) throws IOException {
        try {
            ClientNamenodeProtocolProtos.RemoveUserFromGroupRequestProto.Builder req = ClientNamenodeProtocolProtos.RemoveUserFromGroupRequestProto.newBuilder();
            if (userName != null) {
                req.setUserName(userName);
            }
            if (groupName != null) {
                req.setGroupName(groupName);
            }
            this.rpcProxy.removeUserFromGroup(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void invCachesUserRemoved(String userName) throws IOException {
        try {
            ClientNamenodeProtocolProtos.InvCachesUserRemovedRequestProto.Builder req = ClientNamenodeProtocolProtos.InvCachesUserRemovedRequestProto.newBuilder();
            if (userName != null) {
                req.setUserName(userName);
            }
            this.rpcProxy.invCachesUserRemoved(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void invCachesGroupRemoved(String groupName) throws IOException {
        try {
            ClientNamenodeProtocolProtos.InvCachesGroupRemovedRequestProto.Builder req = ClientNamenodeProtocolProtos.InvCachesGroupRemovedRequestProto.newBuilder();
            if (groupName != null) {
                req.setGroupName(groupName);
            }
            this.rpcProxy.invCachesGroupRemoved(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void invCachesUserRemovedFromGroup(String userName, String groupName) throws IOException {
        try {
            ClientNamenodeProtocolProtos.InvCachesUserRemovedFromGroupRequestProto.Builder req = ClientNamenodeProtocolProtos.InvCachesUserRemovedFromGroupRequestProto.newBuilder();
            if (userName != null) {
                req.setUserName(userName);
            }
            if (groupName != null) {
                req.setGroupName(groupName);
            }
            this.rpcProxy.invCachesUserRemovedFromGroup(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void invCachesUserAddedToGroup(String userName, String groupName) throws IOException {
        try {
            ClientNamenodeProtocolProtos.InvCachesUserAddedToGroupRequestProto.Builder req = ClientNamenodeProtocolProtos.InvCachesUserAddedToGroupRequestProto.newBuilder();
            if (userName != null) {
                req.setUserName(userName);
            }
            if (groupName != null) {
                req.setGroupName(groupName);
            }
            this.rpcProxy.invCachesUserAddedToGroup(null, req.build());
        }
        catch (ServiceException ex) {
            throw ProtobufHelper.getRemoteException((ServiceException)ex);
        }
    }

    @Override
    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        XAttrProtos.SetXAttrRequestProto req = XAttrProtos.SetXAttrRequestProto.newBuilder().setSrc(src).setXAttr(PBHelper.convertXAttrProto(xAttr)).setFlag(PBHelper.convert(flag)).build();
        try {
            this.rpcProxy.setXAttr(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        XAttrProtos.GetXAttrsRequestProto.Builder builder = XAttrProtos.GetXAttrsRequestProto.newBuilder();
        builder.setSrc(src);
        if (xAttrs != null) {
            builder.addAllXAttrs(PBHelper.convertXAttrProto(xAttrs));
        }
        XAttrProtos.GetXAttrsRequestProto req = builder.build();
        try {
            return PBHelper.convert(this.rpcProxy.getXAttrs(null, req));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        XAttrProtos.RemoveXAttrRequestProto req = XAttrProtos.RemoveXAttrRequestProto.newBuilder().setSrc(src).setXAttr(PBHelper.convertXAttrProto(xAttr)).build();
        try {
            this.rpcProxy.removeXAttr(null, req);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    private static class BatchedCachePoolEntries
    implements BatchedRemoteIterator.BatchedEntries<CachePoolEntry> {
        private final ClientNamenodeProtocolProtos.ListCachePoolsResponseProto proto;

        public BatchedCachePoolEntries(ClientNamenodeProtocolProtos.ListCachePoolsResponseProto proto) {
            this.proto = proto;
        }

        public CachePoolEntry get(int i) {
            ClientNamenodeProtocolProtos.CachePoolEntryProto elem = this.proto.getEntries(i);
            return PBHelper.convert(elem);
        }

        public int size() {
            return this.proto.getEntriesCount();
        }

        public boolean hasMore() {
            return this.proto.getHasMore();
        }
    }

    private static class BatchedCacheEntries
    implements BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> {
        private ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto response;

        BatchedCacheEntries(ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto response) {
            this.response = response;
        }

        public CacheDirectiveEntry get(int i) {
            return PBHelper.convert(this.response.getElements(i));
        }

        public int size() {
            return this.response.getElementsCount();
        }

        public boolean hasMore() {
            return this.response.getHasMore();
        }
    }
}

