/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.common.IDsGeneratorFactory;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.Time;

class FSDirMkdirOp {
    FSDirMkdirOp() {
    }

    static HdfsFileStatus mkdirs(final FSNamesystem fsn, String srcArg, final PermissionStatus permissions, final boolean createParent) throws IOException {
        final FSDirectory fsd = fsn.getFSDirectory();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("DIR* NameSystem.mkdirs: " + srcArg);
        }
        if (!DFSUtil.isValidName(srcArg)) {
            throw new InvalidPathException(srcArg);
        }
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(srcArg, pathComponents);
        HopsTransactionalRequestHandler mkdirsHandler = new HopsTransactionalRequestHandler(HDFSOperationType.MKDIRS, src){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE_ON_TARGET_AND_PARENT, TransactionLockTypes.INodeResolveType.PATH, src).resolveSymLink(false).setNameNodeID(fsn.getNamenodeId()).setActiveNameNodes(fsn.getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(!fsd.isQuotaEnabled());
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                INodesInPath existing;
                INode lastINode;
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath4Write(src);
                if (fsd.isPermissionEnabled()) {
                    fsd.checkTraverse(pc, iip);
                }
                if ((lastINode = iip.getLastINode()) != null && lastINode.isFile()) {
                    throw new FileAlreadyExistsException("Path is not a directory: " + src);
                }
                INodesInPath iNodesInPath = existing = lastINode != null ? iip : iip.getExistingINodes();
                if (lastINode == null) {
                    List<String> ancestors;
                    if (fsd.isPermissionEnabled()) {
                        fsd.checkAncestorAccess(pc, iip, FsAction.WRITE);
                    }
                    if (!createParent) {
                        fsd.verifyParentDir(iip, src);
                    }
                    fsn.checkFsObjectLimit();
                    List<String> nonExisting = iip.getPath(existing.length(), iip.length() - existing.length());
                    int length = nonExisting.size();
                    if (length > 1 && (existing = FSDirMkdirOp.createChildrenDirectories(fsd, existing, ancestors = nonExisting.subList(0, length - 1), FSDirMkdirOp.addImplicitUwx(permissions, permissions))) == null) {
                        throw new IOException("Failed to create directory: " + src);
                    }
                    if ((existing = FSDirMkdirOp.createChildrenDirectories(fsd, existing, nonExisting.subList(length - 1, length), permissions)) == null) {
                        throw new IOException("Failed to create directory: " + src);
                    }
                }
                return fsd.getAuditFileInfo(iip);
            }
        };
        return (HdfsFileStatus)mkdirsHandler.handle();
    }

    static Map.Entry<INodesInPath, String> createAncestorDirectories(FSDirectory fsd, INodesInPath iip, PermissionStatus permission) throws IOException {
        INode parentINode;
        List<String> directories;
        String last = new String(iip.getLastLocalName(), Charsets.UTF_8);
        INodesInPath existing = iip.getExistingINodes();
        List<String> children = iip.getPath(existing.length(), iip.length() - existing.length());
        int size = children.size();
        if (size > 1 && (existing = FSDirMkdirOp.createChildrenDirectories(fsd, existing, directories = children.subList(0, size - 1), FSDirMkdirOp.addImplicitUwx((parentINode = existing.getLastINode()).getPermissionStatus(), permission))) == null) {
            return null;
        }
        return new AbstractMap.SimpleImmutableEntry<INodesInPath, String>(existing, last);
    }

    private static INodesInPath createChildrenDirectories(FSDirectory fsd, INodesInPath existing, List<String> children, PermissionStatus perm) throws IOException {
        for (String component : children) {
            if ((existing = FSDirMkdirOp.createSingleDirectory(fsd, existing, component, perm)) != null) continue;
            return null;
        }
        return existing;
    }

    private static INodesInPath createSingleDirectory(FSDirectory fsd, INodesInPath existing, String localName, PermissionStatus perm) throws IOException {
        existing = FSDirMkdirOp.unprotectedMkdir(fsd, IDsGeneratorFactory.getInstance().getUniqueINodeID(), existing, localName.getBytes(Charsets.UTF_8), perm, null, Time.now());
        if (existing == null) {
            return null;
        }
        INode newNode = existing.getLastINode();
        NameNode.getNameNodeMetrics().incrFilesCreated();
        String cur = existing.getPath();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug("mkdirs: created directory " + cur);
        }
        return existing;
    }

    private static PermissionStatus addImplicitUwx(PermissionStatus parentPerm, PermissionStatus perm) {
        FsPermission p = parentPerm.getPermission();
        FsPermission ancestorPerm = new FsPermission(p.getUserAction().or(FsAction.WRITE_EXECUTE), p.getGroupAction(), p.getOtherAction());
        return new PermissionStatus(perm.getUserName(), perm.getGroupName(), ancestorPerm);
    }

    private static INodesInPath unprotectedMkdir(FSDirectory fsd, long inodeId, INodesInPath parent, byte[] name, PermissionStatus permission, List<AclEntry> aclEntries, long timestamp) throws QuotaExceededException, AclException, FileAlreadyExistsException, IOException {
        assert (parent.getLastINode() != null);
        if (!parent.getLastINode().isDirectory()) {
            throw new FileAlreadyExistsException("Parent path is not a directory: " + parent.getPath() + " " + DFSUtil.bytes2String(name));
        }
        INodeDirectory dir = new INodeDirectory(inodeId, name, permission, timestamp);
        INodesInPath iip = fsd.addLastINode(parent, dir, true);
        if (iip != null && aclEntries != null) {
            AclStorage.updateINodeAcl(dir, aclEntries);
        }
        return iip;
    }
}

