/*
 * Decompiled with CFR 0.152.
 */
package io.hops.security;

import io.hops.metadata.HdfsStorageFactory;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.security.GroupAlreadyExistsException;
import io.hops.security.GroupNotFoundException;
import io.hops.security.GroupsNotFoundForUserException;
import io.hops.security.UserAlreadyExistsException;
import io.hops.security.UserAlreadyInGroupException;
import io.hops.security.UserNotFoundException;
import io.hops.security.UsersGroups;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback;
import org.apache.hadoop.security.UserGroupInformation;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestUsersGroups {
    private static final Log LOG = LogFactory.getLog(TestUsersGroups.class);
    static AtomicBoolean fail = new AtomicBoolean(false);
    Random rand = new Random(System.currentTimeMillis());

    @After
    public void afterTest() {
        UsersGroups.stop();
    }

    @Test
    public void testGroupsCacheIsEnabled() {
        HdfsConfiguration conf = new HdfsConfiguration();
        Assert.assertFalse((boolean)Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)conf).isCacheEnabled());
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback");
        Assert.assertTrue((boolean)Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)conf).isCacheEnabled());
        conf.set("hadoop.security.group.mapping", "io.hops.security.HopsGroupsWithFallBack");
        Assert.assertFalse((boolean)Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)conf).isCacheEnabled());
    }

    @Test
    public void testUsersGroupsCache0() throws Exception {
        this.testUsersGroupsCache(0, 0);
    }

    @Test
    public void testUsersGroupsCache1() throws Exception {
        this.testUsersGroupsCache(120, 10000);
    }

    public void testUsersGroupsCache(int cacheTime, int cacheSize) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hops.ug.cache.secs", Integer.toString(cacheTime));
        conf.set("hops.ug.cache.size", Integer.toString(cacheSize));
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UsersGroups.createSyncRow();
        String currentUser = "user0";
        String[] groups = new String[3];
        for (int i = 0; i < 3; ++i) {
            groups[i] = "group" + i;
        }
        try {
            UsersGroups.getUserID((String)currentUser);
        }
        catch (UserNotFoundException i) {
            // empty catch block
        }
        for (String group : groups) {
            try {
                UsersGroups.getGroupID((String)group);
            }
            catch (GroupNotFoundException groupNotFoundException) {
                // empty catch block
            }
        }
        UsersGroups.addUser((String)currentUser);
        for (String group : groups) {
            UsersGroups.addGroup((String)group);
        }
        for (String group : groups) {
            try {
                UsersGroups.addGroup((String)group);
            }
            catch (GroupAlreadyExistsException groupAlreadyExistsException) {
                // empty catch block
            }
        }
        try {
            UsersGroups.addUser((String)currentUser);
        }
        catch (UserAlreadyExistsException i) {
            // empty catch block
        }
        UsersGroups.addUserToGroups((String)currentUser, (String[])Arrays.copyOfRange(groups, 0, 2));
        try {
            UsersGroups.addUserToGroup((String)currentUser, (String)groups[0]);
        }
        catch (UserAlreadyInGroupException i) {
            // empty catch block
        }
        int userId = UsersGroups.getUserID((String)currentUser);
        Assert.assertNotEquals((long)userId, (long)0L);
        Assert.assertEquals((Object)currentUser, (Object)UsersGroups.getUser((int)userId));
        List cachedGroups = UsersGroups.getGroups((String)currentUser);
        Assert.assertNotNull((Object)cachedGroups);
        Assert.assertTrue((boolean)cachedGroups.equals(Arrays.asList(groups[0], groups[1])));
        for (int i = 0; i < 2; ++i) {
            int groupId = UsersGroups.getGroupID((String)groups[i]);
            Assert.assertNotEquals((long)groupId, (long)0L);
            Assert.assertEquals((Object)groups[i], (Object)UsersGroups.getGroup((int)groupId));
        }
        Assert.assertNotEquals((long)UsersGroups.getGroupID((String)groups[2]), (long)0L);
        UsersGroups.removeGroup((String)groups[0]);
        try {
            UsersGroups.getGroupID((String)groups[0]);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        cachedGroups = UsersGroups.getGroups((String)currentUser);
        Assert.assertNotNull((Object)cachedGroups);
        Assert.assertTrue((boolean)cachedGroups.equals(Arrays.asList(groups[1])));
        UsersGroups.removeUserFromGroup((String)currentUser, (String)groups[1]);
        UsersGroups.getGroupID((String)groups[1]);
        UsersGroups.getUserID((String)currentUser);
        try {
            UsersGroups.getGroups((String)currentUser);
        }
        catch (GroupsNotFoundForUserException groupsNotFoundForUserException) {
            // empty catch block
        }
        UsersGroups.removeGroup((String)groups[1]);
        try {
            UsersGroups.getGroupID((String)groups[1]);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        try {
            UsersGroups.getGroups((String)currentUser);
        }
        catch (GroupsNotFoundForUserException groupsNotFoundForUserException) {
            // empty catch block
        }
        UsersGroups.addUserToGroup((String)currentUser, (String)groups[2]);
        cachedGroups = UsersGroups.getGroups((String)currentUser);
        Assert.assertNotNull((Object)cachedGroups);
        Assert.assertTrue((boolean)cachedGroups.equals(Arrays.asList(groups[2])));
        UsersGroups.removeUser((String)currentUser);
        UsersGroups.removeGroup((String)groups[2]);
        try {
            UsersGroups.getUserID((String)currentUser);
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        try {
            UsersGroups.getGroupID((String)groups[2]);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        try {
            UsersGroups.getGroups((String)currentUser);
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAddRemoveUsersGroups0() throws Exception {
        this.testAddRemoveUsersGroups(0, 0);
    }

    @Test
    public void testAddRemoveUsersGroups1() throws Exception {
        this.testAddRemoveUsersGroups(120, 10000);
    }

    public void testAddRemoveUsersGroups(int cacheTime, int cacheSize) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hops.ug.cache.secs", Integer.toString(cacheTime));
        conf.set("hops.ug.cache.size", Integer.toString(cacheSize));
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UsersGroups.createSyncRow();
        String user = "user";
        UsersGroups.addUser((String)user);
        int userId = UsersGroups.getUserID((String)user);
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertEquals((Object)user, (Object)UsersGroups.getUser((int)userId));
        String group = "group";
        UsersGroups.addGroup((String)group);
        int groupId = UsersGroups.getGroupID((String)group);
        Assert.assertNotSame((Object)0, (Object)groupId);
        Assert.assertEquals((Object)group, (Object)UsersGroups.getGroup((int)groupId));
        try {
            UsersGroups.getGroups((String)user);
        }
        catch (GroupsNotFoundForUserException groupsNotFoundForUserException) {
            // empty catch block
        }
        UsersGroups.addUserToGroup((String)user, (String)group);
        List groups = UsersGroups.getGroups((String)user);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals(Arrays.asList(group), (Object)groups);
        UsersGroups.removeUserFromGroup((String)user, (String)group);
        try {
            UsersGroups.getGroups((String)user);
        }
        catch (GroupsNotFoundForUserException groupsNotFoundForUserException) {
            // empty catch block
        }
        UsersGroups.removeGroup((String)group);
        try {
            UsersGroups.getGroupID((String)group);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        UsersGroups.removeUser((String)user);
        try {
            UsersGroups.getUserID((String)user);
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        try {
            UsersGroups.getGroups((String)user);
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testUsersGroupsNotConfigurad() throws IOException {
        UsersGroups.addUserToGroup((String)"user", (String)"group1");
        Assert.assertEquals((long)UsersGroups.getGroupID((String)"group1"), (long)0L);
        Assert.assertEquals((long)UsersGroups.getUserID((String)"user"), (long)0L);
        Assert.assertNull((Object)UsersGroups.getGroups((String)"user"));
    }

    @Test
    public void testGetUnixUserGroups() throws Exception {
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UsersGroups.createSyncRow();
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        JniBasedUnixGroupsMappingWithFallback jniGroupsMapping = new JniBasedUnixGroupsMappingWithFallback();
        List loginUserGroups = jniGroupsMapping.getGroups(ugi.getUserName());
        Assert.assertFalse((boolean)loginUserGroups.isEmpty());
        UsersGroups.addUserToGroups((String)ugi.getUserName(), (String[])new String[0]);
        List ugiGroups = ugi.getGroups();
        System.out.println("Count: " + ugiGroups.size() + " Groups: " + Arrays.toString(ugiGroups.toArray()));
        Assert.assertFalse((boolean)ugiGroups.isEmpty());
        Assert.assertThat((Object)ugiGroups, (Matcher)Matchers.equalTo((Object)loginUserGroups));
    }

    @Test
    public void testAddUsers0() throws Exception {
        this.testAddUsers(0, 0);
    }

    @Test
    public void testAddUsers1() throws Exception {
        this.testAddUsers(5, 10000);
    }

    public void testAddUsers(int cacheTime, int cacheSize) throws IOException {
        Configuration conf = new Configuration();
        conf.set("hops.ug.cache.secs", Integer.toString(cacheTime));
        conf.set("hops.ug.cache.size", Integer.toString(cacheSize));
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UsersGroups.createSyncRow();
        String currentUser = "user";
        int NUM_GROUPS = 5;
        String[] groups = new String[5];
        for (int i = 0; i < 5; ++i) {
            groups[i] = "group" + i;
            UsersGroups.addGroup((String)groups[i]);
        }
        UsersGroups.addUser((String)currentUser);
        UsersGroups.addUserToGroups((String)currentUser, (String[])Arrays.copyOfRange(groups, 0, 3));
        int userId = UsersGroups.getUserID((String)currentUser);
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertEquals((Object)UsersGroups.getUser((int)userId), (Object)currentUser);
        for (String group : groups) {
            int groupId = UsersGroups.getGroupID((String)group);
            Assert.assertNotSame((Object)0, (Object)groupId);
            Assert.assertEquals((Object)UsersGroups.getGroup((int)groupId), (Object)group);
        }
        Assert.assertThat((Object)UsersGroups.getGroups((String)currentUser), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{groups[0], groups[1], groups[2]}));
        UsersGroups.getCache().removeUserFromDB(Integer.valueOf(UsersGroups.getUserID((String)currentUser)));
        if (cacheSize != 0 && cacheTime != 0) {
            userId = UsersGroups.getUserID((String)currentUser);
            Assert.assertNotSame((Object)0, (Object)userId);
        } else {
            try {
                UsersGroups.getUserID((String)currentUser);
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(cacheTime * 1000 + 500);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            UsersGroups.getUserID((String)currentUser);
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        UsersGroups.addUser((String)currentUser);
        for (String group : groups) {
            Assert.assertNotEquals((long)UsersGroups.getGroupID((String)group), (long)0L);
        }
        UsersGroups.addUserToGroups((String)currentUser, (String[])groups);
        List cachedGroups = UsersGroups.getGroups((String)currentUser);
        Collections.sort(cachedGroups);
        Assert.assertEquals(Arrays.asList(groups), (Object)cachedGroups);
        UsersGroups.getCache().removeGroupFromDB(Integer.valueOf(UsersGroups.getGroupID((String)groups[4])));
        cachedGroups = UsersGroups.getGroups((String)currentUser);
        Collections.sort(cachedGroups);
        if (cacheSize != 0 && cacheTime != 0) {
            Assert.assertEquals(Arrays.asList(groups), (Object)cachedGroups);
        } else {
            Assert.assertEquals(Arrays.asList(Arrays.copyOfRange(groups, 0, 4)), (Object)cachedGroups);
        }
        try {
            Thread.sleep(cacheTime * 1000 + 500);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        cachedGroups = UsersGroups.getGroups((String)currentUser);
        Collections.sort(cachedGroups);
        Assert.assertEquals(Arrays.asList(Arrays.copyOfRange(groups, 0, 4)), (Object)cachedGroups);
    }

    @Test
    public void testGroupMappingsRefresh() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        cluster.getNameNode().getRpcServer().refreshUserToGroupsMappings();
        UsersGroups.addUser((String)"user");
        UsersGroups.addGroup((String)"group1");
        UsersGroups.addGroup((String)"group2");
        UsersGroups.addGroup((String)"group3");
        UsersGroups.addUserToGroups((String)"user", (String[])new String[]{"group1", "group2"});
        int userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertEquals((Object)UsersGroups.getUser((int)userId), (Object)"user");
        int groupId = UsersGroups.getGroupID((String)"group1");
        Assert.assertNotSame((Object)0, (Object)groupId);
        Assert.assertEquals((Object)UsersGroups.getGroup((int)groupId), (Object)"group1");
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
        this.removeUser(userId);
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        cluster.getNameNode().getRpcServer().refreshUserToGroupsMappings();
        try {
            userId = UsersGroups.getUserID((String)"user");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        UsersGroups.addUser((String)"user");
        userId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        UsersGroups.addUserToGroups((String)"user", (String[])new String[]{"group1", "group2"});
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2"}));
        this.removeUser(userId);
        try {
            UsersGroups.addUserToGroups((String)"user", (String[])new String[]{"group3"});
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        UsersGroups.addUser((String)"user");
        UsersGroups.addUserToGroups((String)"user", (String[])new String[]{"group1", "group2"});
        UsersGroups.addUserToGroups((String)"user", (String[])new String[]{"group3"});
        int newUserId = UsersGroups.getUserID((String)"user");
        Assert.assertNotSame((Object)0, (Object)userId);
        Assert.assertTrue((newUserId > userId ? 1 : 0) != 0);
        Assert.assertThat((Object)UsersGroups.getGroups((String)"user"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group2", "group3"}));
        cluster.shutdown();
    }

    @Test
    public void testFKConstraintException() throws Exception {
        Configuration conf = new Configuration();
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UsersGroups.createSyncRow();
        UsersGroups.addUser((String)"u1");
        int uid = UsersGroups.getUserID((String)"u1");
        UsersGroups.addGroup((String)"g1");
        int gid = UsersGroups.getGroupID((String)"g1");
        UsersGroups.addUserToGroup((String)"u1", (String)"g1");
        try {
            UsersGroups.addUserToGroup((String)"u1", (String)"g1");
        }
        catch (UserAlreadyInGroupException userAlreadyInGroupException) {
            // empty catch block
        }
        try {
            UsersGroups.getCache().addUserToGroupDB(0, gid);
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        try {
            UsersGroups.getCache().addUserToGroupDB(uid, 0);
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        UsersGroups.getCache().addUserToGroupDB(uid, gid);
        UsersGroups.getCache().addUserToGroupDB(uid, gid);
    }

    @Test
    public void setOwnerMultipleTimes0() throws Exception {
        this.setOwnerMultipleTimes(0, 0);
    }

    @Test
    public void setOwnerMultipleTimes1() throws Exception {
        this.setOwnerMultipleTimes(120, 10000);
    }

    public void setOwnerMultipleTimes(int cacheTime, int cacheSize) throws Exception {
        UserGroupInformation ugi;
        Path base;
        DistributedFileSystem dfs;
        MiniDFSCluster cluster;
        boolean cacheEnabled;
        block4: {
            HdfsConfiguration conf = new HdfsConfiguration();
            cacheEnabled = cacheTime != 0 && cacheSize != 0;
            conf.set("hops.ug.cache.secs", Integer.toString(cacheTime));
            conf.set("hops.ug.cache.size", Integer.toString(cacheSize));
            String userName = UserGroupInformation.getCurrentUser().getShortUserName();
            conf.set(String.format("hadoop.proxyuser.%s.hosts", userName), "*");
            conf.set(String.format("hadoop.proxyuser.%s.users", userName), "*");
            conf.set(String.format("hadoop.proxyuser.%s.groups", userName), "*");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            dfs = cluster.getFileSystem();
            base = new Path("/projects/project1");
            dfs.mkdirs(base);
            Path child = new Path(base, "dataset");
            dfs.mkdirs(child);
            dfs.setOwner(base, "testUser", "testGroup");
            this.removeGroup(UsersGroups.getGroupID((String)"testGroup"));
            try {
                ugi = UserGroupInformation.createProxyUserForTesting((String)"testUser", (UserGroupInformation)UserGroupInformation.getLoginUser(), (String[])new String[]{"testGroup"});
            }
            catch (Exception e) {
                e.getCause().printStackTrace();
                if (e.getCause() instanceof GroupNotFoundException) break block4;
                throw e;
            }
        }
        if (cacheEnabled) {
            UsersGroups.clearCache();
        }
        if (cacheEnabled) {
            UsersGroups.addGroup((String)"testGroup");
        }
        ugi = UserGroupInformation.createProxyUserForTesting((String)"testUser", (UserGroupInformation)UserGroupInformation.getLoginUser(), (String[])new String[]{"testGroup"});
        FileSystem fs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return cluster.getFileSystem();
            }
        });
        fs.mkdirs(new Path(base, "testdir"));
        dfs.setOwner(base, "testUser", "testGroup");
        cluster.shutdown();
    }

    private void removeUser(final int userId) throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                UserDataAccess da = (UserDataAccess)HdfsStorageFactory.getDataAccess(UserDataAccess.class);
                da.removeUser(userId);
                return null;
            }
        }.handle();
    }

    private void removeGroup(final int groupId) throws IOException {
        new LightWeightRequestHandler((RequestHandler.OperationType)HDFSOperationType.TEST){

            public Object performTask() throws IOException {
                GroupDataAccess da = (GroupDataAccess)HdfsStorageFactory.getDataAccess(GroupDataAccess.class);
                da.removeGroup(groupId);
                return null;
            }
        }.handle();
    }

    @Test
    public void testUserNameAndGroupNameCaseSensitivity0() throws Exception {
        this.testUserNameAndGroupNameCaseSensitivity(0, 0);
    }

    @Test
    public void testUserNameAndGroupNameCaseSensitivity1() throws Exception {
        this.testUserNameAndGroupNameCaseSensitivity(120, 10000);
    }

    public void testUserNameAndGroupNameCaseSensitivity(int cacheTime, int cacheSize) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("hops.ug.cache.secs", Integer.toString(cacheTime));
        conf.set("hops.ug.cache.size", Integer.toString(cacheSize));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path base = new Path("/projects/project1");
        dfs.mkdirs(base);
        Path child = new Path(base, "dataset");
        dfs.mkdirs(child);
        dfs.setOwner(base, "testUser", "testGroup");
        FileStatus fileStatus = dfs.getFileStatus(base);
        Assert.assertTrue((boolean)fileStatus.getOwner().equals("testUser"));
        Assert.assertTrue((boolean)fileStatus.getGroup().equals("testGroup"));
        dfs.setOwner(base, "testuser", "testgroup");
        fileStatus = dfs.getFileStatus(base);
        Assert.assertTrue((boolean)fileStatus.getOwner().equals("testuser"));
        Assert.assertTrue((boolean)fileStatus.getGroup().equals("testgroup"));
        cluster.getNameNode().getRpcServer().refreshUserToGroupsMappings();
        Assert.assertTrue((UsersGroups.getUserID((String)"testUser") != 0 ? 1 : 0) != 0);
        Assert.assertTrue((UsersGroups.getUserID((String)"testuser") != 0 ? 1 : 0) != 0);
        Assert.assertNotEquals((long)UsersGroups.getUserID((String)"testUser"), (long)UsersGroups.getUserID((String)"testuser"));
        Assert.assertTrue((UsersGroups.getGroupID((String)"testGroup") != 0 ? 1 : 0) != 0);
        Assert.assertTrue((UsersGroups.getGroupID((String)"testgroup") != 0 ? 1 : 0) != 0);
        Assert.assertNotEquals((long)UsersGroups.getGroupID((String)"testGroup"), (long)UsersGroups.getGroupID((String)"testgroup"));
        cluster.shutdown();
    }

    @Test
    public void testConcurrentAddUser0() throws Exception {
        this.testConcurrentAddUser(0, 0);
    }

    @Test
    public void testConcurrentAddUser1() throws Exception {
        this.testConcurrentAddUser(120, 10000);
    }

    public void testConcurrentAddUser(int cacheTime, int cacheSize) throws Exception {
        Configuration conf = new Configuration();
        conf.set("hops.ug.cache.secs", Integer.toString(cacheTime));
        conf.set("hops.ug.cache.size", Integer.toString(cacheSize));
        HdfsStorageFactory.resetDALInitialized();
        HdfsStorageFactory.setConfiguration((Configuration)conf);
        HdfsStorageFactory.formatStorage();
        UsersGroups.createSyncRow();
        String userName = "user1";
        String groupNmae = "group1";
        int CONCURRENT_USERS = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        ArrayList<AddUser> callables = new ArrayList<AddUser>();
        for (int i = 0; i < 100; ++i) {
            callables.add(new AddUser("user1", "group1"));
        }
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.SECONDS);
        UsersGroups.clearCache();
        for (Future f : futures) {
            try {
                f.get();
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
                Assert.fail();
            }
        }
    }

    @Test
    public void testConcurrentSetSameOwner0() throws Exception {
        this.testConcurrentSetSameOwner(0, 0);
    }

    @Test
    public void testConcurrentSetSameOwner1() throws Exception {
        this.testConcurrentSetSameOwner(120, 10000);
    }

    public void testConcurrentSetSameOwner(int cacheTime, int cacheSize) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("hops.ug.cache.secs", Integer.toString(cacheTime));
        conf.set("hops.ug.cache.size", Integer.toString(cacheSize));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path base = new Path("/base");
        dfs.mkdirs(base);
        String userName = "user";
        String groupName = "group";
        int CONCURRENT_USERS = 100;
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        ArrayList<SetOwner> callables = new ArrayList<SetOwner>();
        for (int i = 0; i < 100; ++i) {
            Path file = new Path(base, "file" + i);
            dfs.create(file).close();
            callables.add(new SetOwner(dfs, file, "user", "group"));
        }
        List futures = executorService.invokeAll(callables);
        executorService.shutdown();
        executorService.awaitTermination(1L, TimeUnit.SECONDS);
        for (Future f : futures) {
            Assert.assertTrue((boolean)((Boolean)f.get()));
        }
        cluster.shutdown();
    }

    @Test
    public void testSetOwnerOnOutdatedCache0() throws Exception {
        this.testSetOwnerOnOutdatedCache(0, 0);
    }

    @Test
    public void testSetOwnerOnOutdatedCache1() throws Exception {
        this.testSetOwnerOnOutdatedCache(5, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetOwnerOnOutdatedCache(int cacheTime, int cacheSize) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("hops.ug.cache.secs", Integer.toString(cacheTime));
        conf.set("hops.ug.cache.size", Integer.toString(cacheSize));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).format(true).numDataNodes(1).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            Path base = new Path("/base");
            dfs.mkdirs(base);
            String username = "user";
            String groupname = "group";
            String newgroupname = "newgroup";
            dfs.setOwner(base, "user", "group");
            FileStatus fileStatus = dfs.getFileStatus(base);
            Assert.assertEquals((Object)"user", (Object)fileStatus.getOwner());
            Assert.assertEquals((Object)"group", (Object)fileStatus.getGroup());
            int userId = UsersGroups.getUserID((String)"user");
            int groupId = UsersGroups.getGroupID((String)"group");
            UsersGroups.getCache().removeUserFromDB(Integer.valueOf(userId));
            UsersGroups.getCache().removeGroupFromDB(Integer.valueOf(groupId));
            if (cacheSize == 0 && cacheTime == 0) {
                try {
                    UsersGroups.getUserID((String)"user");
                }
                catch (UserNotFoundException userNotFoundException) {
                    // empty catch block
                }
                try {
                    UsersGroups.getGroupID((String)"group");
                }
                catch (GroupNotFoundException groupNotFoundException) {
                    // empty catch block
                }
                fileStatus = dfs.getFileStatus(base);
                Assert.assertTrue((boolean)fileStatus.getGroup().isEmpty());
                Assert.assertTrue((boolean)fileStatus.getOwner().isEmpty());
            } else {
                Assert.assertNotEquals((long)0L, (long)UsersGroups.getUserID((String)"user"));
                Assert.assertNotEquals((long)0L, (long)UsersGroups.getGroupID((String)"group"));
                fileStatus = dfs.getFileStatus(base);
                Assert.assertEquals((Object)fileStatus.getGroup(), (Object)"group");
                Assert.assertEquals((Object)fileStatus.getOwner(), (Object)"user");
            }
            Thread.sleep(cacheTime * 1000);
            fileStatus = dfs.getFileStatus(base);
            Assert.assertTrue((boolean)fileStatus.getGroup().isEmpty());
            Assert.assertTrue((boolean)fileStatus.getOwner().isEmpty());
            try {
                UsersGroups.getUserID((String)"user");
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
            try {
                UsersGroups.getGroupID((String)"group");
            }
            catch (GroupNotFoundException groupNotFoundException) {
                // empty catch block
            }
            fileStatus = dfs.getFileStatus(base);
            Assert.assertTrue((boolean)fileStatus.getGroup().isEmpty());
            Assert.assertTrue((boolean)fileStatus.getOwner().isEmpty());
            dfs.setOwner(base, "user", "newgroup");
            fileStatus = dfs.getFileStatus(base);
            Assert.assertEquals((Object)"user", (Object)fileStatus.getOwner());
            Assert.assertEquals((Object)"newgroup", (Object)fileStatus.getGroup());
            int newUserId = UsersGroups.getUserID((String)"user");
            Assert.assertTrue((newUserId != userId ? 1 : 0) != 0);
            Assert.assertNotEquals((long)userId, (long)newUserId);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testSuperUserCheck() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String userName = UserGroupInformation.getCurrentUser().getShortUserName();
        conf.set(String.format("hadoop.proxyuser.%s.hosts", userName), "*");
        conf.set(String.format("hadoop.proxyuser.%s.users", userName), "*");
        conf.set(String.format("hadoop.proxyuser.%s.groups", userName), "*");
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        String user = "testUser";
        DistributedFileSystem dfs = cluster.getFileSystem();
        dfs.addUser(user);
        UserGroupInformation ugi = UserGroupInformation.createProxyUserForTesting((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser(), (String[])new String[0]);
        DistributedFileSystem dfsTestUser = (DistributedFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return cluster.getFileSystem();
            }
        });
        try {
            dfsTestUser.addUser("user");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            dfsTestUser.addGroup("group");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            dfsTestUser.addUserToGroup("user", "group");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            dfsTestUser.removeUser("user");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            dfsTestUser.removeGroup("group");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        try {
            dfsTestUser.removeUserFromGroup("user", "group");
            Assert.fail();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    @Test
    public void testSetOwnerDontAddUserToGroup() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        cluster.waitActive();
        DistributedFileSystem dfs = cluster.getFileSystem();
        Path base = new Path("/base");
        dfs.mkdirs(base);
        String userName = "user";
        String groupName = "group";
        dfs.setOwner(base, "user", "group");
        try {
            UsersGroups.getGroups((String)"user");
            Assert.fail();
        }
        catch (GroupsNotFoundForUserException groupsNotFoundForUserException) {
            // empty catch block
        }
        Assert.assertNotSame((Object)0, (Object)UsersGroups.getUserID((String)"user"));
        Assert.assertNotSame((Object)0, (Object)UsersGroups.getGroupID((String)"group"));
        cluster.shutdown();
    }

    @Test
    public void testMultiUserMultiGrp0() throws Exception {
        this.testMultiUserMultiGrp(0, 0);
    }

    @Test
    public void testMultiUserMultiGrp1() throws Exception {
        this.testMultiUserMultiGrp(120, 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiUserMultiGrp(int cacheTime, int cacheSize) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int NUM_NAMENODES = 2;
        String userName = UserGroupInformation.getCurrentUser().getShortUserName();
        conf.set(String.format("hadoop.proxyuser.%s.hosts", userName), "*");
        conf.set(String.format("hadoop.proxyuser.%s.users", userName), "*");
        conf.set(String.format("hadoop.proxyuser.%s.groups", userName), "*");
        conf.set("hops.ug.cache.secs", Integer.toString(cacheTime));
        conf.set("hops.ug.cache.size", Integer.toString(cacheSize));
        final MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHOPSTopology(2)).numDataNodes(1).format(true).build();
        cluster.waitActive();
        try {
            int i;
            int i2;
            DistributedFileSystem superFS = cluster.getFileSystem(this.rand.nextInt(2));
            int numUsers = 10;
            DistributedFileSystem[] fss = new DistributedFileSystem[numUsers];
            Path[] files = new Path[numUsers];
            for (i2 = 0; i2 < numUsers; ++i2) {
                superFS.addUser("user" + i2);
                LOG.info((Object)("Adding User " + i2));
                superFS.addGroup("group" + i2);
                LOG.info((Object)("Adding Group " + i2));
            }
            for (i2 = 0; i2 < numUsers; ++i2) {
                for (int j = 0; j < numUsers; ++j) {
                    superFS.addUserToGroup("user" + i2, "group" + j);
                    LOG.info((Object)("Adding User " + i2 + " to Group " + j));
                }
            }
            for (i2 = 0; i2 < numUsers; ++i2) {
                DistributedFileSystem fs;
                UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)("user" + i2));
                fss[i2] = fs = (DistributedFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                    @Override
                    public FileSystem run() throws Exception {
                        return cluster.getFileSystem(TestUsersGroups.this.rand.nextInt(2));
                    }
                });
            }
            Path path = new Path("/Projects");
            superFS.mkdirs(path);
            superFS.setPermission(path, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            path = new Path("/Projects/dataset");
            fss[0].mkdirs(path);
            fss[0].setPermission(path, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE));
            fss[0].setOwner(path, "user0", "group0");
            for (int i3 = 0; i3 < numUsers; ++i3) {
                path = new Path("/Projects/dataset/user" + i3);
                fss[i3].mkdirs(path);
                fss[i3].setPermission(path, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE));
                fss[i3].setOwner(path, "user" + i3, "group" + i3);
                path = new Path("/Projects/dataset/user" + i3 + "/file" + i3);
                fss[i3].create(path).close();
                fss[i3].setPermission(path, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.NONE));
                fss[i3].setOwner(path, "user" + i3, "group" + i3);
                files[i3] = path;
            }
            Thread[] threads = new Thread[numUsers];
            for (i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(new Worker(fss[i], files));
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
            }
            if (fail.get()) {
                Assert.fail((String)"Test failed no exception should have occurred during the test");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            cluster.shutdown();
        }
    }

    class Worker
    implements Runnable {
        DistributedFileSystem fs;
        Path[] paths;

        Worker(DistributedFileSystem fs, Path[] paths) {
            this.fs = fs;
            this.paths = paths;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < 1000; ++i) {
                    if (fail.get()) {
                        return;
                    }
                    FileStatus status = this.fs.getFileStatus(this.paths[TestUsersGroups.this.rand.nextInt(this.paths.length)]);
                    Thread.sleep(0L);
                    if (status != null) continue;
                    fail.set(true);
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                fail.set(true);
                return;
            }
        }
    }

    private class SetOwner
    implements Callable<Boolean> {
        private final DistributedFileSystem dfs;
        private final Path path;
        private final String userName;
        private final String groupName;

        SetOwner(DistributedFileSystem dfs, Path path, String userName, String groupName) {
            this.dfs = dfs;
            this.path = path;
            this.userName = userName;
            this.groupName = groupName;
        }

        @Override
        public Boolean call() throws Exception {
            for (int i = 0; i < 10; ++i) {
                this.dfs.setOwner(this.path, this.userName, this.groupName);
                FileStatus fileStatus = this.dfs.getFileStatus(this.path);
                if (this.userName != null) {
                    Assert.assertEquals((Object)this.userName, (Object)fileStatus.getOwner());
                }
                if (this.groupName == null) continue;
                Assert.assertEquals((Object)this.groupName, (Object)fileStatus.getGroup());
            }
            return true;
        }
    }

    private class AddUser
    implements Callable {
        private final String userName;
        private final String groupName;

        AddUser(String userName, String groupName) {
            this.userName = userName;
            this.groupName = groupName;
        }

        public Object call() throws Exception {
            try {
                UsersGroups.addUser((String)this.userName);
            }
            catch (UserAlreadyExistsException e) {
                LOG.info((Object)e.getMessage());
            }
            try {
                UsersGroups.addGroup((String)this.groupName);
            }
            catch (GroupAlreadyExistsException e) {
                LOG.info((Object)e.getMessage());
            }
            try {
                UsersGroups.addUserToGroup((String)this.userName, (String)this.groupName);
            }
            catch (UserAlreadyInGroupException e) {
                LOG.info((Object)e.getMessage());
            }
            return null;
        }
    }
}

