/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Random;
import javax.net.SocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FsTracer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.BlockReaderFactory;
import org.apache.hadoop.hdfs.BlockReaderLocal;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.RemotePeerFactory;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.net.TcpPeerServer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.CacheReplicationMonitor;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.ShortCircuitRegistry;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetCache;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.shortcircuit.DfsClientShmManager;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplica;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.Assert;

public class BlockReaderTestUtil {
    private HdfsConfiguration conf = null;
    private MiniDFSCluster cluster = null;

    public static boolean shouldTestLargeFiles() {
        String property = System.getProperty("hdfs.test.large.files");
        if (property == null) {
            return false;
        }
        if (property.isEmpty()) {
            return true;
        }
        return Boolean.parseBoolean(property);
    }

    public BlockReaderTestUtil(int replicationFactor) throws Exception {
        this(replicationFactor, new HdfsConfiguration());
    }

    public BlockReaderTestUtil(int replicationFactor, HdfsConfiguration config) throws Exception {
        this.conf = config;
        this.conf.setInt("dfs.replication", replicationFactor);
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).format(true).build();
        this.cluster.waitActive();
    }

    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public MiniDFSCluster getCluster() {
        return this.cluster;
    }

    public HdfsConfiguration getConf() {
        return this.conf;
    }

    public byte[] writeFile(Path filepath, int sizeKB) throws IOException {
        DistributedFileSystem fs = this.cluster.getFileSystem();
        FSDataOutputStream os = fs.create(filepath);
        byte[] data = new byte[1024 * sizeKB];
        new Random().nextBytes(data);
        os.write(data);
        os.close();
        return data;
    }

    public List<LocatedBlock> getFileBlocks(Path filepath, int sizeKB) throws IOException {
        DFSClient dfsclient = this.getDFSClient();
        return dfsclient.getNamenode().getBlockLocations(filepath.toString(), 0L, (long)(sizeKB * 1024)).getLocatedBlocks();
    }

    public DFSClient getDFSClient() throws IOException {
        InetSocketAddress nnAddr = new InetSocketAddress("localhost", this.cluster.getNameNodePort());
        return new DFSClient(nnAddr, (Configuration)this.conf);
    }

    public void readAndCheckEOS(BlockReader reader, int length, boolean expectEof) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        for (int nRead = 0; nRead < length; nRead += n) {
            DFSClient.LOG.info((Object)("So far read " + nRead + " - going to read more."));
            n = reader.read(buf, 0, buf.length);
            Assert.assertTrue((n > 0 ? 1 : 0) != 0);
        }
        if (expectEof) {
            DFSClient.LOG.info((Object)"Done reading, expect EOF for next read.");
            Assert.assertEquals((long)-1L, (long)reader.read(buf, 0, buf.length));
        }
    }

    public BlockReader getBlockReader(LocatedBlock testBlock, int offset, int lenToRead) throws IOException {
        return BlockReaderTestUtil.getBlockReader(this.cluster, testBlock, offset, lenToRead);
    }

    public static BlockReader getBlockReader(MiniDFSCluster cluster, LocatedBlock testBlock, int offset, int lenToRead) throws IOException {
        InetSocketAddress targetAddr = null;
        ExtendedBlock block = testBlock.getBlock();
        DatanodeInfo[] nodes = testBlock.getLocations();
        targetAddr = NetUtils.createSocketAddr((String)nodes[0].getXferAddr());
        final DistributedFileSystem fs = cluster.getFileSystem();
        return new BlockReaderFactory(fs.getClient().getConf()).setInetSocketAddress(targetAddr).setExtendedBlock(block).setFileName(targetAddr.toString() + ":" + block.getBlockId()).setBlockToken(testBlock.getBlockToken()).setStartOffset((long)offset).setLength((long)lenToRead).setVerifyChecksum(true).setClientName("BlockReaderTestUtil").setDatanodeInfo(nodes[0]).setClientCacheContext(ClientContext.getFromConf((Configuration)fs.getConf())).setCachingStrategy(CachingStrategy.newDefaultStrategy()).setConfiguration(fs.getConf()).setAllowShortCircuitLocalReads(true).setTracer(FsTracer.get((Configuration)fs.getConf())).setRemotePeerFactory(new RemotePeerFactory(){

            public SocketFactory getSocketFactory(Configuration conf) throws IOException {
                return NetUtils.getDefaultSocketFactory((Configuration)conf);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Peer newConnectedPeer(InetSocketAddress addr, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId) throws IOException {
                Peer peer = null;
                Socket sock = this.getSocketFactory(fs.getConf()).createSocket();
                try {
                    sock.connect(addr, HdfsServerConstants.READ_TIMEOUT);
                    sock.setSoTimeout(HdfsServerConstants.READ_TIMEOUT);
                    peer = TcpPeerServer.peerFromSocket((Socket)sock);
                }
                finally {
                    if (peer == null) {
                        IOUtils.closeQuietly((Socket)sock);
                    }
                }
                return peer;
            }
        }).build();
    }

    public DataNode getDataNode(LocatedBlock testBlock) {
        DatanodeInfo[] nodes = testBlock.getLocations();
        int ipcport = nodes[0].getIpcPort();
        return this.cluster.getDataNode(ipcport);
    }

    public static void enableHdfsCachingTracing() {
        LogManager.getLogger((String)CacheReplicationMonitor.class.getName()).setLevel(Level.TRACE);
        LogManager.getLogger((String)CacheManager.class.getName()).setLevel(Level.TRACE);
        LogManager.getLogger((String)FsDatasetCache.class.getName()).setLevel(Level.TRACE);
    }

    public static void enableBlockReaderFactoryTracing() {
        LogManager.getLogger((String)BlockReaderFactory.class.getName()).setLevel(Level.TRACE);
        LogManager.getLogger((String)ShortCircuitCache.class.getName()).setLevel(Level.TRACE);
        LogManager.getLogger((String)ShortCircuitReplica.class.getName()).setLevel(Level.TRACE);
        LogManager.getLogger((String)BlockReaderLocal.class.getName()).setLevel(Level.TRACE);
    }

    public static void enableShortCircuitShmTracing() {
        LogManager.getLogger((String)DfsClientShmManager.class.getName()).setLevel(Level.TRACE);
        LogManager.getLogger((String)ShortCircuitRegistry.class.getName()).setLevel(Level.TRACE);
        LogManager.getLogger((String)ShortCircuitShm.class.getName()).setLevel(Level.TRACE);
        LogManager.getLogger((String)DataNode.class.getName()).setLevel(Level.TRACE);
    }
}

