/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Paths;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.HopsSSLSocketFactory;
import org.apache.hadoop.security.ssl.HopsSSLTestUtils;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDFSSSLServer
extends HopsSSLTestUtils {
    private final Log LOG = LogFactory.getLog(TestDFSSSLServer.class);
    MiniDFSCluster cluster;
    FileSystem dfs1;
    FileSystem dfs2;
    private static String classpathDir;

    public TestDFSSSLServer(HopsSSLTestUtils.CERT_ERR error_mode) {
        this.error_mode = error_mode;
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        classpathDir = KeyStoreTestUtil.getClasspathDir(TestDFSSSLServer.class);
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.client.failover.max.attempts", 1);
        this.conf.set("dfs.client.retry.policy.spec", "1,1");
        this.filesToPurge = this.prepareCryptoMaterial(this.conf, classpathDir);
        this.setCryptoConfig(this.conf, classpathDir);
        String testDataPath = System.getProperty("test.build.data", "build/test/data");
        File testDataCluster1 = new File(testDataPath, "dfs_cluster");
        String c1Path = testDataCluster1.getAbsolutePath();
        this.conf.set("hdfs.minidfs.basedir", c1Path);
        this.cluster = new MiniDFSCluster.Builder(this.conf).build();
        this.LOG.info((Object)"DFS cluster started");
    }

    @After
    public void tearDown() throws Exception {
        if (this.invoker != null) {
            this.invoker.join();
            this.invoker = null;
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        if (this.dfs1 != null) {
            this.dfs1.close();
        }
        if (this.dfs2 != null) {
            this.dfs2.close();
        }
    }

    @Test
    public void testRpcCall() throws Exception {
        this.LOG.debug((Object)"testRpcCall");
        this.dfs1 = DistributedFileSystem.newInstance((Configuration)this.conf);
        boolean exists = this.dfs1.exists(new Path("some_path"));
        this.LOG.debug((Object)("Does exist? " + exists));
        Assert.assertFalse((boolean)exists);
    }

    @Test
    public void testChecksum() throws Exception {
        this.LOG.debug((Object)"testChecksum");
        this.dfs1 = DistributedFileSystem.newInstance((Configuration)this.conf);
        Path file = new Path("some_file");
        this.dfs1.create(file);
        boolean exists = this.dfs1.exists(file);
        Assert.assertTrue((boolean)exists);
        FileChecksum checksum = this.dfs1.getFileChecksum(file);
        this.LOG.debug((Object)("File checksum is: " + checksum.toString()));
    }

    @Test
    public void testCopyFile() throws Exception {
        java.nio.file.Path binary = Paths.get(classpathDir, "binary_file.bin");
        this.filesToPurge.add(binary);
        Random rand = new Random();
        byte[] buffer = new byte[1024];
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(binary.toFile()));){
            for (int count = 0; count < 5000; ++count) {
                rand.nextBytes(buffer);
                bos.write(buffer);
            }
            bos.flush();
        }
        this.dfs1 = this.cluster.getFileSystem();
        Path target = new Path("binary_file");
        this.dfs1.copyFromLocalFile(new Path(binary.toString()), target);
        Assert.assertTrue((boolean)this.dfs1.exists(target));
        java.nio.file.Path localCopy = Paths.get(classpathDir, "copied_remote_file");
        this.dfs1.copyToLocalFile(target, new Path(localCopy.toString()));
        this.filesToPurge.add(localCopy);
        Assert.assertTrue((boolean)localCopy.toFile().exists());
    }

    @Test
    public void testRpcCallNonValidCert() throws Exception {
        this.dfs1 = DistributedFileSystem.newInstance((Configuration)this.conf);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_FILEPATH_KEY.getValue(), this.err_clientKeyStore.toString());
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_STORE_PASSWORD_KEY.getValue(), this.passwd);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.KEY_PASSWORD_KEY.getValue(), this.passwd);
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_FILEPATH_KEY.getValue(), this.err_clientTrustStore.toString());
        this.conf.set(HopsSSLSocketFactory.CryptoKeys.TRUST_STORE_PASSWORD_KEY.getValue(), this.passwd);
        this.invoker = new Thread(new Invoker(this.dfs1));
        this.invoker.start();
        if (this.error_mode.equals((Object)HopsSSLTestUtils.CERT_ERR.NO_CA)) {
            this.rule.expect(SSLException.class);
        } else if (this.error_mode.equals((Object)HopsSSLTestUtils.CERT_ERR.ERR_CN)) {
            this.rule.expect(RemoteException.class);
        }
        this.dfs2 = DistributedFileSystem.newInstance((Configuration)this.conf);
    }

    private class Invoker
    implements Runnable {
        private final FileSystem dfs;

        public Invoker(FileSystem dfs) {
            this.dfs = dfs;
        }

        @Override
        public void run() {
            try {
                TimeUnit.SECONDS.sleep(1L);
                TestDFSSSLServer.this.LOG.debug((Object)"Making RPC call from the correct client");
                Path file = new Path("some_file");
                this.dfs.create(file);
                boolean exists = this.dfs.exists(file);
                Assert.assertTrue((String)("File: " + file.getName() + " should have been created"), (boolean)exists);
            }
            catch (Exception ex) {
                TestDFSSSLServer.this.LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }
}

