/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLeaseRecovery2 {
    public static final Log LOG = LogFactory.getLog(TestLeaseRecovery2.class);
    private static final long BLOCK_SIZE = 1024L;
    private static final int FILE_SIZE = 2048;
    static final short REPLICATION_NUM = 3;
    static byte[] buffer = new byte[2048];
    private static String fakeUsername = "fakeUser1";
    private static String fakeGroup = "supergroup";
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private static final Configuration conf;
    private static final int BUF_SIZE;
    private static final long SHORT_LEASE_PERIOD = 1000L;
    private static final long LONG_LEASE_PERIOD = 3600000L;

    public TestLeaseRecovery2() {
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
    }

    @BeforeClass
    public static void startUp() throws IOException {
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.heartbeat.interval", 1);
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(5).build();
        cluster.waitActive();
        dfs = cluster.getFileSystem();
        DFSTestUtil.createRootFolder();
    }

    @AfterClass
    public static void tearDown() throws IOException {
        IOUtils.closeStream((Closeable)dfs);
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @Test
    public void testImmediateRecoveryOfLease() throws Exception {
        byte[] actual = new byte[2048];
        int size = AppendTestUtil.nextInt(2048);
        Path filepath = this.createFile("/immediateRecoverLease-shortlease", size, true);
        cluster.setLeasePeriod(1000L, 3600000L);
        this.recoverLeaseUsingCreate(filepath);
        this.verifyFile((FileSystem)dfs, filepath, actual, size);
        cluster.setLeasePeriod(3600000L, 3600000L);
        size = AppendTestUtil.nextInt(2048);
        filepath = this.createFile("/immediateRecoverLease-longlease", size, false);
        this.recoverLease(filepath, null);
        this.verifyFile((FileSystem)dfs, filepath, actual, size);
        size = AppendTestUtil.nextInt(2048);
        filepath = this.createFile("/immediateRecoverLease-sameclient", size, false);
        Path filepath1 = new Path(filepath.toString() + AppendTestUtil.nextInt());
        FSDataOutputStream stm = dfs.create(filepath1, true, BUF_SIZE, (short)3, 1024L);
        this.recoverLease(filepath, dfs);
        this.verifyFile((FileSystem)dfs, filepath, actual, size);
        stm.write(buffer, 0, size);
        stm.close();
        this.verifyFile((FileSystem)dfs, filepath1, actual, size);
    }

    @Test
    public void testLeaseRecoverByAnotherUser() throws Exception {
        byte[] actual = new byte[2048];
        cluster.setLeasePeriod(1000L, 3600000L);
        Path filepath = this.createFile("/immediateRecoverLease-x", 0, true);
        this.recoverLeaseUsingCreate2(filepath);
        this.verifyFile((FileSystem)dfs, filepath, actual, 0);
    }

    private Path createFile(String filestr, int size, boolean triggerLeaseRenewerInterrupt) throws IOException, InterruptedException {
        AppendTestUtil.LOG.info((Object)("filestr=" + filestr));
        Path filepath = new Path(filestr);
        FSDataOutputStream stm = dfs.create(filepath, true, BUF_SIZE, (short)3, 1024L);
        Assert.assertTrue((boolean)TestLeaseRecovery2.dfs.dfs.exists(filestr));
        AppendTestUtil.LOG.info((Object)("size=" + size));
        stm.write(buffer, 0, size);
        AppendTestUtil.LOG.info((Object)"hflush");
        stm.hflush();
        if (triggerLeaseRenewerInterrupt) {
            AppendTestUtil.LOG.info((Object)"leasechecker.interruptAndJoin()");
            TestLeaseRecovery2.dfs.dfs.getLeaseRenewer().interruptAndJoin();
        }
        return filepath;
    }

    private void recoverLease(Path filepath, DistributedFileSystem dfs) throws Exception {
        if (dfs == null) {
            dfs = (DistributedFileSystem)this.getFSAsAnotherUser(conf);
        }
        while (!dfs.recoverLease(filepath)) {
            AppendTestUtil.LOG.info((Object)"sleep 5000ms");
            Thread.sleep(5000L);
        }
    }

    private FileSystem getFSAsAnotherUser(Configuration c) throws IOException, InterruptedException {
        return FileSystem.get((URI)FileSystem.getDefaultUri((Configuration)c), (Configuration)c, (String)UserGroupInformation.createUserForTesting((String)fakeUsername, (String[])new String[]{fakeGroup}).getUserName());
    }

    private void recoverLeaseUsingCreate(Path filepath) throws IOException, InterruptedException {
        FileSystem dfs2 = this.getFSAsAnotherUser(conf);
        for (int i = 0; i < 10; ++i) {
            AppendTestUtil.LOG.info((Object)("i=" + i));
            try {
                dfs2.create(filepath, false, BUF_SIZE, (short)1, 1024L);
                Assert.fail((String)"Creation of an existing file should never succeed.");
                continue;
            }
            catch (FileAlreadyExistsException e) {
                return;
            }
            catch (AlreadyBeingCreatedException e) {
                return;
            }
            catch (IOException ioe) {
                AppendTestUtil.LOG.warn((Object)"UNEXPECTED ", (Throwable)ioe);
                AppendTestUtil.LOG.info((Object)"sleep 5000ms");
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Assert.fail((String)"recoverLeaseUsingCreate failed");
    }

    private void recoverLeaseUsingCreate2(Path filepath) throws Exception {
        FileSystem dfs2 = this.getFSAsAnotherUser(conf);
        int size = AppendTestUtil.nextInt(2048);
        DistributedFileSystem dfsx = (DistributedFileSystem)dfs2;
        Path filepath2 = new Path("/immediateRecoverLease-x2");
        FSDataOutputStream stm = dfsx.create(filepath2, true, BUF_SIZE, (short)3, 1024L);
        Assert.assertTrue((boolean)dfsx.dfs.exists("/immediateRecoverLease-x2"));
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        dfsx.append(filepath);
    }

    private void verifyFile(FileSystem dfs, Path filepath, byte[] actual, int size) throws IOException {
        AppendTestUtil.LOG.info((Object)("Lease for file " + filepath + " is recovered. Validating its contents now..."));
        Assert.assertTrue((String)("File should be " + size + " bytes, but is actually  found to be " + dfs.getFileStatus(filepath).getLen() + " bytes"), (dfs.getFileStatus(filepath).getLen() == (long)size ? 1 : 0) != 0);
        System.out.println("File size is good. Now validating sizes from datanodes...");
        FSDataInputStream stmin = dfs.open(filepath);
        stmin.readFully(0L, actual, 0, size);
        stmin.close();
    }

    @Test
    public void testHardLeaseRecovery() throws Exception {
        LocatedBlocks locatedBlocks;
        String filestr = "/hardLeaseRecovery";
        AppendTestUtil.LOG.info((Object)("filestr=" + filestr));
        Path filepath = new Path(filestr);
        FSDataOutputStream stm = dfs.create(filepath, true, BUF_SIZE, (short)3, 1024L);
        Assert.assertTrue((boolean)TestLeaseRecovery2.dfs.dfs.exists(filestr));
        int size = AppendTestUtil.nextInt(2048);
        AppendTestUtil.LOG.info((Object)("size=" + size));
        stm.write(buffer, 0, size);
        AppendTestUtil.LOG.info((Object)"hflush");
        stm.hflush();
        AppendTestUtil.LOG.info((Object)"leasechecker.interruptAndJoin()");
        TestLeaseRecovery2.dfs.dfs.getLeaseRenewer().interruptAndJoin();
        cluster.setLeasePeriod(3600000L, 1000L);
        do {
            Thread.sleep(1000L);
        } while ((locatedBlocks = TestLeaseRecovery2.dfs.dfs.getLocatedBlocks(filestr, 0L, (long)size)).isUnderConstruction());
        Assert.assertEquals((long)size, (long)locatedBlocks.getFileLength());
        try {
            stm.write(98);
            stm.close();
            Assert.fail((String)"Writer thread should have been killed");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AppendTestUtil.LOG.info((Object)"File size is good. Now validating sizes from datanodes...");
        AppendTestUtil.checkFullFile((FileSystem)dfs, filepath, size, buffer, filestr);
    }

    @Test
    public void testSoftLeaseRecovery() throws Exception {
        HashMap<String, String[]> u2g_map = new HashMap<String, String[]>(1);
        u2g_map.put(fakeUsername, new String[]{fakeGroup});
        DFSTestUtil.updateConfWithFakeGroupMapping(conf, u2g_map);
        cluster.setLeasePeriod(60000L, 3600000L);
        String filestr = "/foo" + AppendTestUtil.nextInt();
        AppendTestUtil.LOG.info((Object)("filestr=" + filestr));
        Path filepath = new Path(filestr);
        FSDataOutputStream stm = dfs.create(filepath, true, BUF_SIZE, (short)3, 1024L);
        Assert.assertTrue((boolean)TestLeaseRecovery2.dfs.dfs.exists(filestr));
        int size = AppendTestUtil.nextInt(2048);
        AppendTestUtil.LOG.info((Object)("size=" + size));
        stm.write(buffer, 0, size);
        AppendTestUtil.LOG.info((Object)"hflush");
        stm.hflush();
        AppendTestUtil.LOG.info((Object)"leasechecker.interruptAndJoin()");
        TestLeaseRecovery2.dfs.dfs.getLeaseRenewer().interruptAndJoin();
        cluster.setLeasePeriod(1000L, 3600000L);
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)fakeUsername, (String[])new String[]{fakeGroup});
        FileSystem dfs2 = DFSTestUtil.getFileSystemAs(ugi, conf);
        boolean done = false;
        for (int i = 0; i < 10 && !done; ++i) {
            AppendTestUtil.LOG.info((Object)("i=" + i));
            try {
                dfs2.create(filepath, false, BUF_SIZE, (short)3, 1024L);
                Assert.fail((String)"Creation of an existing file should never succeed.");
            }
            catch (FileAlreadyExistsException ex) {
                done = true;
            }
            catch (AlreadyBeingCreatedException ex) {
                AppendTestUtil.LOG.info((Object)("GOOD! got " + ex.getMessage()));
            }
            catch (IOException ioe) {
                AppendTestUtil.LOG.warn((Object)"UNEXPECTED IOException", (Throwable)ioe);
            }
            if (done) continue;
            AppendTestUtil.LOG.info((Object)"sleep 5000ms");
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.assertTrue((boolean)done);
        AppendTestUtil.LOG.info((Object)("Lease for file " + filepath + " is recovered. Validating its contents now..."));
        long fileSize = dfs.getFileStatus(filepath).getLen();
        Assert.assertTrue((String)("File should be " + size + " bytes, but is actually  found to be " + fileSize + " bytes"), (fileSize == (long)size ? 1 : 0) != 0);
        AppendTestUtil.LOG.info((Object)"File size is good. Now validating data and sizes from datanodes...");
        AppendTestUtil.checkFullFile((FileSystem)dfs, filepath, size, buffer, filestr);
    }

    @Test
    public void testHardLeaseRecoveryAfterNameNodeRestart() throws Exception {
        this.hardLeaseRecoveryRestartHelper(false, -1);
    }

    @Test
    public void testHardLeaseRecoveryAfterNameNodeRestart2() throws Exception {
        this.hardLeaseRecoveryRestartHelper(false, 1535);
    }

    @Test
    public void testHardLeaseRecoveryWithRenameAfterNameNodeRestart() throws Exception {
        this.hardLeaseRecoveryRestartHelper(true, -1);
    }

    public void hardLeaseRecoveryRestartHelper(boolean doRename, int size) throws Exception {
        LocatedBlocks locatedBlocks;
        if (size < 0) {
            size = AppendTestUtil.nextInt(2049);
        }
        String fileStr = "/hardLeaseRecovery";
        AppendTestUtil.LOG.info((Object)("filestr=" + fileStr));
        Path filePath = new Path(fileStr);
        FSDataOutputStream stm = dfs.create(filePath, true, BUF_SIZE, (short)3, 1024L);
        Assert.assertTrue((boolean)TestLeaseRecovery2.dfs.dfs.exists(fileStr));
        AppendTestUtil.LOG.info((Object)("size=" + size));
        stm.write(buffer, 0, size);
        String originalLeaseHolder = NameNodeAdapter.getLeaseHolderForPath(cluster.getNameNode(), fileStr);
        Assert.assertFalse((String)"original lease holder should not be the NN", (boolean)originalLeaseHolder.equals("HDFS_NameNode"));
        AppendTestUtil.LOG.info((Object)"hflush");
        stm.hflush();
        HdfsDataInputStream in = (HdfsDataInputStream)dfs.open(filePath);
        Assert.assertEquals((long)size, (long)in.getVisibleLength());
        in.close();
        if (doRename) {
            fileStr = fileStr + ".renamed";
            Path renamedPath = new Path(fileStr);
            Assert.assertTrue((boolean)dfs.rename(filePath, renamedPath));
            filePath = renamedPath;
        }
        AppendTestUtil.LOG.info((Object)"leasechecker.interruptAndJoin()");
        TestLeaseRecovery2.dfs.dfs.getLeaseRenewer().interruptAndJoin();
        for (DataNode dn : cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, true);
        }
        cluster.setLeasePeriod(3600000L, 1000L);
        Thread.sleep(4000L);
        TestLeaseRecovery2.checkLease(fileStr, size);
        cluster.restartNameNode(false);
        TestLeaseRecovery2.checkLease(fileStr, size);
        for (DataNode dn : cluster.getDataNodes()) {
            DataNodeTestUtils.setHeartbeatsDisabledForTests(dn, false);
        }
        cluster.waitActive();
        cluster.setLeasePeriod(3600000L, 1000L);
        do {
            Thread.sleep(1000L);
        } while ((locatedBlocks = TestLeaseRecovery2.dfs.dfs.getLocatedBlocks(fileStr, 0L, (long)size)).isUnderConstruction());
        Assert.assertEquals((long)size, (long)locatedBlocks.getFileLength());
        try {
            stm.write(98);
            stm.hflush();
            Assert.fail((String)"Should not be able to flush after we've lost the lease");
        }
        catch (IOException e) {
            LOG.info((Object)"Expceted exception on write/hflush", (Throwable)e);
        }
        try {
            stm.close();
            Assert.fail((String)"Should not be able to close after we've lost the lease");
        }
        catch (IOException e) {
            LOG.info((Object)"Expected exception on close", (Throwable)e);
        }
        AppendTestUtil.LOG.info((Object)"File size is good. Now validating sizes from datanodes...");
        AppendTestUtil.checkFullFile((FileSystem)dfs, filePath, size, buffer, fileStr);
    }

    static void checkLease(String f, int size) throws IOException {
        String holder = NameNodeAdapter.getLeaseHolderForPath(cluster.getNameNode(), f);
        if (size == 0) {
            Assert.assertEquals((String)"lease holder should null, file is closed", null, (Object)holder);
        } else {
            Assert.assertEquals((String)"lease holder should now be the NN", (Object)"HDFS_NameNode", (Object)holder);
        }
    }

    static {
        conf = new HdfsConfiguration();
        BUF_SIZE = conf.getInt("io.file.buffer.size", 4096);
    }
}

