/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.collect.Iterables;
import io.hops.common.INodeUtil;
import io.hops.exception.StorageException;
import io.hops.metadata.hdfs.entity.INodeIdentifier;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestReadOnlySharedStorage {
    public static final Log LOG = LogFactory.getLog(TestReadOnlySharedStorage.class);
    private static short NUM_DATANODES = (short)3;
    private static int RO_NODE_INDEX = 0;
    private static final int BLOCK_SIZE = 1024;
    private static final long seed = 464384013L;
    private static final Path PATH = new Path("/" + TestReadOnlySharedStorage.class.getName() + ".dat");
    private static final int RETRIES = 10;
    private Configuration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem fs;
    private DFSClient client;
    private BlockManager blockManager;
    private FSNamesystem namesystem;
    private DatanodeManager datanodeManager;
    private DatanodeInfo normalDataNode;
    private DatanodeInfo readOnlyDataNode;
    private Block block;
    private ExtendedBlock extendedBlock;

    @Before
    public void setup() throws IOException, InterruptedException {
        int i;
        this.conf = new HdfsConfiguration();
        SimulatedFSDataset.setFactory(this.conf);
        Configuration[] overlays = new Configuration[NUM_DATANODES];
        for (i = 0; i < overlays.length; ++i) {
            overlays[i] = new Configuration();
            if (i != RO_NODE_INDEX) continue;
            overlays[i].setEnum("dfs.datanode.simulateddatastorage.state", (Enum)(i == RO_NODE_INDEX ? DatanodeStorage.State.READ_ONLY_SHARED : DatanodeStorage.State.NORMAL));
        }
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(NUM_DATANODES).dataNodeConfOverlays(overlays).format(true).build();
        this.fs = this.cluster.getFileSystem();
        this.blockManager = this.cluster.getNameNode().getNamesystem().getBlockManager();
        this.namesystem = this.cluster.getNameNode().getNamesystem();
        this.datanodeManager = this.blockManager.getDatanodeManager();
        this.client = new DFSClient(new InetSocketAddress("localhost", this.cluster.getNameNodePort()), this.cluster.getConfiguration(0));
        for (i = 0; i < NUM_DATANODES; ++i) {
            DataNode dataNode = this.cluster.getDataNodes().get(i);
            this.validateStorageState(BlockManagerTestUtil.getStorageReportsForDatanode(this.datanodeManager.getDatanode(dataNode.getDatanodeId())), i == RO_NODE_INDEX ? DatanodeStorage.State.READ_ONLY_SHARED : DatanodeStorage.State.NORMAL);
        }
        DFSTestUtil.createFile((FileSystem)this.fs, PATH, 1024, 1024L, 1024L, (short)1, 464384013L);
        LocatedBlock locatedBlock = this.getLocatedBlock();
        this.extendedBlock = locatedBlock.getBlock();
        this.block = this.extendedBlock.getLocalBlock();
        Assert.assertThat((Object)locatedBlock.getLocations().length, (Matcher)CoreMatchers.is((Object)1));
        this.normalDataNode = locatedBlock.getLocations()[0];
        this.readOnlyDataNode = this.datanodeManager.getDatanode(this.cluster.getDataNodes().get(RO_NODE_INDEX).getDatanodeId());
        Assert.assertThat((Object)this.normalDataNode, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)this.readOnlyDataNode)));
        this.validateNumberReplicas(1);
        this.cluster.injectBlocks(0, RO_NODE_INDEX, Collections.singleton(this.block));
        this.waitForLocations(2);
    }

    @After
    public void tearDown() throws IOException {
        this.fs.delete(PATH, false);
        if (this.cluster != null) {
            this.fs.close();
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void waitForLocations(int locations) throws IOException, InterruptedException {
        int tries = 0;
        while (tries < 10) {
            try {
                LocatedBlock locatedBlock = this.getLocatedBlock();
                Assert.assertThat((Object)locatedBlock.getLocations().length, (Matcher)CoreMatchers.is((Object)locations));
                break;
            }
            catch (AssertionError e) {
                if (++tries < 10) {
                    Thread.sleep(1000L);
                    continue;
                }
                throw e;
            }
        }
    }

    private LocatedBlock getLocatedBlock() throws IOException {
        LocatedBlocks locatedBlocks = this.client.getLocatedBlocks(PATH.toString(), 0L, 1024L);
        Assert.assertThat((Object)locatedBlocks.getLocatedBlocks().size(), (Matcher)CoreMatchers.is((Object)1));
        return (LocatedBlock)Iterables.getOnlyElement((Iterable)locatedBlocks.getLocatedBlocks());
    }

    private void validateStorageState(StorageReport[] storageReports, DatanodeStorage.State state) {
        for (StorageReport storageReport : storageReports) {
            DatanodeStorage storage = storageReport.getStorage();
            Assert.assertThat((Object)storage.getState(), (Matcher)CoreMatchers.is((Object)state));
        }
    }

    private void validateNumberReplicas(int expectedReplicas) throws IOException {
        NumberReplicas numberReplicas = TestReadOnlySharedStorage.countReplicas(this.namesystem, this.block);
        Assert.assertThat((Object)numberReplicas.liveReplicas(), (Matcher)CoreMatchers.is((Object)expectedReplicas));
        Assert.assertThat((Object)numberReplicas.excessReplicas(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)numberReplicas.corruptReplicas(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)numberReplicas.decommissionedReplicas(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)numberReplicas.replicasOnStaleNodes(), (Matcher)CoreMatchers.is((Object)0));
        BlockManagerTestUtil.updateState(this.blockManager);
        Assert.assertThat((Object)this.blockManager.getUnderReplicatedBlocksCount(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.blockManager.getExcessBlocksCount(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testReplicaCounting() throws Exception {
        this.validateNumberReplicas(1);
        this.fs.setReplication(PATH, (short)2);
        this.waitForLocations(3);
        this.validateNumberReplicas(2);
    }

    @Test
    public void testNormalReplicaOffline() throws Exception {
        Thread.sleep(5000L);
        this.cluster.stopDataNode(this.normalDataNode.getXferAddr());
        BlockManagerTestUtil.noticeDeadDatanode(this.cluster.getNameNode(), this.normalDataNode.getXferAddr());
        NumberReplicas numberReplicas = TestReadOnlySharedStorage.countReplicas(this.namesystem, this.block);
        Assert.assertThat((Object)numberReplicas.liveReplicas(), (Matcher)CoreMatchers.is((Object)0));
        BlockManagerTestUtil.updateState(this.blockManager);
        Assert.assertThat((Object)this.blockManager.getUnderReplicatedBlocksCount(), (Matcher)CoreMatchers.is((Object)1L));
        BlockManagerTestUtil.computeAllPendingWork(this.blockManager);
        DFSTestUtil.waitForReplication(this.cluster, this.extendedBlock, 1, 1, 0);
        Assert.assertThat((Object)this.getLocatedBlock().getLocations().length, (Matcher)CoreMatchers.is((Object)2));
        this.validateNumberReplicas(1);
    }

    @Test
    public void testReadOnlyReplicaCorrupt() throws Exception {
        this.client.reportBadBlocks(new LocatedBlock[]{new LocatedBlock(this.extendedBlock, new DatanodeInfo[]{this.readOnlyDataNode})});
        this.waitForLocations(1);
        NumberReplicas numberReplicas = TestReadOnlySharedStorage.countReplicas(this.namesystem, this.block);
        Assert.assertThat((Object)numberReplicas.corruptReplicas(), (Matcher)CoreMatchers.is((Object)0));
    }

    private static NumberReplicas countReplicas(final FSNamesystem namesystem, final Block block) throws IOException {
        return (NumberReplicas)new HopsTransactionalRequestHandler(HDFSOperationType.COUNT_NODES){
            INodeIdentifier inodeIdentifier;

            public void setUp() throws StorageException, IOException {
                this.inodeIdentifier = INodeUtil.resolveINodeFromBlock((Block)block);
            }

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getIndividualBlockLock(block.getBlockId(), this.inodeIdentifier)).add(lf.getBlockRelated(new LockFactory.BLK[]{LockFactory.BLK.RE, LockFactory.BLK.ER, LockFactory.BLK.CR}));
            }

            public Object performTask() throws StorageException, IOException {
                return namesystem.getBlockManager().countNodes(block);
            }
        }.handle((Object)namesystem);
    }
}

