/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FSXAttrBaseTest {
    private static final int MAX_SIZE = 16;
    protected static MiniDFSCluster dfsCluster;
    protected static Configuration conf;
    private static int pathCount;
    private static Path path;
    protected static final String name1 = "user.a1";
    protected static final byte[] value1;
    protected static final byte[] newValue1;
    protected static final String name2 = "user.a2";
    protected static final byte[] value2;
    protected static final String name3 = "user.a3";
    protected static final String name4 = "user.a4";
    protected FileSystem fs;

    @BeforeClass
    public static void init() throws Exception {
        conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.xattrs.enabled", true);
        conf.setInt("dfs.namenode.fs-limits.max-xattrs-per-inode", 3);
        conf.setInt("dfs.namenode.fs-limits.max-xattr-size", 16);
        FSXAttrBaseTest.initCluster(true);
    }

    @AfterClass
    public static void shutdown() {
        if (dfsCluster != null) {
            dfsCluster.shutdown();
        }
    }

    @Before
    public void setUp() throws Exception {
        path = new Path("/p" + ++pathCount);
        this.initFileSystem();
    }

    @After
    public void destroyFileSystems() {
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{this.fs});
        this.fs = null;
    }

    @Test(timeout=120000L)
    public void testCreateXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        Map xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)0L);
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        try {
            this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
            Assert.fail((String)"Creating xattr which already exists should fail.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fs.removeXAttr(path, name1);
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, null, EnumSet.of(XAttrSetFlag.CREATE));
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
    }

    @Test(timeout=120000L)
    public void testReplaceXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name1, newValue1, EnumSet.of(XAttrSetFlag.REPLACE));
        Map xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        try {
            this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.REPLACE));
            Assert.fail((String)"Replacing xattr which does not exist should fail.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, null, EnumSet.of(XAttrSetFlag.REPLACE));
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name2)));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
    }

    @Test(timeout=120000L)
    public void testSetXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        Map xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        try {
            this.fs.setXAttr(path, null, value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
            Assert.fail((String)"Setting xattr with null name should fail.");
        }
        catch (NullPointerException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr name cannot be null", (Throwable)e);
        }
        catch (RemoteException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr name cannot be null", (Throwable)e);
        }
        try {
            this.fs.setXAttr(path, "user.", value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
            Assert.fail((String)"Setting xattr with empty name should fail.");
        }
        catch (HadoopIllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr name cannot be empty", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid value: \"user.\" does not belong to the domain ^(user\\.|trusted\\.|system\\.|security\\.).+", (Throwable)e);
        }
        try {
            this.fs.setXAttr(path, "a1", value1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
            Assert.fail((String)"Setting xattr with invalid name prefix or without name prefix should fail.");
        }
        catch (HadoopIllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr name must be prefixed", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid value: \"a1\" does not belong to the domain ^(user\\.|trusted\\.|system\\.|security\\.).+", (Throwable)e);
        }
        this.fs.setXAttr(path, name1, value1);
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name1, newValue1, EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE));
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])newValue1, (byte[])((byte[])xattrs.get(name1)));
        this.fs.removeXAttr(path, name1);
        this.fs.setXAttr(path, name1, value1);
        this.fs.setXAttr(path, name2, value2);
        this.fs.setXAttr(path, name3, null);
        try {
            this.fs.setXAttr(path, name4, null);
            Assert.fail((String)"Setting xattr should fail if total number of xattrs for inode exceeds max limit.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Cannot add additional XAttr", (Throwable)e);
        }
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        this.fs.removeXAttr(path, name3);
        String longName = "user.0123456789abcdefX";
        try {
            this.fs.setXAttr(path, longName, null);
            Assert.fail((String)"Setting xattr should fail if name is too long.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr is too big", (Throwable)e);
            GenericTestUtils.assertExceptionContains((String)"total size is 17", (Throwable)e);
        }
        byte[] longValue = new byte[16];
        try {
            this.fs.setXAttr(path, "user.a", longValue);
            Assert.fail((String)"Setting xattr should fail if value is too long.");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"XAttr is too big", (Throwable)e);
            GenericTestUtils.assertExceptionContains((String)"total size is 17", (Throwable)e);
        }
        String name = "user.111";
        byte[] value = new byte[13];
        this.fs.setXAttr(path, name, value);
    }

    @Test(timeout=120000L)
    public void testGetXAttrs() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        byte[] value = this.fs.getXAttr(path, name3);
        Assert.assertEquals((Object)value, null);
        ArrayList names = Lists.newArrayList();
        names.add(name1);
        names.add(name2);
        names.add(name3);
        Map xattrs = this.fs.getXAttrs(path, (List)names);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
    }

    @Test(timeout=120000L)
    public void testRemoveXAttr() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name3, null, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        Map xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name3)));
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name3)));
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)1L);
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])((byte[])xattrs.get(name3)));
        this.fs.removeXAttr(path, name3);
    }

    @Test(timeout=120000L)
    public void testCleanupXAttrs() throws Exception {
        FileSystem.mkdirs((FileSystem)this.fs, (Path)path, (FsPermission)FsPermission.createImmutable((short)488));
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        FSXAttrBaseTest.restart(true);
        this.initFileSystem();
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        FSXAttrBaseTest.restart(false);
        this.initFileSystem();
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.removeXAttr(path, name1);
        this.fs.removeXAttr(path, name2);
        this.fs.setXAttr(path, name1, value1, EnumSet.of(XAttrSetFlag.CREATE));
        this.fs.setXAttr(path, name2, value2, EnumSet.of(XAttrSetFlag.CREATE));
        Map xattrs = this.fs.getXAttrs(path);
        Assert.assertEquals((long)xattrs.size(), (long)2L);
        Assert.assertArrayEquals((byte[])value1, (byte[])((byte[])xattrs.get(name1)));
        Assert.assertArrayEquals((byte[])value2, (byte[])((byte[])xattrs.get(name2)));
    }

    protected FileSystem createFileSystem() throws Exception {
        return dfsCluster.getFileSystem();
    }

    private void initFileSystem() throws Exception {
        this.fs = this.createFileSystem();
    }

    protected static void initCluster(boolean format) throws Exception {
        dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).format(format).build();
        dfsCluster.waitActive();
    }

    protected static void restart(boolean checkpoint) throws Exception {
        NameNode nameNode = dfsCluster.getNameNode();
        if (checkpoint) {
            NameNodeAdapter.enterSafeMode(nameNode, false);
        }
        FSXAttrBaseTest.shutdown();
        FSXAttrBaseTest.initCluster(false);
    }

    static {
        pathCount = 0;
        value1 = new byte[]{49, 50, 51};
        newValue1 = new byte[]{49, 49, 49};
        value2 = new byte[]{55, 56, 57};
    }
}

