/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHDFSConcat {
    public static final Log LOG = LogFactory.getLog(TestHDFSConcat.class);
    private static final short REPL_FACTOR = 2;
    private MiniDFSCluster cluster;
    private NamenodeProtocols nn;
    private DistributedFileSystem dfs;
    private static long blockSize = 512L;
    private static Configuration conf = new Configuration();

    @Before
    public void startUpCluster() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        Assert.assertNotNull((String)"Failed Cluster Creation", (Object)this.cluster);
        this.cluster.waitClusterUp();
        this.dfs = this.cluster.getFileSystem();
        Assert.assertNotNull((String)"Failed to get FileSystem", (Object)this.dfs);
        this.nn = this.cluster.getNameNodeRpc();
        Assert.assertNotNull((String)"Failed to get NameNode", (Object)this.nn);
    }

    @After
    public void shutDownCluster() throws IOException {
        if (this.dfs != null) {
            this.dfs.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdownDataNodes();
            this.cluster.shutdown();
        }
    }

    @Test
    public void testConcat() throws IOException, InterruptedException {
        FSDataInputStream stm;
        int i;
        int numFiles = 10;
        long fileLen = blockSize * 3L;
        String trg = "/trg";
        Path trgPath = new Path(trg);
        DFSTestUtil.createFile((FileSystem)this.dfs, trgPath, fileLen, (short)2, 1L);
        HdfsFileStatus fStatus = this.nn.getFileInfo(trg);
        long trgLen = fStatus.getLen();
        long trgBlocks = this.nn.getBlockLocations(trg, 0L, trgLen).locatedBlockCount();
        Path[] files = new Path[10];
        byte[][] bytes = new byte[10][(int)fileLen];
        LocatedBlocks[] lblocks = new LocatedBlocks[10];
        long[] lens = new long[10];
        for (i = 0; i < files.length; ++i) {
            files[i] = new Path("/file" + i);
            Path path = files[i];
            System.out.println("Creating file " + path);
            DFSTestUtil.createFile((FileSystem)this.dfs, path, fileLen, (short)2, 1L);
            fStatus = this.nn.getFileInfo(path.toUri().getPath());
            lens[i] = fStatus.getLen();
            Assert.assertEquals((long)trgLen, (long)lens[i]);
            lblocks[i] = this.nn.getBlockLocations(path.toUri().getPath(), 0L, lens[i]);
            stm = this.dfs.open(path);
            stm.readFully(0L, bytes[i]);
            stm.close();
        }
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"theDoctor", (String[])new String[]{"tardis"});
        DistributedFileSystem hdfs = (DistributedFileSystem)DFSTestUtil.getFileSystemAs(user1, conf);
        try {
            hdfs.concat(trgPath, files);
            Assert.fail((String)"Permission exception expected");
        }
        catch (IOException ie) {
            System.out.println("Got expected exception for permissions:" + ie.getLocalizedMessage());
        }
        ContentSummary cBefore = this.dfs.getContentSummary(trgPath.getParent());
        this.dfs.concat(trgPath, files);
        ContentSummary cAfter = this.dfs.getContentSummary(trgPath.getParent());
        Assert.assertEquals((long)cBefore.getFileCount(), (long)(cAfter.getFileCount() + (long)files.length));
        long totalLen = trgLen;
        long totalBlocks = trgBlocks;
        for (i = 0; i < files.length; ++i) {
            totalLen += lens[i];
            totalBlocks += (long)lblocks[i].locatedBlockCount();
        }
        System.out.println("total len=" + totalLen + "; totalBlocks=" + totalBlocks);
        fStatus = this.nn.getFileInfo(trg);
        trgLen = fStatus.getLen();
        stm = this.dfs.open(trgPath);
        byte[] byteFileConcat = new byte[(int)trgLen];
        stm.readFully(0L, byteFileConcat);
        stm.close();
        trgBlocks = this.nn.getBlockLocations(trg, 0L, trgLen).locatedBlockCount();
        Assert.assertEquals((long)trgBlocks, (long)totalBlocks);
        Assert.assertEquals((long)trgLen, (long)totalLen);
        for (Path p : files) {
            fStatus = this.nn.getFileInfo(p.toUri().getPath());
            Assert.assertNull((String)("File " + p + " still exists"), (Object)fStatus);
            DFSTestUtil.createFile((FileSystem)this.dfs, p, fileLen, (short)2, 1L);
        }
        this.checkFileContent(byteFileConcat, bytes);
        Path smallFile = new Path("/sfile");
        int sFileLen = 10;
        DFSTestUtil.createFile((FileSystem)this.dfs, smallFile, sFileLen, (short)2, 1L);
        this.dfs.concat(trgPath, new Path[]{smallFile});
        fStatus = this.nn.getFileInfo(trg);
        trgLen = fStatus.getLen();
        trgBlocks = this.nn.getBlockLocations(trg, 0L, trgLen).locatedBlockCount();
        Assert.assertEquals((long)trgBlocks, (long)(totalBlocks + 1L));
        Assert.assertEquals((long)trgLen, (long)(totalLen + (long)sFileLen));
    }

    @Test
    public void testConcatInEditLog() throws Exception {
        Path TEST_DIR = new Path("/testConcatInEditLog");
        long FILE_LEN = blockSize;
        Path[] srcFiles = new Path[3];
        for (int i = 0; i < srcFiles.length; ++i) {
            Path path = new Path(TEST_DIR, "src-" + i);
            DFSTestUtil.createFile((FileSystem)this.dfs, path, FILE_LEN, (short)2, 1L);
            srcFiles[i] = path;
        }
        Path targetFile = new Path(TEST_DIR, "target");
        DFSTestUtil.createFile((FileSystem)this.dfs, targetFile, FILE_LEN, (short)2, 1L);
        this.dfs.concat(targetFile, srcFiles);
        Assert.assertTrue((boolean)this.dfs.exists(targetFile));
        FileStatus origStatus = this.dfs.getFileStatus(targetFile);
        this.cluster.restartNameNode(true);
        Assert.assertTrue((boolean)this.dfs.exists(targetFile));
        Assert.assertFalse((boolean)this.dfs.exists(srcFiles[0]));
        FileStatus statusAfterRestart = this.dfs.getFileStatus(targetFile);
        Assert.assertEquals((long)origStatus.getModificationTime(), (long)statusAfterRestart.getModificationTime());
    }

    private void checkFileContent(byte[] concat, byte[][] bytes) {
        int idx = 0;
        boolean mismatch = false;
        byte[][] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] bb;
            for (byte b : bb = byArray[i]) {
                if (b == concat[idx++]) continue;
                mismatch = true;
                break;
            }
            if (mismatch) break;
        }
        Assert.assertFalse((String)"File content of concatenated file is different", (boolean)mismatch);
    }

    @Test
    public void testConcatNotCompleteBlock() throws IOException {
        long trgFileLen = blockSize * 3L;
        long srcFileLen = blockSize * 3L + 20L;
        String name1 = "/trg";
        String name2 = "/src";
        Path filePath1 = new Path(name1);
        DFSTestUtil.createFile((FileSystem)this.dfs, filePath1, trgFileLen, (short)2, 1L);
        HdfsFileStatus fStatus = this.nn.getFileInfo(name1);
        long fileLen = fStatus.getLen();
        Assert.assertEquals((long)fileLen, (long)trgFileLen);
        FSDataInputStream stm = this.dfs.open(filePath1);
        byte[] byteFile1 = new byte[(int)trgFileLen];
        stm.readFully(0L, byteFile1);
        stm.close();
        LocatedBlocks lb1 = this.nn.getBlockLocations(name1, 0L, trgFileLen);
        Path filePath2 = new Path(name2);
        DFSTestUtil.createFile((FileSystem)this.dfs, filePath2, srcFileLen, (short)2, 1L);
        fStatus = this.nn.getFileInfo(name2);
        fileLen = fStatus.getLen();
        Assert.assertEquals((long)srcFileLen, (long)fileLen);
        stm = this.dfs.open(filePath2);
        byte[] byteFile2 = new byte[(int)srcFileLen];
        stm.readFully(0L, byteFile2);
        stm.close();
        LocatedBlocks lb2 = this.nn.getBlockLocations(name2, 0L, srcFileLen);
        System.out.println("trg len=" + trgFileLen + "; src len=" + srcFileLen);
        this.dfs.concat(filePath1, new Path[]{filePath2});
        long totalLen = trgFileLen + srcFileLen;
        fStatus = this.nn.getFileInfo(name1);
        fileLen = fStatus.getLen();
        stm = this.dfs.open(filePath1);
        byte[] byteFileConcat = new byte[(int)fileLen];
        stm.readFully(0L, byteFileConcat);
        stm.close();
        LocatedBlocks lbConcat = this.nn.getBlockLocations(name1, 0L, fileLen);
        Assert.assertEquals((long)lbConcat.locatedBlockCount(), (long)(lb1.locatedBlockCount() + lb2.locatedBlockCount()));
        System.out.println("file1 len=" + fileLen + "; total len=" + totalLen);
        Assert.assertEquals((long)fileLen, (long)totalLen);
        fStatus = this.nn.getFileInfo(name2);
        Assert.assertNull((String)("File " + name2 + "still exists"), (Object)fStatus);
        this.checkFileContent(byteFileConcat, new byte[][]{byteFile1, byteFile2});
    }

    @Test
    public void testIllegalArg() throws IOException {
        long fileLen = blockSize * 3L;
        Path parentDir = new Path("/parentTrg");
        Assert.assertTrue((boolean)this.dfs.mkdirs(parentDir));
        Path trg = new Path(parentDir, "trg");
        DFSTestUtil.createFile((FileSystem)this.dfs, trg, fileLen, (short)2, 1L);
        Path dir22 = new Path("/dir1");
        Assert.assertTrue((boolean)this.dfs.mkdirs(dir22));
        Path src = new Path(dir22, "src");
        DFSTestUtil.createFile((FileSystem)this.dfs, src, fileLen, (short)2, 1L);
        try {
            this.dfs.concat(trg, new Path[]{src});
            Assert.fail((String)"didn't fail for src and trg in different directories");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dfs.concat(trg, new Path[]{new Path("test1/a")});
            Assert.fail((String)"didn't fail with invalid arguments");
        }
        catch (Exception dir22) {
            // empty catch block
        }
        try {
            this.dfs.concat(trg, new Path[0]);
            Assert.fail((String)"didn't fail with invalid arguments");
        }
        catch (Exception dir22) {
            // empty catch block
        }
        Path src1 = new Path(parentDir, "src1");
        DFSTestUtil.createFile((FileSystem)this.dfs, src1, fileLen, (short)2, 0L);
        Path src2 = new Path(parentDir, "src2");
        DFSTestUtil.createFile((FileSystem)this.dfs, src2, 1024, fileLen, this.dfs.getDefaultBlockSize(trg) * 2L, (short)2, 0L);
        try {
            this.dfs.concat(trg, new Path[]{src1, src2});
            Assert.fail((String)"didn't fail for src with greater preferred block size");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"preferred block size", (Throwable)e);
        }
    }

    @Test
    public void testConcatWithQuotaDecrease() throws IOException {
        int srcRepl = 3;
        int srcNum = 10;
        Path foo = new Path("/foo");
        Path[] srcs = new Path[10];
        Path target = new Path(foo, "target");
        DFSTestUtil.createFile((FileSystem)this.dfs, target, blockSize, (short)2, 0L);
        this.dfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        for (int i = 0; i < 10; ++i) {
            srcs[i] = new Path(foo, "src" + i);
            DFSTestUtil.createFile((FileSystem)this.dfs, srcs[i], blockSize * 2L, (short)3, 0L);
        }
        ContentSummary summary = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)11L, (long)summary.getFileCount());
        Assert.assertEquals((long)(blockSize * 2L + blockSize * 2L * 3L * 10L), (long)summary.getSpaceConsumed());
        this.dfs.concat(target, srcs);
        summary = this.dfs.getContentSummary(foo);
        Assert.assertEquals((long)1L, (long)summary.getFileCount());
        Assert.assertEquals((long)(blockSize * 2L + blockSize * 2L * 2L * 10L), (long)summary.getSpaceConsumed());
    }

    @Test
    public void testConcatWithQuotaIncrease() throws IOException {
        int repl = 3;
        int srcNum = 10;
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        Path[] srcs = new Path[10];
        Path target = new Path(bar, "target");
        DFSTestUtil.createFile((FileSystem)this.dfs, target, blockSize, (short)3, 0L);
        long dsQuota = blockSize * 3L + blockSize * 10L * 2L;
        this.dfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, dsQuota);
        for (int i = 0; i < 10; ++i) {
            srcs[i] = new Path(bar, "src" + i);
            DFSTestUtil.createFile((FileSystem)this.dfs, srcs[i], blockSize, (short)2, 0L);
        }
        ContentSummary summary = this.dfs.getContentSummary(bar);
        Assert.assertEquals((long)11L, (long)summary.getFileCount());
        Assert.assertEquals((long)dsQuota, (long)summary.getSpaceConsumed());
        try {
            this.dfs.concat(target, srcs);
            Assert.fail((String)"QuotaExceededException expected");
        }
        catch (RemoteException e) {
            Assert.assertTrue((boolean)(e.unwrapRemoteException() instanceof QuotaExceededException));
        }
        this.dfs.setQuota(foo, 0x7FFFFFFFFFFFFFFEL, 0x7FFFFFFFFFFFFFFEL);
        this.dfs.concat(target, srcs);
        summary = this.dfs.getContentSummary(bar);
        Assert.assertEquals((long)1L, (long)summary.getFileCount());
        Assert.assertEquals((long)(blockSize * 3L * 11L), (long)summary.getSpaceConsumed());
    }

    static {
        conf.setLong("dfs.blocksize", blockSize);
    }
}

