/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.startupprogress;

import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgress;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressMetrics;
import org.apache.hadoop.hdfs.server.namenode.startupprogress.StartupProgressTestHelper;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStartupProgressMetrics {
    private StartupProgress startupProgress;
    private StartupProgressMetrics metrics;

    @Before
    public void setUp() {
        MetricsAsserts.mockMetricsSystem();
        this.startupProgress = new StartupProgress();
        this.metrics = new StartupProgressMetrics(this.startupProgress);
    }

    @Test
    public void testInitialState() {
        MetricsRecordBuilder builder = MetricsAsserts.getMetrics((MetricsSource)this.metrics, (boolean)true);
        MetricsAsserts.assertCounter((String)"ElapsedTime", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"PercentComplete", (float)0.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeCount", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeElapsedTime", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeTotal", (long)0L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"SafeModePercentComplete", (float)0.0f, (MetricsRecordBuilder)builder);
    }

    @Test
    public void testFinalState() {
        StartupProgressTestHelper.setStartupProgressForFinalState(this.startupProgress);
        MetricsRecordBuilder builder = MetricsAsserts.getMetrics((MetricsSource)this.metrics, (boolean)true);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"ElapsedTime", (MetricsRecordBuilder)builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertGauge((String)"PercentComplete", (float)1.0f, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertCounter((String)"SafeModeCount", (long)400L, (MetricsRecordBuilder)builder);
        Assert.assertTrue((MetricsAsserts.getLongCounter((String)"SafeModeElapsedTime", (MetricsRecordBuilder)builder) >= 0L ? 1 : 0) != 0);
        MetricsAsserts.assertCounter((String)"SafeModeTotal", (long)400L, (MetricsRecordBuilder)builder);
        MetricsAsserts.assertGauge((String)"SafeModePercentComplete", (float)1.0f, (MetricsRecordBuilder)builder);
    }
}

