/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsTracer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.tracing.SetSpanReceiver;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.htrace.core.TraceScope;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTracingShortCircuitLocalRead {
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private static TemporarySocketDirectory sockDir;
    static final Path TEST_PATH;
    static final int TEST_LENGTH = 1234;

    @BeforeClass
    public static void init() {
        sockDir = new TemporarySocketDirectory();
        DomainSocket.disableBindPathValidation();
    }

    @AfterClass
    public static void shutdown() throws IOException {
        sockDir.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShortCircuitTraceHooks() throws IOException {
        Assume.assumeTrue((NativeCodeLoader.isNativeCodeLoaded() && !Path.WINDOWS ? 1 : 0) != 0);
        conf = new Configuration();
        conf.set("hadoop.htrace.span.receiver.classes", SetSpanReceiver.class.getName());
        conf.set("hadoop.htrace.sampler.classes", "AlwaysSampler");
        conf.setLong("dfs.blocksize", 102400L);
        conf.setBoolean("dfs.client.read.shortcircuit", true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "testShortCircuitTraceHooks._PORT.sock").getAbsolutePath());
        conf.set("dfs.checksum.type", "CRC32C");
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        dfs = cluster.getFileSystem();
        try {
            DFSTestUtil.createFile((FileSystem)dfs, TEST_PATH, 1234L, (short)1, 5678L);
            TraceScope ts = FsTracer.get((Configuration)conf).newScope("testShortCircuitTraceHooks");
            FSDataInputStream stream = dfs.open(TEST_PATH);
            byte[] buf = new byte[1234];
            IOUtils.readFully((InputStream)stream, (byte[])buf, (int)0, (int)1234);
            stream.close();
            ts.close();
            String[] expectedSpanNames = new String[]{"OpRequestShortCircuitAccessProto", "ShortCircuitShmRequestProto"};
            SetSpanReceiver.assertSpanNamesFound((String[])expectedSpanNames);
        }
        finally {
            dfs.close();
            cluster.shutdown();
        }
    }

    static {
        TEST_PATH = new Path("testShortCircuitTraceHooks");
    }
}

