/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.adaptor;

import io.hops.exception.StorageException;
import io.hops.metadata.DalAdaptor;
import io.hops.metadata.hdfs.dal.BlockInfoDataAccess;
import io.hops.metadata.hdfs.entity.BlockInfo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguousUnderConstruction;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;

public class BlockInfoDALAdaptor
extends DalAdaptor<BlockInfoContiguous, BlockInfo>
implements BlockInfoDataAccess<BlockInfoContiguous> {
    private final BlockInfoDataAccess<BlockInfo> dataAccess;

    public BlockInfoDALAdaptor(BlockInfoDataAccess<BlockInfo> dataAccess) {
        this.dataAccess = dataAccess;
    }

    public int countAll() throws StorageException {
        return this.dataAccess.countAll();
    }

    public int countAllCompleteBlocks() throws StorageException {
        return this.dataAccess.countAllCompleteBlocks();
    }

    public BlockInfoContiguous findById(long blockId, long inodeId) throws StorageException {
        return this.convertDALtoHDFS((BlockInfo)this.dataAccess.findById(blockId, inodeId));
    }

    public List<BlockInfoContiguous> findByInodeId(long id) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findByInodeId(id));
    }

    public List<BlockInfoContiguous> findByInodeIds(long[] inodeIds) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findByInodeIds(inodeIds));
    }

    public List<BlockInfoContiguous> findAllBlocks() throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findAllBlocks());
    }

    public List<BlockInfoContiguous> findBlockInfosByStorageId(int storageId) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findBlockInfosByStorageId(storageId));
    }

    public List<BlockInfoContiguous> findBlockInfosByStorageId(int storageId, long from, int size) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findBlockInfosByStorageId(storageId, from, size));
    }

    public List<BlockInfoContiguous> findBlockInfosBySids(List<Integer> sids) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findBlockInfosBySids(sids));
    }

    public Set<Long> findINodeIdsByStorageId(int storageId) throws StorageException {
        return this.dataAccess.findINodeIdsByStorageId(storageId);
    }

    public List<BlockInfoContiguous> findByIds(long[] blockIds, long[] inodeIds) throws StorageException {
        return (List)this.convertDALtoHDFS(this.dataAccess.findByIds(blockIds, inodeIds));
    }

    public boolean existsOnAnyStorage(long inodeId, long blockId, List<Integer> sids) throws StorageException {
        return this.dataAccess.existsOnAnyStorage(inodeId, blockId, sids);
    }

    public void prepare(Collection<BlockInfoContiguous> removed, Collection<BlockInfoContiguous> newed, Collection<BlockInfoContiguous> modified) throws StorageException {
        this.dataAccess.prepare(this.convertHDFStoDAL(removed), this.convertHDFStoDAL(newed), this.convertHDFStoDAL(modified));
    }

    public BlockInfo convertHDFStoDAL(BlockInfoContiguous hdfsClass) throws StorageException {
        if (hdfsClass != null) {
            BlockInfo hopBlkInfo = new BlockInfo(hdfsClass.getBlockId(), hdfsClass.getBlockIndex(), hdfsClass.getInodeId(), hdfsClass.getNumBytes(), hdfsClass.getGenerationStamp(), hdfsClass.getBlockUCState().ordinal(), hdfsClass.getTimestamp());
            if (hdfsClass instanceof BlockInfoContiguousUnderConstruction) {
                BlockInfoContiguousUnderConstruction ucBlock = (BlockInfoContiguousUnderConstruction)hdfsClass;
                hopBlkInfo.setPrimaryNodeIndex(ucBlock.getPrimaryNodeIndex());
                hopBlkInfo.setBlockRecoveryId(ucBlock.getBlockRecoveryId());
                Block truncateBlock = ucBlock.getTruncateBlock();
                if (truncateBlock != null) {
                    hopBlkInfo.setTruncateBlockGenerationStamp(truncateBlock.getGenerationStamp());
                    hopBlkInfo.setTruncateBlockNumBytes(truncateBlock.getNumBytes());
                }
            }
            return hopBlkInfo;
        }
        return null;
    }

    public BlockInfoContiguous convertDALtoHDFS(BlockInfo dalClass) throws StorageException {
        if (dalClass != null) {
            Block b = new Block(dalClass.getBlockId(), dalClass.getNumBytes(), dalClass.getGenerationStamp());
            BlockInfoContiguous blockInfo = null;
            if (dalClass.getBlockUCState() > 0) {
                blockInfo = new BlockInfoContiguousUnderConstruction(b, dalClass.getInodeId());
                ((BlockInfoContiguousUnderConstruction)blockInfo).setBlockUCStateNoPersistance(HdfsServerConstants.BlockUCState.values()[dalClass.getBlockUCState()]);
                ((BlockInfoContiguousUnderConstruction)blockInfo).setPrimaryNodeIndexNoPersistance(dalClass.getPrimaryNodeIndex());
                ((BlockInfoContiguousUnderConstruction)blockInfo).setBlockRecoveryIdNoPersistance(dalClass.getBlockRecoveryId());
                if (dalClass.getTruncateBlockNumBytes() > 0L) {
                    Block truncateBlock = new Block(dalClass.getBlockId(), dalClass.getTruncateBlockNumBytes(), dalClass.getTruncateBlockGenerationStamp());
                    ((BlockInfoContiguousUnderConstruction)blockInfo).setTruncateBlock(truncateBlock);
                }
            } else if (dalClass.getBlockUCState() == HdfsServerConstants.BlockUCState.COMPLETE.ordinal()) {
                blockInfo = new BlockInfoContiguous(b, dalClass.getInodeId());
            } else {
                return null;
            }
            blockInfo.setINodeIdNoPersistance(dalClass.getInodeId());
            blockInfo.setTimestampNoPersistance(dalClass.getTimeStamp());
            blockInfo.setBlockIndexNoPersistance(dalClass.getBlockIndex());
            return blockInfo;
        }
        return null;
    }
}

