/*
 * Decompiled with CFR 0.152.
 */
package io.hops.metadata.security.token.block;

import io.hops.exception.StorageException;
import io.hops.metadata.HdfsVariables;
import io.hops.metadata.common.entity.Variable;
import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.hadoop.hdfs.security.token.block.BlockKey;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.util.Time;

public class NameNodeBlockTokenSecretManager
extends BlockTokenSecretManager {
    private Namesystem namesystem;

    public NameNodeBlockTokenSecretManager(long keyUpdateInterval, long tokenLifetime, String blockPoolId, String encryptionAlgorithm, Namesystem namesystem) throws IOException {
        super(true, keyUpdateInterval, tokenLifetime, blockPoolId, encryptionAlgorithm);
        this.namesystem = namesystem;
        this.setSerialNo(new SecureRandom().nextInt());
        if (this.isLeader()) {
            this.generateKeys();
        } else {
            this.retrieveBlockKeys();
        }
    }

    @Override
    public void setSerialNo(int serialNo) {
        this.serialNo = serialNo;
    }

    private void generateKeys() throws IOException {
        if (!this.isMaster) {
            return;
        }
        this.setSerialNo(this.serialNo + 1);
        this.currentKey = new BlockKey(this.serialNo, Time.now() + 2L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret());
        this.currentKey.setKeyType(BlockKey.KeyType.CurrKey);
        this.setSerialNo(this.serialNo + 1);
        this.nextKey = new BlockKey(this.serialNo, Time.now() + 3L * this.keyUpdateInterval + this.tokenLifetime, this.generateSecret());
        this.nextKey.setKeyType(BlockKey.KeyType.NextKey);
        this.addBlockKeys();
    }

    @Override
    public ExportedBlockKeys exportKeys() throws IOException {
        if (!this.isMaster) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Exporting access keys");
        }
        BlockKey[] allKeys = this.getAllKeysAndSync();
        return new ExportedBlockKeys(true, this.keyUpdateInterval, this.tokenLifetime, this.currentKey, allKeys);
    }

    @Override
    public boolean updateKeys(long updateTime) throws IOException {
        if (updateTime > this.keyUpdateInterval) {
            return this.updateKeys();
        }
        return false;
    }

    @Override
    public boolean updateKeys() throws IOException {
        if (!this.isMaster) {
            return false;
        }
        if (this.isLeader()) {
            LOG.info((Object)"Updating block keys");
            return this.updateBlockKeys();
        }
        this.retrieveBlockKeys();
        return true;
    }

    @Override
    public DataEncryptionKey generateDataEncryptionKey() throws IOException {
        byte[] nonce = new byte[8];
        this.nonceGenerator.nextBytes(nonce);
        BlockKey key = this.getBlockKeyByType(BlockKey.KeyType.CurrKey);
        byte[] encryptionKey = NameNodeBlockTokenSecretManager.createPassword((byte[])nonce, (SecretKey)key.getKey());
        return new DataEncryptionKey(key.getKeyId(), this.blockPoolId, nonce, encryptionKey, Time.now() + this.tokenLifetime, this.encryptionAlgorithm);
    }

    @Override
    protected byte[] createPassword(BlockTokenIdentifier identifier) {
        BlockKey key;
        try {
            key = this.getBlockKeyByType(BlockKey.KeyType.CurrKey);
        }
        catch (IOException ex) {
            throw new IllegalStateException("currentKey hasn't been initialized. [" + ex.getMessage() + "]");
        }
        if (key == null) {
            throw new IllegalStateException("currentKey hasn't been initialized.");
        }
        identifier.setExpiryDate(Time.now() + this.tokenLifetime);
        identifier.setKeyId(key.getKeyId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Generating block token for " + identifier.toString()));
        }
        return NameNodeBlockTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)key.getKey());
    }

    @Override
    public byte[] retrievePassword(BlockTokenIdentifier identifier) throws SecretManager.InvalidToken {
        if (NameNodeBlockTokenSecretManager.isExpired(identifier.getExpiryDate())) {
            throw new SecretManager.InvalidToken("Block token with " + identifier.toString() + " is expired.");
        }
        BlockKey key = null;
        try {
            key = this.getBlockKeyById(identifier.getKeyId());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (key == null) {
            throw new SecretManager.InvalidToken("Can't re-compute password for " + identifier.toString() + ", since the required block key (keyID=" + identifier.getKeyId() + ") doesn't exist.");
        }
        return NameNodeBlockTokenSecretManager.createPassword((byte[])identifier.getBytes(), (SecretKey)key.getKey());
    }

    public void generateKeysIfNeeded() throws IOException {
        if (this.isLeader()) {
            this.retrieveBlockKeys();
            if (this.currentKey == null && this.nextKey == null) {
                this.generateKeys();
            }
        }
    }

    private void retrieveBlockKeys() throws IOException {
        this.currentKey = this.getBlockKeyByType(BlockKey.KeyType.CurrKey);
        this.nextKey = this.getBlockKeyByType(BlockKey.KeyType.NextKey);
    }

    private void addBlockKeys() throws IOException {
        new HopsTransactionalRequestHandler(HDFSOperationType.ADD_BLOCK_TOKENS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.BlockTokenKeys, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                HdfsVariables.updateBlockTokenKeys(NameNodeBlockTokenSecretManager.this.currentKey, NameNodeBlockTokenSecretManager.this.nextKey);
                return null;
            }
        }.handle();
    }

    private BlockKey getBlockKeyById(int keyId) throws IOException {
        return HdfsVariables.getAllBlockTokenKeysByIDLW().get(keyId);
    }

    private BlockKey getBlockKeyByType(BlockKey.KeyType keytype) throws IOException {
        return HdfsVariables.getAllBlockTokenKeysByTypeLW().get(keytype.ordinal());
    }

    private BlockKey[] getAllKeysAndSync() throws IOException {
        BlockKey[] allKeysArr = null;
        Collection<BlockKey> allKeys = this.getAllKeys();
        if (allKeys != null) {
            for (BlockKey key : allKeys) {
                if (key.isCurrKey()) {
                    this.currentKey = key;
                    continue;
                }
                if (!key.isNextKey()) continue;
                this.nextKey = key;
            }
            allKeysArr = allKeys.toArray(new BlockKey[allKeys.size()]);
        }
        return allKeysArr;
    }

    private Collection<BlockKey> getAllKeys() throws IOException {
        return HdfsVariables.getAllBlockTokenKeysByIDLW().values();
    }

    private boolean updateBlockKeys() throws IOException {
        return (Boolean)new HopsTransactionalRequestHandler(HDFSOperationType.UPDATE_BLOCK_KEYS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                locks.add(lf.getVariableLock(Variable.Finder.BlockTokenKeys, TransactionLockTypes.LockType.WRITE));
            }

            public Object performTask() throws StorageException, IOException {
                Map<Integer, BlockKey> keys = HdfsVariables.getAllBlockTokenKeysByType();
                if (keys.isEmpty()) {
                    if (BlockTokenSecretManager.LOG.isDebugEnabled()) {
                        BlockTokenSecretManager.LOG.debug((Object)"keys is not generated yet to be updated");
                    }
                    return false;
                }
                BlockKey currentKeyFromDB = keys.get(BlockKey.KeyType.CurrKey.ordinal());
                currentKeyFromDB.setExpiryDate(Time.now() + NameNodeBlockTokenSecretManager.this.keyUpdateInterval + NameNodeBlockTokenSecretManager.this.tokenLifetime);
                currentKeyFromDB.setKeyType(BlockKey.KeyType.SimpleKey);
                BlockKey nextKeyFromDB = keys.get(BlockKey.KeyType.NextKey.ordinal());
                NameNodeBlockTokenSecretManager.this.currentKey = new BlockKey(nextKeyFromDB.getKeyId(), Time.now() + 2L * NameNodeBlockTokenSecretManager.this.keyUpdateInterval + NameNodeBlockTokenSecretManager.this.tokenLifetime, nextKeyFromDB.getKey());
                NameNodeBlockTokenSecretManager.this.currentKey.setKeyType(BlockKey.KeyType.CurrKey);
                NameNodeBlockTokenSecretManager.this.setSerialNo(NameNodeBlockTokenSecretManager.this.serialNo + 1);
                NameNodeBlockTokenSecretManager.this.nextKey = new BlockKey(NameNodeBlockTokenSecretManager.this.serialNo, Time.now() + 3L * NameNodeBlockTokenSecretManager.this.keyUpdateInterval + NameNodeBlockTokenSecretManager.this.tokenLifetime, NameNodeBlockTokenSecretManager.this.generateSecret());
                NameNodeBlockTokenSecretManager.this.nextKey.setKeyType(BlockKey.KeyType.NextKey);
                HdfsVariables.updateBlockTokenKeys(NameNodeBlockTokenSecretManager.this.currentKey, NameNodeBlockTokenSecretManager.this.nextKey, currentKeyFromDB);
                return true;
            }
        }.handle();
    }

    private boolean isLeader() {
        if (this.namesystem != null) {
            return this.namesystem.isLeader();
        }
        return false;
    }
}

