/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.transaction.lock.BaseIndividualBlockLock;
import io.hops.transaction.lock.BatchedINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;

public final class SqlBatchedBlocksLock
extends BaseIndividualBlockLock {
    protected void acquire(TransactionLocks locks) throws IOException {
        Lock inodeLock = locks.getLock(Lock.Type.INode);
        if (!(inodeLock instanceof BatchedINodeLock)) {
            throw new TransactionLocks.LockNotAddedException("HopsBatchedINodeLock wasn't added");
        }
        long[] inodeIds = ((BatchedINodeLock)inodeLock).getINodeIds();
        this.blocks.addAll(this.acquireLockList(DEFAULT_LOCK_TYPE, BlockInfoContiguous.Finder.ByINodeIds, new Object[]{inodeIds}));
    }
}

