/*
 * Decompiled with CFR 0.152.
 */
package io.hops.transaction.lock;

import io.hops.metadata.common.FinderType;
import io.hops.metadata.hdfs.entity.SubTreeOperation;
import io.hops.transaction.lock.BaseINodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hdfs.server.namenode.INode;

public final class SubTreeOpLock
extends Lock {
    private final TransactionLockTypes.LockType lockType;
    private final String pathPrefix;
    public static final Log LOG = LogFactory.getLog(SubTreeOpLock.class);

    SubTreeOpLock(TransactionLockTypes.LockType lockType, String pathPrefix) {
        this.lockType = lockType;
        this.pathPrefix = pathPrefix;
    }

    protected void acquire(TransactionLocks locks) throws IOException {
        String newPath = "";
        newPath = this.pathPrefix.endsWith("/") && this.pathPrefix.length() != 1 ? this.pathPrefix.substring(0, this.pathPrefix.length() - 1) : this.pathPrefix;
        LOG.debug((Object)("Checking if the path \"" + newPath + "\" belongs to a file or a dir"));
        BaseINodeLock inodeLock = (BaseINodeLock)locks.getLock(Lock.Type.INode);
        List<INode> inodes = inodeLock.getPathINodes(newPath);
        if (inodes.get(inodes.size() - 1).isDirectory()) {
            LOG.debug((Object)(newPath + " is a directory so checking the STO table for ongoing operations "));
            this.acquireLockList(this.lockType, (FinderType)SubTreeOperation.Finder.ByPathPrefix, new Object[]{this.pathPrefix});
        } else {
            LOG.debug((Object)"The last component of the path is not dir. ignoring the request to look in on going STO table");
        }
    }

    protected final Lock.Type getType() {
        return Lock.Type.SubTreePath;
    }

    public TransactionLockTypes.LockType getLockType() {
        return this.lockType;
    }
}

