/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import io.hops.transaction.handler.HDFSOperationType;
import io.hops.transaction.handler.HopsTransactionalRequestHandler;
import io.hops.transaction.lock.INodeLock;
import io.hops.transaction.lock.Lock;
import io.hops.transaction.lock.LockFactory;
import io.hops.transaction.lock.TransactionLockTypes;
import io.hops.transaction.lock.TransactionLocks;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.AclStorage;
import org.apache.hadoop.hdfs.server.namenode.AclTransformation;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodesInPath;

class FSDirAclOp {
    FSDirAclOp() {
    }

    static HdfsFileStatus modifyAclEntries(final FSDirectory fsd, String srcArg, final List<AclEntry> aclSpec) throws IOException {
        FSDirAclOp.checkAclsConfigFlag(fsd);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(srcArg, pathComponents);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.MODIFY_ACL_ENTRIES){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(false);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
                fsd.checkOwner(pc, iip);
                AclStorage.validateAclSpec(aclSpec);
                INode inode = FSDirectory.resolveLastINode(iip);
                if (aclSpec.size() == 1 && ((AclEntry)aclSpec.get(0)).getType().equals((Object)AclEntryType.MASK)) {
                    FsPermission fsPermission = inode.getFsPermission();
                    inode.setPermission(new FsPermission(fsPermission.getUserAction(), ((AclEntry)aclSpec.get(0)).getPermission(), fsPermission.getOtherAction()));
                    return AclStorage.readINodeLogicalAcl(inode);
                }
                List<AclEntry> existingAcl = AclStorage.hasOwnAcl(inode) ? AclStorage.readINodeLogicalAcl(inode) : AclStorage.getMinimalAcl(inode);
                List<AclEntry> newAcl = AclTransformation.mergeAclEntries(existingAcl, aclSpec);
                AclStorage.updateINodeAcl(inode, newAcl);
                return fsd.getAuditFileInfo(iip);
            }
        }.handle();
    }

    static HdfsFileStatus removeAclEntries(final FSDirectory fsd, String srcArg, final List<AclEntry> aclSpec) throws IOException {
        FSDirAclOp.checkAclsConfigFlag(fsd);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(srcArg, pathComponents);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.REMOVE_ACL_ENTRIES){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
                fsd.checkOwner(pc, iip);
                AclStorage.validateAclSpec(aclSpec);
                INode inode = FSDirectory.resolveLastINode(iip);
                List<AclEntry> existingAcl = AclStorage.hasOwnAcl(inode) ? AclStorage.readINodeLogicalAcl(inode) : AclStorage.getMinimalAcl(inode);
                List<AclEntry> newAcl = AclTransformation.filterAclEntriesByAclSpec(existingAcl, aclSpec);
                AclStorage.updateINodeAcl(inode, newAcl);
                return fsd.getAuditFileInfo(iip);
            }
        }.handle();
    }

    static HdfsFileStatus removeDefaultAcl(final FSDirectory fsd, String srcArg) throws IOException {
        FSDirAclOp.checkAclsConfigFlag(fsd);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(srcArg, pathComponents);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.REMOVE_DEFAULT_ACL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
                fsd.checkOwner(pc, iip);
                INode inode = FSDirectory.resolveLastINode(iip);
                List<AclEntry> existingAcl = AclStorage.hasOwnAcl(inode) ? AclStorage.readINodeLogicalAcl(inode) : AclStorage.getMinimalAcl(inode);
                List<AclEntry> newAcl = AclTransformation.filterDefaultAclEntries(existingAcl);
                AclStorage.updateINodeAcl(inode, newAcl);
                return fsd.getAuditFileInfo(iip);
            }
        }.handle();
    }

    static HdfsFileStatus removeAcl(final FSDirectory fsd, String srcArg) throws IOException {
        FSDirAclOp.checkAclsConfigFlag(fsd);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(srcArg, pathComponents);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.REMOVE_ACL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath4Write(src);
                fsd.checkOwner(pc, iip);
                FSDirAclOp.unprotectedRemoveAcl(fsd, iip);
                return fsd.getAuditFileInfo(iip);
            }
        }.handle();
    }

    static HdfsFileStatus setAcl(final FSDirectory fsd, String srcArg, final List<AclEntry> aclSpec) throws IOException {
        FSDirAclOp.checkAclsConfigFlag(fsd);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(srcArg, pathComponents);
        return (HdfsFileStatus)new HopsTransactionalRequestHandler(HDFSOperationType.SET_ACL){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.WRITE, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath4Write(src);
                fsd.checkOwner(pc, iip);
                List<AclEntry> newAcl = FSDirAclOp.unprotectedSetAcl(fsd, src, aclSpec);
                return fsd.getAuditFileInfo(iip);
            }
        }.handle();
    }

    static AclStatus getAclStatus(final FSDirectory fsd, String srcArg) throws IOException {
        FSDirAclOp.checkAclsConfigFlag(fsd);
        byte[][] pathComponents = FSDirectory.getPathComponentsForReservedPath(srcArg);
        final String src = fsd.resolvePath(srcArg, pathComponents);
        return (AclStatus)new HopsTransactionalRequestHandler(HDFSOperationType.GET_ACL_STATUS){

            public void acquireLock(TransactionLocks locks) throws IOException {
                LockFactory lf = LockFactory.getInstance();
                INodeLock il = lf.getINodeLock(TransactionLockTypes.INodeLockType.READ, TransactionLockTypes.INodeResolveType.PATH, src).setNameNodeID(fsd.getFSNamesystem().getNamenodeId()).setActiveNameNodes(fsd.getFSNamesystem().getNameNode().getActiveNameNodes().getActiveNodes()).skipReadingQuotaAttr(true);
                locks.add((Lock)il);
                locks.add(lf.getAcesLock());
            }

            public Object performTask() throws IOException {
                FSPermissionChecker pc = fsd.getPermissionChecker();
                INodesInPath iip = fsd.getINodesInPath(src, true);
                if (fsd.isPermissionEnabled()) {
                    fsd.checkTraverse(pc, iip);
                }
                INode inode = FSDirectory.resolveLastINode(iip);
                List<AclEntry> acl = AclStorage.readINodeAcl(inode);
                FsPermission fsPermission = inode.getFsPermission();
                return new AclStatus.Builder().owner(inode.getUserName()).group(inode.getGroupName()).stickyBit(fsPermission.getStickyBit()).setPermission(fsPermission).addEntries(acl).build();
            }
        }.handle();
    }

    static List<AclEntry> unprotectedSetAcl(FSDirectory fsd, String src, List<AclEntry> aclSpec) throws IOException {
        INodesInPath iip = fsd.getINodesInPath4Write(FSDirectory.normalizePath(src), true);
        AclStorage.validateAclSpec(aclSpec);
        if (aclSpec.isEmpty()) {
            FSDirAclOp.unprotectedRemoveAcl(fsd, iip);
            return AclFeature.EMPTY_ENTRY_LIST;
        }
        INode inode = FSDirectory.resolveLastINode(iip);
        List<AclEntry> existingAcl = AclStorage.hasOwnAcl(inode) ? AclStorage.readINodeLogicalAcl(inode) : AclStorage.getMinimalAcl(inode);
        List<AclEntry> newAcl = AclTransformation.replaceAclEntries(existingAcl, aclSpec);
        AclStorage.updateINodeAcl(inode, newAcl);
        return newAcl;
    }

    private static void checkAclsConfigFlag(FSDirectory fsd) throws AclException {
        if (!fsd.isAclsEnabled()) {
            throw new AclException(String.format("The ACL operation has been rejected.  Support for ACLs has been disabled by setting %s to false.", "dfs.namenode.acls.enabled"));
        }
    }

    private static void unprotectedRemoveAcl(FSDirectory fsd, INodesInPath iip) throws IOException {
        INode inode = FSDirectory.resolveLastINode(iip);
        AclFeature f = inode.getAclFeature();
        if (inode.getNumAces() <= 0) {
            return;
        }
        FsPermission perm = inode.getFsPermission();
        List<AclEntry> featureEntries = f.getEntries();
        if (featureEntries.get(0).getScope() == AclEntryScope.ACCESS) {
            AclEntry groupEntryKey = new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.GROUP).build();
            int groupEntryIndex = Collections.binarySearch(featureEntries, groupEntryKey, AclTransformation.ACL_ENTRY_COMPARATOR);
            assert (groupEntryIndex >= 0);
            FsAction groupPerm = featureEntries.get(groupEntryIndex).getPermission();
            FsPermission newPerm = new FsPermission(perm.getUserAction(), groupPerm, perm.getOtherAction(), perm.getStickyBit());
            inode.setPermission(newPerm);
        }
        inode.removeAclFeature();
    }
}

